/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class TierListOffsetResponseData
implements ApiMessage {
    private List<TierListOffsetTopicResponse> topics = new ArrayList<TierListOffsetTopicResponse>();
    public static final Schema SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(TierListOffsetTopicResponse.SCHEMA_0), "Each topic in the response."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public TierListOffsetResponseData(Readable readable, short version) {
        this.read(readable, version);
    }

    public TierListOffsetResponseData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public TierListOffsetResponseData() {
    }

    @Override
    public short apiKey() {
        return Short.MAX_VALUE;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics = null;
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new TierListOffsetTopicResponse(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.topics.size());
        for (TierListOffsetTopicResponse element : this.topics) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<TierListOffsetTopicResponse>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new TierListOffsetTopicResponse((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (TierListOffsetTopicResponse element : this.topics) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        for (TierListOffsetTopicResponse element : this.topics) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TierListOffsetResponseData)) {
            return false;
        }
        TierListOffsetResponseData other = (TierListOffsetResponseData)obj;
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "TierListOffsetResponseData(topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public List<TierListOffsetTopicResponse> topics() {
        return this.topics;
    }

    public TierListOffsetResponseData setTopics(List<TierListOffsetTopicResponse> v) {
        this.topics = v;
        return this;
    }

    public static class TierListOffsetPartitionResponse
    implements Message {
        private int partitionIndex;
        private short errorCode;
        private long offset;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The partition error code, or 0 if there was no error."), new Field("offset", Type.INT64, ""));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public TierListOffsetPartitionResponse(Readable readable, short version) {
            this.read(readable, version);
        }

        public TierListOffsetPartitionResponse(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public TierListOffsetPartitionResponse() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.offset = 0L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.errorCode = readable.readShort();
            this.offset = readable.readLong();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeShort(this.errorCode);
            writable.writeLong(this.offset);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
            this.offset = struct.getLong("offset");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("offset", (Object)this.offset);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            size += 2;
            return size += 8;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TierListOffsetPartitionResponse)) {
                return false;
            }
            TierListOffsetPartitionResponse other = (TierListOffsetPartitionResponse)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            return this.offset == other.offset;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + ((int)(this.offset >> 32) ^ (int)this.offset);
            return hashCode;
        }

        public String toString() {
            return "TierListOffsetPartitionResponse(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", offset=" + this.offset + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public long offset() {
            return this.offset;
        }

        public TierListOffsetPartitionResponse setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public TierListOffsetPartitionResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public TierListOffsetPartitionResponse setOffset(long v) {
            this.offset = v;
            return this;
        }
    }

    public static class TierListOffsetTopicResponse
    implements Message {
        private String name;
        private List<TierListOffsetPartitionResponse> partitions;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name"), new Field("partitions", new ArrayOf(TierListOffsetPartitionResponse.SCHEMA_0), "Each partition in the response."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public TierListOffsetTopicResponse(Readable readable, short version) {
            this.partitions = new ArrayList<TierListOffsetPartitionResponse>();
            this.read(readable, version);
        }

        public TierListOffsetTopicResponse(Struct struct, short version) {
            this.partitions = new ArrayList<TierListOffsetPartitionResponse>();
            this.fromStruct(struct, version);
        }

        public TierListOffsetTopicResponse() {
            this.name = "";
            this.partitions = new ArrayList<TierListOffsetPartitionResponse>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions = null;
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new TierListOffsetPartitionResponse(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (TierListOffsetPartitionResponse element : this.partitions) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<TierListOffsetPartitionResponse>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new TierListOffsetPartitionResponse((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (TierListOffsetPartitionResponse element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            for (TierListOffsetPartitionResponse element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TierListOffsetTopicResponse)) {
                return false;
            }
            TierListOffsetTopicResponse other = (TierListOffsetTopicResponse)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "TierListOffsetTopicResponse(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<TierListOffsetPartitionResponse> partitions() {
            return this.partitions;
        }

        public TierListOffsetTopicResponse setName(String v) {
            this.name = v;
            return this;
        }

        public TierListOffsetTopicResponse setPartitions(List<TierListOffsetPartitionResponse> v) {
            this.partitions = v;
            return this;
        }
    }
}

