/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.PlaintextTransportLayer;
import org.apache.kafka.common.network.SslTransportLayer;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.Login;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.authenticator.DefaultLogin;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.authenticator.SaslClientAuthenticator;
import org.apache.kafka.common.security.authenticator.SaslClientCallbackHandler;
import org.apache.kafka.common.security.authenticator.SaslServerAuthenticator;
import org.apache.kafka.common.security.authenticator.SaslServerCallbackHandler;
import org.apache.kafka.common.security.kerberos.KerberosClientCallbackHandler;
import org.apache.kafka.common.security.kerberos.KerberosLogin;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerRefreshingLogin;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslClientCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredValidatorCallbackHandler;
import org.apache.kafka.common.security.plain.internals.PlainServerCallbackHandler;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.scram.internals.ScramServerCallbackHandler;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.Java;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslChannelBuilder
implements ChannelBuilder,
ListenerReconfigurable {
    private static final Logger log = LoggerFactory.getLogger(SaslChannelBuilder.class);
    private final SecurityProtocol securityProtocol;
    private final ListenerName listenerName;
    private final boolean isInterBrokerListener;
    private final String clientSaslMechanism;
    private final Mode mode;
    private final Map<String, JaasContext> jaasContexts;
    private final boolean handshakeRequestEnable;
    private final CredentialCache credentialCache;
    private final DelegationTokenCache tokenCache;
    private final Map<String, LoginManager> loginManagers;
    private final Map<String, Subject> subjects;
    private SslFactory sslFactory;
    private Map<String, ?> configs;
    private KerberosShortNamer kerberosShortNamer;
    private Map<String, AuthenticateCallbackHandler> saslCallbackHandlers;
    private Map<String, Long> connectionsMaxReauthMsByMechanism;
    private final Time time;

    public SaslChannelBuilder(Mode mode, Map<String, JaasContext> jaasContexts, SecurityProtocol securityProtocol, ListenerName listenerName, boolean isInterBrokerListener, String clientSaslMechanism, boolean handshakeRequestEnable, CredentialCache credentialCache, DelegationTokenCache tokenCache, Time time) {
        this.mode = mode;
        this.jaasContexts = jaasContexts;
        this.loginManagers = new HashMap<String, LoginManager>(jaasContexts.size());
        this.subjects = new HashMap<String, Subject>(jaasContexts.size());
        this.securityProtocol = securityProtocol;
        this.listenerName = listenerName;
        this.isInterBrokerListener = isInterBrokerListener;
        this.handshakeRequestEnable = handshakeRequestEnable;
        this.clientSaslMechanism = clientSaslMechanism;
        this.credentialCache = credentialCache;
        this.tokenCache = tokenCache;
        this.saslCallbackHandlers = new HashMap<String, AuthenticateCallbackHandler>();
        this.connectionsMaxReauthMsByMechanism = new HashMap<String, Long>();
        this.time = time;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        try {
            this.configs = configs;
            if (this.mode == Mode.SERVER) {
                this.createServerCallbackHandlers(configs);
                this.createConnectionsMaxReauthMsMap(configs);
            } else {
                this.createClientCallbackHandler(configs);
            }
            for (Map.Entry<String, AuthenticateCallbackHandler> entry : this.saslCallbackHandlers.entrySet()) {
                String mechanism = entry.getKey();
                entry.getValue().configure(configs, mechanism, this.jaasContexts.get(mechanism).configurationEntries());
            }
            Class<? extends Login> defaultLoginClass = this.defaultLoginClass(configs);
            if (this.jaasContexts.containsKey("GSSAPI")) {
                String defaultRealm;
                try {
                    defaultRealm = SaslChannelBuilder.defaultKerberosRealm();
                }
                catch (Exception ke) {
                    defaultRealm = "";
                }
                List principalToLocalRules = (List)configs.get("sasl.kerberos.principal.to.local.rules");
                if (principalToLocalRules != null) {
                    this.kerberosShortNamer = KerberosShortNamer.fromUnparsedRules(defaultRealm, principalToLocalRules);
                }
            }
            for (Map.Entry<String, JaasContext> entry : this.jaasContexts.entrySet()) {
                String mechanism = entry.getKey();
                LoginManager loginManager = LoginManager.acquireLoginManager(entry.getValue(), mechanism, defaultLoginClass, configs);
                this.loginManagers.put(mechanism, loginManager);
                this.subjects.put(mechanism, loginManager.subject());
            }
            if (this.securityProtocol == SecurityProtocol.SASL_SSL) {
                this.sslFactory = new SslFactory(this.mode, "none", this.isInterBrokerListener);
                this.sslFactory.configure(configs);
            }
        }
        catch (Throwable e) {
            this.close();
            throw new KafkaException(e);
        }
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return this.securityProtocol == SecurityProtocol.SASL_SSL ? SslConfigs.RECONFIGURABLE_CONFIGS : Collections.emptySet();
    }

    @Override
    public void validateReconfiguration(Map<String, ?> configs) {
        if (this.securityProtocol == SecurityProtocol.SASL_SSL) {
            this.sslFactory.validateReconfiguration(configs);
        }
    }

    @Override
    public void reconfigure(Map<String, ?> configs) {
        if (this.securityProtocol == SecurityProtocol.SASL_SSL) {
            this.sslFactory.reconfigure(configs);
        }
    }

    @Override
    public ListenerName listenerName() {
        return this.listenerName;
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize, MemoryPool memoryPool) throws KafkaException {
        try {
            Supplier<Authenticator> authenticatorCreator;
            SocketChannel socketChannel = (SocketChannel)key.channel();
            Socket socket = socketChannel.socket();
            TransportLayer transportLayer = this.buildTransportLayer(id, key, socketChannel);
            if (this.mode == Mode.SERVER) {
                authenticatorCreator = () -> this.buildServerAuthenticator(this.configs, Collections.unmodifiableMap(this.saslCallbackHandlers), id, transportLayer, Collections.unmodifiableMap(this.subjects), Collections.unmodifiableMap(this.connectionsMaxReauthMsByMechanism));
            } else {
                LoginManager loginManager = this.loginManagers.get(this.clientSaslMechanism);
                authenticatorCreator = () -> this.buildClientAuthenticator(this.configs, this.saslCallbackHandlers.get(this.clientSaslMechanism), id, socket.getInetAddress().getHostName(), loginManager.serviceName(), transportLayer, this.subjects.get(this.clientSaslMechanism));
            }
            BrokerInterceptor interceptor = ConfluentConfigs.buildBrokerInterceptor(this.mode, this.configs);
            return new KafkaChannel(id, transportLayer, authenticatorCreator, maxReceiveSize, memoryPool != null ? memoryPool : MemoryPool.NONE, interceptor);
        }
        catch (Exception e) {
            log.info("Failed to create channel due to ", (Throwable)e);
            throw new KafkaException(e);
        }
    }

    @Override
    public void close() {
        for (LoginManager loginManager : this.loginManagers.values()) {
            loginManager.release();
        }
        this.loginManagers.clear();
        for (AuthenticateCallbackHandler handler : this.saslCallbackHandlers.values()) {
            handler.close();
        }
    }

    protected TransportLayer buildTransportLayer(String id, SelectionKey key, SocketChannel socketChannel) throws IOException {
        if (this.securityProtocol == SecurityProtocol.SASL_SSL) {
            return SslTransportLayer.create(id, key, this.sslFactory.createSslEngine(socketChannel.socket().getInetAddress().getHostName(), socketChannel.socket().getPort()));
        }
        return new PlaintextTransportLayer(key);
    }

    protected SaslServerAuthenticator buildServerAuthenticator(Map<String, ?> configs, Map<String, AuthenticateCallbackHandler> callbackHandlers, String id, TransportLayer transportLayer, Map<String, Subject> subjects, Map<String, Long> connectionsMaxReauthMsByMechanism) {
        return new SaslServerAuthenticator(configs, callbackHandlers, id, subjects, this.kerberosShortNamer, this.listenerName, this.securityProtocol, transportLayer, connectionsMaxReauthMsByMechanism, this.time);
    }

    protected SaslClientAuthenticator buildClientAuthenticator(Map<String, ?> configs, AuthenticateCallbackHandler callbackHandler, String id, String serverHost, String servicePrincipal, TransportLayer transportLayer, Subject subject) {
        return new SaslClientAuthenticator(configs, callbackHandler, id, subject, servicePrincipal, serverHost, this.clientSaslMechanism, this.handshakeRequestEnable, transportLayer, this.time);
    }

    Map<String, LoginManager> loginManagers() {
        return this.loginManagers;
    }

    private static String defaultKerberosRealm() throws ClassNotFoundException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> classRef = Java.isIbmJdk() ? Class.forName("com.ibm.security.krb5.internal.Config") : Class.forName("sun.security.krb5.Config");
        Method getInstanceMethod = classRef.getMethod("getInstance", new Class[0]);
        Object kerbConf = getInstanceMethod.invoke(classRef, new Object[0]);
        Method getDefaultRealmMethod = classRef.getDeclaredMethod("getDefaultRealm", new Class[0]);
        return (String)getDefaultRealmMethod.invoke(kerbConf, new Object[0]);
    }

    private void createClientCallbackHandler(Map<String, ?> configs) {
        Class<? extends AuthenticateCallbackHandler> clazz = (Class<? extends AuthenticateCallbackHandler>)configs.get("sasl.client.callback.handler.class");
        if (clazz == null) {
            clazz = this.clientCallbackHandlerClass();
        }
        AuthenticateCallbackHandler callbackHandler = (AuthenticateCallbackHandler)Utils.newInstance(clazz);
        this.saslCallbackHandlers.put(this.clientSaslMechanism, callbackHandler);
    }

    private void createServerCallbackHandlers(Map<String, ?> configs) throws ClassNotFoundException {
        for (String mechanism : this.jaasContexts.keySet()) {
            String prefix = ListenerName.saslMechanismPrefix(mechanism);
            Class clazz = (Class)configs.get(prefix + "sasl.server.callback.handler.class");
            AuthenticateCallbackHandler callbackHandler = clazz != null ? (AuthenticateCallbackHandler)Utils.newInstance(clazz) : (mechanism.equals("PLAIN") ? new PlainServerCallbackHandler() : (ScramMechanism.isScram(mechanism) ? new ScramServerCallbackHandler(this.credentialCache.cache(mechanism, ScramCredential.class), this.tokenCache) : (mechanism.equals("OAUTHBEARER") ? new OAuthBearerUnsecuredValidatorCallbackHandler() : new SaslServerCallbackHandler())));
            this.saslCallbackHandlers.put(mechanism, callbackHandler);
        }
    }

    private void createConnectionsMaxReauthMsMap(Map<String, ?> configs) {
        for (String mechanism : this.jaasContexts.keySet()) {
            String prefix = ListenerName.saslMechanismPrefix(mechanism);
            Long connectionsMaxReauthMs = (Long)configs.get(prefix + "connections.max.reauth.ms");
            if (connectionsMaxReauthMs == null) {
                connectionsMaxReauthMs = (Long)configs.get("connections.max.reauth.ms");
            }
            if (connectionsMaxReauthMs == null) continue;
            this.connectionsMaxReauthMsByMechanism.put(mechanism, connectionsMaxReauthMs);
        }
    }

    private Class<? extends Login> defaultLoginClass(Map<String, ?> configs) {
        if (this.jaasContexts.containsKey("GSSAPI")) {
            return KerberosLogin.class;
        }
        if ("OAUTHBEARER".equals(this.clientSaslMechanism)) {
            return OAuthBearerRefreshingLogin.class;
        }
        return DefaultLogin.class;
    }

    private Class<? extends AuthenticateCallbackHandler> clientCallbackHandlerClass() {
        switch (this.clientSaslMechanism) {
            case "GSSAPI": {
                return KerberosClientCallbackHandler.class;
            }
            case "OAUTHBEARER": {
                return OAuthBearerSaslClientCallbackHandler.class;
            }
        }
        return SaslClientCallbackHandler.class;
    }
}

