/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class CreateAclsResponse
extends AbstractResponse {
    private final CreateAclsResponseData data;

    public CreateAclsResponse(int throttleTimeMs, List<AclCreationResponse> aclCreationResponses) {
        this.data = new CreateAclsResponseData();
        this.data.setThrottleTimeMs(throttleTimeMs);
        ArrayList<CreateAclsResponseData.CreatableAclResult> results = new ArrayList<CreateAclsResponseData.CreatableAclResult>(aclCreationResponses.size());
        this.data.setResults(results);
        for (AclCreationResponse response : aclCreationResponses) {
            results.add(new CreateAclsResponseData.CreatableAclResult().setErrorCode(response.error.error().code()).setErrorMessage(response.error.message()));
        }
    }

    public CreateAclsResponse(Struct struct, short version) {
        this.data = new CreateAclsResponseData(struct, version);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public List<AclCreationResponse> aclCreationResponses() {
        ArrayList<AclCreationResponse> aclCreationResponses = new ArrayList<AclCreationResponse>(this.data.results().size());
        for (CreateAclsResponseData.CreatableAclResult result : this.data.results()) {
            aclCreationResponses.add(new AclCreationResponse(new ApiError(Errors.forCode(result.errorCode()), result.errorMessage())));
        }
        return aclCreationResponses;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (AclCreationResponse response : this.aclCreationResponses()) {
            this.updateErrorCounts(errorCounts, response.error.error());
        }
        return errorCounts;
    }

    public static CreateAclsResponse parse(ByteBuffer buffer, short version) {
        return new CreateAclsResponse(ApiKeys.CREATE_ACLS.responseSchema(version).read(buffer), version);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    public static class AclCreationResponse {
        private final ApiError error;

        public AclCreationResponse(ApiError error) {
            this.error = error;
        }

        public ApiError error() {
            return this.error;
        }

        public String toString() {
            return "(" + this.error + ")";
        }
    }
}

