/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Utils;

public class DeleteAclsRequest
extends AbstractRequest {
    private final DeleteAclsRequestData data;

    DeleteAclsRequest(short version, List<AclBindingFilter> filters) {
        this(version, new DeleteAclsRequestData().setFilters(filters.stream().map(DeleteAclsRequest::toDeleteFilter).collect(Collectors.toList())));
        this.validate(version, filters);
    }

    DeleteAclsRequest(short version, DeleteAclsRequestData data) {
        super(ApiKeys.DELETE_ACLS, version);
        this.data = data;
    }

    public DeleteAclsRequest(Struct struct, short version) {
        super(ApiKeys.DELETE_ACLS, version);
        this.data = new DeleteAclsRequestData(struct, version);
    }

    public List<AclBindingFilter> filters() {
        return this.data.filters().stream().map(DeleteAclsRequest::toAclBindingFilter).collect(Collectors.toList());
    }

    public Optional<String> clusterId() {
        String clusterId = this.data.clusterId();
        return clusterId == null || clusterId.isEmpty() ? Optional.empty() : Optional.of(clusterId);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable throwable) {
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: 
            case 2: {
                ArrayList<DeleteAclsResponse.AclFilterResponse> responses = new ArrayList<DeleteAclsResponse.AclFilterResponse>();
                for (int i = 0; i < this.data.filters().size(); ++i) {
                    responses.add(new DeleteAclsResponse.AclFilterResponse(ApiError.fromThrowable(throwable), Collections.emptySet()));
                }
                return new DeleteAclsResponse(throttleTimeMs, responses);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.DELETE_ACLS.latestVersion()));
    }

    public static DeleteAclsRequest parse(ByteBuffer buffer, short version) {
        return new DeleteAclsRequest(ApiKeys.DELETE_ACLS.parseRequest(version, buffer), version);
    }

    private void validate(short version, List<AclBindingFilter> filters) {
        boolean unsupported;
        if (version == 0 && (unsupported = filters.stream().map(AclBindingFilter::patternFilter).map(ResourcePatternFilter::patternType).anyMatch(patternType -> patternType != PatternType.LITERAL && patternType != PatternType.ANY))) {
            throw new UnsupportedVersionException("Version 0 only supports literal resource pattern types");
        }
        boolean unknown = filters.stream().anyMatch(AclBindingFilter::isUnknown);
        if (unknown) {
            throw new IllegalArgumentException("Filters contain UNKNOWN elements");
        }
    }

    private static DeleteAclsRequestData.DeleteAclsFilter toDeleteFilter(AclBindingFilter filter) {
        return new DeleteAclsRequestData.DeleteAclsFilter().setResourceNameFilter(filter.patternFilter().name()).setResourceTypeFilter(filter.patternFilter().resourceType().code()).setPatternTypeFilter(filter.patternFilter().patternType().code()).setHostFilter(filter.entryFilter().host()).setOperation(filter.entryFilter().operation().code()).setPermissionType(filter.entryFilter().permissionType().code()).setPrincipalFilter(filter.entryFilter().principal());
    }

    private static AclBindingFilter toAclBindingFilter(DeleteAclsRequestData.DeleteAclsFilter filter) {
        ResourcePatternFilter patternFilter = new ResourcePatternFilter(ResourceType.fromCode(filter.resourceTypeFilter()), filter.resourceNameFilter(), PatternType.fromCode(filter.patternTypeFilter()));
        AccessControlEntryFilter entryFilter = new AccessControlEntryFilter(filter.principalFilter(), filter.hostFilter(), AclOperation.fromCode(filter.operation()), AclPermissionType.fromCode(filter.permissionType()));
        return new AclBindingFilter(patternFilter, entryFilter);
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteAclsRequest> {
        private final DeleteAclsRequestData data;

        public Builder(List<AclBindingFilter> filters) {
            this(new DeleteAclsRequestData().setFilters(filters.stream().map(x$0 -> DeleteAclsRequest.toDeleteFilter(x$0)).collect(Collectors.toList())));
        }

        public Builder(DeleteAclsRequestData data) {
            super(ApiKeys.DELETE_ACLS);
            this.data = data;
        }

        @Override
        public DeleteAclsRequest build(short version) {
            return new DeleteAclsRequest(version, this.data);
        }

        public Builder setClusterId(String clusterId) {
            this.data.setClusterId(clusterId);
            return this;
        }

        public String toString() {
            return "(type=DeleteAclsRequest, filters=" + Utils.join(this.data.filters(), ", ") + ")";
        }
    }
}

