/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAclsResponse
extends AbstractResponse {
    public static final Logger log = LoggerFactory.getLogger(DeleteAclsResponse.class);
    private final DeleteAclsResponseData data;

    public DeleteAclsResponse(int throttleTimeMs, List<AclFilterResponse> responses) {
        this.data = new DeleteAclsResponseData().setThrottleTimeMs(throttleTimeMs).setFilterResults(responses.stream().map(this::toResult).collect(Collectors.toList()));
    }

    public DeleteAclsResponse(Struct struct, short version) {
        this.data = new DeleteAclsResponseData(struct, version);
    }

    @Override
    protected Struct toStruct(short version) {
        this.validate(version);
        return this.data.toStruct(version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public List<AclFilterResponse> responses() {
        return this.data.filterResults().stream().map(this::toFilterResponse).collect(Collectors.toList());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (AclFilterResponse response : this.responses()) {
            this.updateErrorCounts(errorCounts, response.error.error());
        }
        return errorCounts;
    }

    public static DeleteAclsResponse parse(ByteBuffer buffer, short version) {
        return new DeleteAclsResponse(ApiKeys.DELETE_ACLS.parseResponse(version, buffer), version);
    }

    public String toString() {
        return "(responses=" + Utils.join(this.responses(), ",") + ")";
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    private void validate(short version) {
        boolean unsupported;
        if (version == 0 && (unsupported = this.responses().stream().flatMap(r -> ((AclFilterResponse)r).deletions.stream()).map(AclDeletionResult::acl).map(AclBinding::pattern).map(ResourcePattern::patternType).anyMatch(patternType -> patternType != PatternType.LITERAL))) {
            throw new UnsupportedVersionException("Version 0 only supports literal resource pattern types");
        }
        boolean unknown = this.responses().stream().flatMap(r -> ((AclFilterResponse)r).deletions.stream()).map(AclDeletionResult::acl).anyMatch(AclBinding::isUnknown);
        if (unknown) {
            throw new IllegalArgumentException("Response contains UNKNOWN elements");
        }
    }

    private DeleteAclsResponseData.DeleteAclsFilterResult toResult(AclFilterResponse filterResponse) {
        return new DeleteAclsResponseData.DeleteAclsFilterResult().setErrorCode(filterResponse.error.error().code()).setErrorMessage(filterResponse.error.message()).setMatchingAcls(filterResponse.deletions.stream().map(this::toMatchingAcl).collect(Collectors.toList()));
    }

    private DeleteAclsResponseData.DeleteAclsMatchingAcl toMatchingAcl(AclDeletionResult result) {
        return new DeleteAclsResponseData.DeleteAclsMatchingAcl().setErrorCode(result.error.error().code()).setErrorMessage(result.error.message()).setResourceName(result.acl.pattern().name()).setResourceType(result.acl.pattern().resourceType().code()).setPatternType(result.acl.pattern().patternType().code()).setHost(result.acl.entry().host()).setOperation(result.acl.entry().operation().code()).setPermissionType(result.acl.entry().permissionType().code()).setPrincipal(result.acl.entry().principal());
    }

    private AclFilterResponse toFilterResponse(DeleteAclsResponseData.DeleteAclsFilterResult result) {
        return new AclFilterResponse(new ApiError(Errors.forCode(result.errorCode()), result.errorMessage()), result.matchingAcls().stream().map(this::toDeletionResult).collect(Collectors.toList()));
    }

    private AclDeletionResult toDeletionResult(DeleteAclsResponseData.DeleteAclsMatchingAcl result) {
        ResourcePattern pattern = new ResourcePattern(ResourceType.fromCode(result.resourceType()), result.resourceName(), PatternType.fromCode(result.patternType()));
        AccessControlEntry entry = new AccessControlEntry(result.principal(), result.host(), AclOperation.fromCode(result.operation()), AclPermissionType.fromCode(result.permissionType()));
        return new AclDeletionResult(new ApiError(Errors.forCode(result.errorCode()), result.errorMessage()), new AclBinding(pattern, entry));
    }

    public static class AclFilterResponse {
        private final ApiError error;
        private final Collection<AclDeletionResult> deletions;

        public AclFilterResponse(ApiError error, Collection<AclDeletionResult> deletions) {
            this.error = error;
            this.deletions = deletions;
        }

        public AclFilterResponse(Collection<AclDeletionResult> deletions) {
            this(ApiError.NONE, deletions);
        }

        public ApiError error() {
            return this.error;
        }

        public Collection<AclDeletionResult> deletions() {
            return this.deletions;
        }

        public String toString() {
            return "(error=" + this.error + ", deletions=" + Utils.join(this.deletions, ",") + ")";
        }
    }

    public static class AclDeletionResult {
        private final ApiError error;
        private final AclBinding acl;

        public AclDeletionResult(ApiError error, AclBinding acl) {
            this.error = error;
            this.acl = acl;
        }

        public AclDeletionResult(AclBinding acl) {
            this(ApiError.NONE, acl);
        }

        public ApiError error() {
            return this.error;
        }

        public AclBinding acl() {
            return this.acl;
        }

        public String toString() {
            return "(error=" + this.error + ", acl=" + this.acl + ")";
        }
    }
}

