/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.ConfluentLeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.utils.FlattenedIterator;
import org.apache.kafka.common.utils.MappedIterator;
import org.apache.kafka.common.utils.Utils;

public class LeaderAndIsrRequest
extends AbstractControlRequest {
    private final Message data;

    LeaderAndIsrRequest(LeaderAndIsrRequestData data, short version) {
        this((Message)data, version);
    }

    private LeaderAndIsrRequest(Message data, short version) {
        super(data instanceof ConfluentLeaderAndIsrRequestData ? ApiKeys.CONFLUENT_LEADER_AND_ISR : ApiKeys.LEADER_AND_ISR, version);
        this.data = data;
        this.normalize();
    }

    private void normalize() {
        if (!(this.data instanceof ConfluentLeaderAndIsrRequestData)) {
            LeaderAndIsrRequestData requestData = (LeaderAndIsrRequestData)this.data;
            if (this.version() >= 2) {
                for (LeaderAndIsrRequestData.LeaderAndIsrTopicState topicState : requestData.topicStates()) {
                    for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState : topicState.partitionStates()) {
                        partitionState.setTopicName(topicState.topicName());
                    }
                }
            }
        }
    }

    public LeaderAndIsrRequest(Struct struct, short version, boolean useConfluentRequest) {
        this(useConfluentRequest ? new ConfluentLeaderAndIsrRequestData(struct, version) : new LeaderAndIsrRequestData(struct, version), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    @Override
    public LeaderAndIsrResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        LeaderAndIsrResponseData responseData = new LeaderAndIsrResponseData();
        Errors error = Errors.forException(e);
        responseData.setErrorCode(error.code());
        ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = new ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError>();
        for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState partition : this.partitionStates()) {
            partitions.add(new LeaderAndIsrResponseData.LeaderAndIsrPartitionError().setTopicName(partition.topicName()).setPartitionIndex(partition.partitionIndex()).setErrorCode(error.code()));
        }
        responseData.setPartitionErrors(partitions);
        return new LeaderAndIsrResponse(responseData, this.isConfluentRequest());
    }

    @Override
    public int controllerId() {
        if (this.data instanceof ConfluentLeaderAndIsrRequestData) {
            return ((ConfluentLeaderAndIsrRequestData)this.data).controllerId();
        }
        return ((LeaderAndIsrRequestData)this.data).controllerId();
    }

    @Override
    public int controllerEpoch() {
        if (this.data instanceof ConfluentLeaderAndIsrRequestData) {
            return ((ConfluentLeaderAndIsrRequestData)this.data).controllerEpoch();
        }
        return ((LeaderAndIsrRequestData)this.data).controllerEpoch();
    }

    @Override
    public long brokerEpoch() {
        if (this.data instanceof ConfluentLeaderAndIsrRequestData) {
            return ((ConfluentLeaderAndIsrRequestData)this.data).brokerEpoch();
        }
        return ((LeaderAndIsrRequestData)this.data).brokerEpoch();
    }

    public Iterable<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates() {
        if (this.data instanceof ConfluentLeaderAndIsrRequestData) {
            ConfluentLeaderAndIsrRequestData requestData = (ConfluentLeaderAndIsrRequestData)this.data;
            return () -> new FlattenedIterator(requestData.topicStates().iterator(), topic -> new MappedIterator<ConfluentLeaderAndIsrRequestData.LeaderAndIsrPartitionState, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>(topic.partitionStates().iterator(), partition -> new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topic.topicName()).setTopicId(topic.topicId()).setPartitionIndex(partition.partitionIndex()).setControllerEpoch(partition.controllerEpoch()).setLeader(partition.leader()).setLeaderEpoch(partition.leaderEpoch()).setIsr(partition.isr()).setZkVersion(partition.zkVersion()).setReplicas(partition.replicas()).setIsNew(partition.isNew()).setAddingReplicas(partition.addingReplicas()).setRemovingReplicas(partition.removingReplicas())));
        }
        LeaderAndIsrRequestData requestData = (LeaderAndIsrRequestData)this.data;
        if (this.version() >= 2) {
            return () -> new FlattenedIterator(requestData.topicStates().iterator(), topicState -> topicState.partitionStates().iterator());
        }
        return requestData.ungroupedPartitionStates();
    }

    public List<LeaderAndIsrRequestData.LeaderAndIsrLiveLeader> liveLeaders() {
        if (this.data instanceof ConfluentLeaderAndIsrRequestData) {
            return ((ConfluentLeaderAndIsrRequestData)this.data).liveLeaders().stream().map(leader -> new LeaderAndIsrRequestData.LeaderAndIsrLiveLeader().setBrokerId(leader.brokerId()).setHostName(leader.hostName()).setPort(leader.port())).collect(Collectors.toList());
        }
        return ((LeaderAndIsrRequestData)this.data).liveLeaders();
    }

    protected Message data() {
        return this.data;
    }

    public boolean isConfluentRequest() {
        return this.data instanceof ConfluentLeaderAndIsrRequestData;
    }

    public static LeaderAndIsrRequest parse(ByteBuffer buffer, short version) {
        return new LeaderAndIsrRequest(ApiKeys.LEADER_AND_ISR.parseRequest(version, buffer), version, false);
    }

    public static class Builder
    extends AbstractControlRequest.Builder<LeaderAndIsrRequest> {
        private final List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates;
        private final Collection<Node> liveLeaders;

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates, Collection<Node> liveLeaders) {
            this(ApiKeys.LEADER_AND_ISR, version, controllerId, controllerEpoch, brokerEpoch, partitionStates, liveLeaders);
        }

        private Builder(ApiKeys apiKey, short version, int controllerId, int controllerEpoch, long brokerEpoch, List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates, Collection<Node> liveLeaders) {
            super(apiKey, version, controllerId, controllerEpoch, brokerEpoch);
            this.partitionStates = partitionStates;
            this.liveLeaders = liveLeaders;
        }

        public static Builder create(short version, int controllerId, int controllerEpoch, long brokerEpoch, List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates, Collection<Node> liveLeaders, boolean useConfluentRequest) {
            ApiKeys apiKey = ApiKeys.LEADER_AND_ISR;
            if (useConfluentRequest) {
                apiKey = ApiKeys.CONFLUENT_LEADER_AND_ISR;
                version = version >= 3 ? (short)1 : 0;
            }
            return new Builder(apiKey, version, controllerId, controllerEpoch, brokerEpoch, partitionStates, liveLeaders);
        }

        @Override
        public LeaderAndIsrRequest build(short version) {
            ApiMessage data = this.apiKey() == ApiKeys.CONFLUENT_LEADER_AND_ISR ? this.buildConfluentLeaderAndIsrData() : this.buildLeaderAndIsrData(version);
            return new LeaderAndIsrRequest(data, version);
        }

        private ConfluentLeaderAndIsrRequestData buildConfluentLeaderAndIsrData() {
            List<ConfluentLeaderAndIsrRequestData.LeaderAndIsrLiveLeader> leaders = this.liveLeaders.stream().map(n -> new ConfluentLeaderAndIsrRequestData.LeaderAndIsrLiveLeader().setBrokerId(n.id()).setHostName(n.host()).setPort(n.port())).collect(Collectors.toList());
            Map<String, ConfluentLeaderAndIsrRequestData.LeaderAndIsrTopicState> topicStatesMap = Builder.groupByConfluentTopic(this.partitionStates);
            return new ConfluentLeaderAndIsrRequestData().setControllerId(this.controllerId).setControllerEpoch(this.controllerEpoch).setBrokerEpoch(this.brokerEpoch).setLiveLeaders(leaders).setTopicStates(new ArrayList<ConfluentLeaderAndIsrRequestData.LeaderAndIsrTopicState>(topicStatesMap.values()));
        }

        private LeaderAndIsrRequestData buildLeaderAndIsrData(short version) {
            List<LeaderAndIsrRequestData.LeaderAndIsrLiveLeader> leaders = this.liveLeaders.stream().map(n -> new LeaderAndIsrRequestData.LeaderAndIsrLiveLeader().setBrokerId(n.id()).setHostName(n.host()).setPort(n.port())).collect(Collectors.toList());
            LeaderAndIsrRequestData data = new LeaderAndIsrRequestData().setControllerId(this.controllerId).setControllerEpoch(this.controllerEpoch).setBrokerEpoch(this.brokerEpoch).setLiveLeaders(leaders);
            if (version >= 2) {
                Map<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState> topicStatesMap = Builder.groupByTopic(this.partitionStates);
                data.setTopicStates(new ArrayList<LeaderAndIsrRequestData.LeaderAndIsrTopicState>(topicStatesMap.values()));
            } else {
                data.setUngroupedPartitionStates(this.partitionStates);
            }
            return data;
        }

        private static Map<String, ConfluentLeaderAndIsrRequestData.LeaderAndIsrTopicState> groupByConfluentTopic(List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates) {
            HashMap<String, ConfluentLeaderAndIsrRequestData.LeaderAndIsrTopicState> topicStates = new HashMap<String, ConfluentLeaderAndIsrRequestData.LeaderAndIsrTopicState>();
            for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState partition : partitionStates) {
                ConfluentLeaderAndIsrRequestData.LeaderAndIsrTopicState topicState = topicStates.computeIfAbsent(partition.topicName(), t -> new ConfluentLeaderAndIsrRequestData.LeaderAndIsrTopicState().setTopicName(partition.topicName()).setTopicId(partition.topicId()));
                topicState.partitionStates().add(new ConfluentLeaderAndIsrRequestData.LeaderAndIsrPartitionState().setPartitionIndex(partition.partitionIndex()).setControllerEpoch(partition.controllerEpoch()).setLeader(partition.leader()).setLeaderEpoch(partition.leaderEpoch()).setIsr(partition.isr()).setZkVersion(partition.zkVersion()).setReplicas(partition.replicas()).setIsNew(partition.isNew()).setAddingReplicas(partition.addingReplicas()).setRemovingReplicas(partition.removingReplicas()));
            }
            return topicStates;
        }

        private static Map<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState> groupByTopic(List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates) {
            HashMap<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState> topicStates = new HashMap<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState>();
            for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState partition : partitionStates) {
                LeaderAndIsrRequestData.LeaderAndIsrTopicState topicState = topicStates.computeIfAbsent(partition.topicName(), t -> new LeaderAndIsrRequestData.LeaderAndIsrTopicState().setTopicName(partition.topicName()).setTopicId(partition.topicId()));
                topicState.partitionStates().add(partition);
            }
            return topicStates;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=LeaderAndIsRequest").append(", controllerId=").append(this.controllerId).append(", controllerEpoch=").append(this.controllerEpoch).append(", brokerEpoch=").append(this.brokerEpoch).append(", partitionStates=").append(this.partitionStates).append(", liveLeaders=(").append(Utils.join(this.liveLeaders, ", ")).append(")").append(")");
            return bld.toString();
        }
    }
}

