/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.ReplicaStatusResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class ReplicaStatusResponse
extends AbstractResponse {
    private final ReplicaStatusResponseData data;

    public ReplicaStatusResponse(ReplicaStatusResponseData data) {
        this.data = data;
    }

    public ReplicaStatusResponse(Struct struct, short version) {
        this.data = new ReplicaStatusResponseData(struct, version);
    }

    public ReplicaStatusResponseData data() {
        return this.data;
    }

    public static ReplicaStatusResponse parse(ByteBuffer buffer, short version) {
        return new ReplicaStatusResponse(ApiKeys.REPLICA_STATUS.responseSchema(version).read(buffer), version);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.incrementErrorCount(this.data.errorCode(), errorCounts);
        for (ReplicaStatusResponseData.ReplicaStatusTopicResponse topicResponse : this.data.topics()) {
            for (ReplicaStatusResponseData.ReplicaStatusPartitionResponse partitionResponse : topicResponse.partitions()) {
                this.incrementErrorCount(partitionResponse.errorCode(), errorCounts);
            }
        }
        return errorCounts;
    }

    private void incrementErrorCount(short errorCode, Map<Errors, Integer> errorCounts) {
        Errors error = Errors.forCode(errorCode);
        errorCounts.put(error, errorCounts.getOrDefault((Object)error, 0) + 1);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }
}

