/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.kafka.common.TopicPartition;

public class PartitionStates<S> {
    private final LinkedHashMap<TopicPartition, S> map = new LinkedHashMap();
    private final Set<TopicPartition> partitionSetView = Collections.unmodifiableSet(this.map.keySet());
    private volatile int size = 0;

    public void moveToEnd(TopicPartition topicPartition) {
        Object state = this.map.remove(topicPartition);
        if (state != null) {
            this.map.put(topicPartition, state);
        }
    }

    public void updateAndMoveToEnd(TopicPartition topicPartition, S state) {
        this.map.remove(topicPartition);
        this.map.put(topicPartition, state);
        this.updateSize();
    }

    public void update(TopicPartition topicPartition, S state) {
        this.map.put(topicPartition, state);
        this.updateSize();
    }

    public void remove(TopicPartition topicPartition) {
        this.map.remove(topicPartition);
        this.updateSize();
    }

    public Set<TopicPartition> partitionSet() {
        return this.partitionSetView;
    }

    public void clear() {
        this.map.clear();
        this.updateSize();
    }

    public boolean contains(TopicPartition topicPartition) {
        return this.map.containsKey(topicPartition);
    }

    public Stream<PartitionState<S>> stream() {
        return this.map.entrySet().stream().map(entry -> new PartitionState((TopicPartition)entry.getKey(), entry.getValue()));
    }

    public Map<TopicPartition, S> partitionStateMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public List<S> partitionStateValues() {
        return new ArrayList<S>(this.map.values());
    }

    public S stateValue(TopicPartition topicPartition) {
        return this.map.get(topicPartition);
    }

    public int size() {
        return this.size;
    }

    public void set(Map<TopicPartition, S> partitionToState) {
        this.map.clear();
        this.update(partitionToState);
        this.updateSize();
    }

    private void updateSize() {
        this.size = this.map.size();
    }

    private void update(Map<TopicPartition, S> partitionToState) {
        LinkedHashMap<String, List> topicToPartitions = new LinkedHashMap<String, List>();
        for (TopicPartition topicPartition : partitionToState.keySet()) {
            List partitions = topicToPartitions.computeIfAbsent(topicPartition.topic(), k -> new ArrayList());
            partitions.add(topicPartition);
        }
        for (Map.Entry entry : topicToPartitions.entrySet()) {
            for (TopicPartition tp : (List)entry.getValue()) {
                S state = partitionToState.get(tp);
                this.map.put(tp, state);
            }
        }
    }

    public static class PartitionState<S> {
        private final TopicPartition topicPartition;
        private final S value;

        public PartitionState(TopicPartition topicPartition, S state) {
            this.topicPartition = Objects.requireNonNull(topicPartition);
            this.value = Objects.requireNonNull(state);
        }

        public S value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionState that = (PartitionState)o;
            return this.topicPartition.equals(that.topicPartition) && this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.topicPartition.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public TopicPartition topicPartition() {
            return this.topicPartition;
        }

        public String toString() {
            return "PartitionState(" + this.topicPartition + "=" + this.value + ')';
        }
    }
}

