/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Optional;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;

public class BrokerAdditionDescription {
    private final int brokerId;
    private final Optional<BalancerOperationError> additionError;
    private final BalancerOperationStatus generalOperationStatus;
    private final PartitionReassignmentsStatus partitionReassignmentsStatus;
    private long createTimeMs;
    private long lastUpdateTimeMs;

    public BrokerAdditionDescription(int brokerId, BalancerOperationStatus balancerOperationGeneralStatus, PartitionReassignmentsStatus partitionReassignmentsStatus, Optional<BalancerOperationError> additionError, long createTimeMs, long lastUpdateTimestamp) {
        this.brokerId = brokerId;
        this.partitionReassignmentsStatus = partitionReassignmentsStatus;
        this.additionError = additionError;
        this.createTimeMs = createTimeMs;
        this.lastUpdateTimeMs = lastUpdateTimestamp;
        this.generalOperationStatus = balancerOperationGeneralStatus;
    }

    public BalancerOperationStatus generalOperationStatus() {
        return this.generalOperationStatus;
    }

    public PartitionReassignmentsStatus partitionReassignmentsStatus() {
        return this.partitionReassignmentsStatus;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long createTimeMs() {
        return this.createTimeMs;
    }

    public long lastUpdateTimeMs() {
        return this.lastUpdateTimeMs;
    }

    public Optional<BalancerOperationError> additionError() {
        return this.additionError;
    }

    public String toString() {
        return "BrokerAdditionDescription{brokerId=" + this.brokerId + ", partitionReassignmentsStatus=" + (Object)((Object)this.partitionReassignmentsStatus) + ", additionError=" + this.additionError + ", generalOperationStatus=" + (Object)((Object)this.generalOperationStatus) + ", createTime=" + ClientUtils.utcDateFor(this.createTimeMs) + ", lastUpdateTime=" + ClientUtils.utcDateFor(this.lastUpdateTimeMs) + '}';
    }
}

