/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterMirrorsRequest;
import org.apache.kafka.common.requests.ApiError;

public class AlterMirrorsResponse
extends AbstractResponse {
    private final AlterMirrorsResponseData data;

    public AlterMirrorsResponse(List<Result.OrError> results, int throttleTimeMs) {
        ArrayList<AlterMirrorsResponseData.OpData> opDatas = new ArrayList<AlterMirrorsResponseData.OpData>(results.size());
        for (Result.OrError result : results) {
            AlterMirrorsResponseData.OpData opData = new AlterMirrorsResponseData.OpData().setErrorCode(result.error().error().code()).setErrorMessage(result.error().message());
            if (result.result() instanceof StopTopicMirrorResult) {
                opData.setStopTopicMirror(Collections.singletonList(new AlterMirrorsResponseData.StopTopicMirrorData()));
            } else if (result.result() instanceof ClearTopicMirrorResult) {
                opData.setClearTopicMirror(Collections.singletonList(new AlterMirrorsResponseData.ClearTopicMirrorData()));
            } else if (result.result() != null) {
                throw new InvalidRequestException("Unexpected mirror control op type");
            }
            opDatas.add(opData);
        }
        this.data = new AlterMirrorsResponseData().setThrottleTimeMs(throttleTimeMs).setOps(opDatas);
    }

    public AlterMirrorsResponse(Collection<AlterMirrorsRequest.Op> ops, int throttleTimeMs, Throwable e) {
        short errorCode = Errors.forException(e).code();
        String errorMessage = e.getMessage();
        ArrayList<AlterMirrorsResponseData.OpData> opDatas = new ArrayList<AlterMirrorsResponseData.OpData>(ops.size());
        for (AlterMirrorsRequest.Op op : ops) {
            opDatas.add(new AlterMirrorsResponseData.OpData().setErrorCode(errorCode).setErrorMessage(errorMessage));
        }
        this.data = new AlterMirrorsResponseData().setThrottleTimeMs(throttleTimeMs).setOps(opDatas);
    }

    public AlterMirrorsResponse(Struct struct, short version) {
        this.data = new AlterMirrorsResponseData(struct, version);
    }

    public void complete(List<KafkaFutureImpl<Result>> result) {
        if (result.size() != this.data.ops().size()) {
            throw new IllegalArgumentException("Unexpected result size");
        }
        ListIterator<KafkaFutureImpl<Result>> iterator = result.listIterator();
        for (AlterMirrorsResponseData.OpData opData : this.data.ops()) {
            Result opResult;
            Errors error = Errors.forCode(opData.errorCode());
            KafkaFutureImpl<Result> future = iterator.next();
            if (error != Errors.NONE) {
                future.completeExceptionally(error.exception(opData.errorMessage()));
                continue;
            }
            if ((opData.stopTopicMirror() != null ? 1 : 0) + (opData.clearTopicMirror() != null ? 1 : 0) != 1) {
                throw new IllegalArgumentException("Unexpected request data");
            }
            if (opData.stopTopicMirror() != null) {
                if (opData.stopTopicMirror().size() != 1) {
                    throw new IllegalArgumentException("Unexpected result size");
                }
                opResult = new StopTopicMirrorResult();
            } else if (opData.clearTopicMirror() != null) {
                if (opData.clearTopicMirror().size() != 1) {
                    throw new IllegalArgumentException("Unexpected result size");
                }
                opResult = new ClearTopicMirrorResult();
            } else {
                throw new InvalidRequestException("Unexpected mirror control op type");
            }
            future.complete(opResult);
        }
    }

    public AlterMirrorsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        for (AlterMirrorsResponseData.OpData op : this.data.ops()) {
            Errors error = Errors.forCode(op.errorCode());
            counts.put(error, counts.getOrDefault((Object)error, 0) + 1);
        }
        return counts;
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public static class ClearTopicMirrorResult
    implements Result {
    }

    public static class StopTopicMirrorResult
    implements Result {
    }

    public static interface Result {

        public static class OrError {
            private Result result;
            private ApiError error;

            public OrError(Result result) {
                this.result = result;
                this.error = ApiError.NONE;
            }

            public OrError(ApiError error) {
                this.result = null;
                this.error = error;
            }

            public Result result() {
                return this.result;
            }

            public ApiError error() {
                return this.error;
            }
        }
    }
}

