/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.common.message.DescribeMirrorsRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeMirrorsResponse;

public class DescribeMirrorsRequest
extends AbstractRequest {
    private final DescribeMirrorsRequestData data;

    public DescribeMirrorsRequest(DescribeMirrorsRequestData data, short version) {
        super(ApiKeys.DESCRIBE_MIRRORS, version);
        this.data = data;
    }

    public DescribeMirrorsRequest(Struct struct, short version) {
        super(ApiKeys.DESCRIBE_MIRRORS, version);
        this.data = new DescribeMirrorsRequestData(struct, version);
    }

    public Collection<String> topics() {
        return this.data.topics();
    }

    public boolean includePartitions() {
        return this.data.includePartitions();
    }

    public int timeoutMs() {
        return this.data.timeoutMs();
    }

    public DescribeMirrorsRequestData data() {
        return this.data;
    }

    @Override
    public DescribeMirrorsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new DescribeMirrorsResponse(this.data.topics(), throttleTimeMs, e);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeMirrorsRequest> {
        private final DescribeMirrorsRequestData data;

        public Builder(Collection<String> topics, boolean includePartitions, int timeoutMs) {
            super(ApiKeys.DESCRIBE_MIRRORS);
            this.data = new DescribeMirrorsRequestData().setTopics(new ArrayList<String>(topics)).setIncludePartitions(includePartitions).setTimeoutMs(timeoutMs);
        }

        @Override
        public DescribeMirrorsRequest build(short version) {
            return new DescribeMirrorsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

