/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.ListMirrorsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class ListMirrorsResponse
extends AbstractResponse {
    private final ListMirrorsResponseData data;

    public ListMirrorsResponse(ListMirrorsResponseData data) {
        this.data = data;
    }

    public ListMirrorsResponse(Collection<String> topics, int throttleTimeMs) {
        this.data = new ListMirrorsResponseData().setThrottleTimeMs(throttleTimeMs).setTopics(new ArrayList<String>(topics));
    }

    public ListMirrorsResponse(int throttleTimeMs, Throwable e) {
        this.data = new ListMirrorsResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()).setErrorMessage(e.getMessage());
    }

    public ListMirrorsResponse(Struct struct, short version) {
        this.data = new ListMirrorsResponseData(struct, version);
    }

    public void complete(KafkaFutureImpl<Collection<String>> result) {
        Errors error = Errors.forCode(this.data.errorCode());
        if (error != Errors.NONE) {
            result.completeExceptionally(error.exception(this.data.errorMessage()));
            return;
        }
        result.complete(this.data.topics());
    }

    public ListMirrorsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }
}

