/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.ReplicaStatusResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.requests.AbstractResponse;

public class ReplicaStatusResponse
extends AbstractResponse {
    private final ReplicaStatusResponseData data;

    public ReplicaStatusResponse(ReplicaStatusResponseData data) {
        this.data = data;
    }

    public ReplicaStatusResponse(Struct struct, short version) {
        this.data = new ReplicaStatusResponseData(struct, version);
    }

    public ReplicaStatusResponseData data() {
        return this.data;
    }

    public static ReplicaStatusResponse parse(ByteBuffer buffer, short version) {
        return new ReplicaStatusResponse(ApiKeys.REPLICA_STATUS.responseSchema(version).read(buffer), version);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.incrementErrorCount(this.data.errorCode(), errorCounts);
        for (ReplicaStatusResponseData.ReplicaStatusTopicResponse topicResponse : this.data.topics()) {
            for (ReplicaStatusResponseData.ReplicaStatusPartitionResponse partitionResponse : topicResponse.partitions()) {
                this.incrementErrorCount(partitionResponse.errorCode(), errorCounts);
            }
        }
        return errorCounts;
    }

    private void incrementErrorCount(short errorCode, Map<Errors, Integer> errorCounts) {
        Errors error = Errors.forCode(errorCode);
        errorCounts.put(error, errorCounts.getOrDefault((Object)error, 0) + 1);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public void complete(Map<TopicPartition, KafkaFutureImpl<List<ReplicaStatus>>> result) {
        for (ReplicaStatusResponseData.ReplicaStatusTopicResponse topicResponse : this.data.topics()) {
            for (ReplicaStatusResponseData.ReplicaStatusPartitionResponse partitionResponse : topicResponse.partitions()) {
                TopicPartition topicPartition = new TopicPartition(topicResponse.name(), partitionResponse.partitionIndex());
                KafkaFutureImpl<List<ReplicaStatus>> future = result.get(topicPartition);
                Objects.requireNonNull(future, "Replica status future must not be null for " + topicPartition);
                Errors error = Errors.forCode(partitionResponse.errorCode());
                if (error != Errors.NONE) {
                    future.completeExceptionally(error.exception());
                    continue;
                }
                ArrayList<ReplicaStatus> replicas = new ArrayList<ReplicaStatus>(partitionResponse.replicas().size());
                for (ReplicaStatusResponseData.ReplicaStatusReplicaResponse replicaResponse : partitionResponse.replicas()) {
                    Optional<ReplicaStatus.MirrorInfo> mirrorInfo = Optional.empty();
                    if (replicaResponse.mirrorState() != null) {
                        mirrorInfo = Optional.of(new ReplicaStatus.MirrorInfo(replicaResponse.mirrorState(), replicaResponse.mirrorLastFetchTimeMs(), replicaResponse.mirrorLastFetchHighWatermark()));
                    }
                    replicas.add(new ReplicaStatus(replicaResponse.id(), replicaResponse.isLeader(), replicaResponse.isObserver(), replicaResponse.isIsrEligible(), replicaResponse.isInIsr(), replicaResponse.isCaughtUp(), replicaResponse.logStartOffset(), replicaResponse.logEndOffset(), replicaResponse.lastCaughtUpTimeMs(), replicaResponse.lastFetchTimeMs(), Optional.ofNullable(replicaResponse.linkName()), mirrorInfo));
                }
                future.complete(replicas);
            }
        }
    }
}

