/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.link;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.link.ClusterLinkMetrics;
import org.apache.kafka.server.metrics.ApiSensors;

public class ClusterLinkRequestContext
extends RequestContext {
    private final ClusterLinkMetrics linkMetrics;
    private final Time time;
    private final long startNanos;

    public ClusterLinkRequestContext(RequestHeader header, String connectionId, InetAddress clientAddress, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, Time time, ClusterLinkMetrics linkMetrics) {
        super(header, connectionId, clientAddress, principal, listenerName, securityProtocol, clientInformation);
        this.time = time;
        this.startNanos = time.nanoseconds();
        this.linkMetrics = linkMetrics;
    }

    @Override
    public RequestAndSize parseRequest(ByteBuffer buffer) {
        long totalSize = ApiSensors.calculateRequestSize(this.header, buffer);
        this.linkMetrics.recordRequest(this.header.apiKey(), totalSize, this.time.milliseconds());
        return super.parseRequest(buffer);
    }

    @Override
    public Send buildResponse(AbstractResponse body) {
        Send send = super.buildResponse(body);
        this.linkMetrics.recordResponse(this.header.apiKey(), send.size(), this.time.nanoseconds() - this.startNanos, body.errorCounts(), this.time.milliseconds());
        return send;
    }
}

