/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MetadataCache;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.test.MockClusterResourceListener;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MetadataTest {
    private long refreshBackoffMs = 100L;
    private long metadataExpireMs = 1000L;
    private Metadata metadata = new Metadata(this.refreshBackoffMs, this.metadataExpireMs, new LogContext(), new ClusterResourceListeners());

    private static MetadataResponse emptyMetadataResponse() {
        return MetadataResponse.prepareResponse(Collections.emptyList(), null, (int)-1, Collections.emptyList());
    }

    @Test(expected=IllegalStateException.class)
    public void testMetadataUpdateAfterClose() {
        this.metadata.close();
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, 1000L);
    }

    private static void checkTimeToNextUpdate(long refreshBackoffMs, long metadataExpireMs) {
        long now = 10000L;
        if (metadataExpireMs > now || refreshBackoffMs > now) {
            throw new IllegalArgumentException("metadataExpireMs and refreshBackoffMs must be smaller than 'now'");
        }
        long largerOfBackoffAndExpire = Math.max(refreshBackoffMs, metadataExpireMs);
        Metadata metadata = new Metadata(refreshBackoffMs, metadataExpireMs, new LogContext(), new ClusterResourceListeners());
        Assert.assertEquals((long)0L, (long)metadata.timeToNextUpdate(now));
        metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, now);
        Assert.assertEquals((long)largerOfBackoffAndExpire, (long)metadata.timeToNextUpdate(now));
        metadata.requestUpdate();
        Assert.assertEquals((long)refreshBackoffMs, (long)metadata.timeToNextUpdate(now));
        metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, now);
        Assert.assertEquals((long)largerOfBackoffAndExpire, (long)metadata.timeToNextUpdate(now));
        Assert.assertEquals((long)0L, (long)metadata.timeToNextUpdate(now += largerOfBackoffAndExpire));
        Assert.assertEquals((long)0L, (long)metadata.timeToNextUpdate(now + 1L));
    }

    @Test
    public void testUpdateMetadataAllowedImmediatelyAfterBootstrap() {
        MockTime time = new MockTime();
        Metadata metadata = new Metadata(this.refreshBackoffMs, this.metadataExpireMs, new LogContext(), new ClusterResourceListeners());
        metadata.bootstrap(Collections.singletonList(new InetSocketAddress("localhost", 9002)));
        Assert.assertEquals((long)0L, (long)metadata.timeToAllowUpdate(time.milliseconds()));
        Assert.assertEquals((long)0L, (long)metadata.timeToNextUpdate(time.milliseconds()));
    }

    @Test
    public void testTimeToNextUpdate() {
        MetadataTest.checkTimeToNextUpdate(100L, 1000L);
        MetadataTest.checkTimeToNextUpdate(1000L, 100L);
        MetadataTest.checkTimeToNextUpdate(0L, 0L);
        MetadataTest.checkTimeToNextUpdate(0L, 100L);
        MetadataTest.checkTimeToNextUpdate(100L, 0L);
    }

    @Test
    public void testTimeToNextUpdateRetryBackoff() {
        long now = 10000L;
        this.metadata.failedUpdate(now);
        Assert.assertEquals((long)this.refreshBackoffMs, (long)this.metadata.timeToNextUpdate(now));
        this.metadata.requestUpdate();
        Assert.assertEquals((long)this.refreshBackoffMs, (long)this.metadata.timeToNextUpdate(now));
        Assert.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(now += this.refreshBackoffMs));
        Assert.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(now + 1L));
    }

    @Test
    public void testIgnoreLeaderEpochInOlderMetadataResponse() {
        MetadataResponse.PartitionMetadata responseMetadata;
        MetadataResponse response;
        Struct struct;
        short version;
        TopicPartition tp = new TopicPartition("topic", 0);
        MetadataResponseData.MetadataResponsePartition partitionMetadata = new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(tp.partition()).setLeaderId(5).setLeaderEpoch(10).setReplicaNodes(Arrays.asList(1, 2, 3)).setIsrNodes(Arrays.asList(1, 2, 3)).setOfflineReplicas(Collections.emptyList()).setErrorCode(Errors.NONE.code());
        MetadataResponseData.MetadataResponseTopic topicMetadata = new MetadataResponseData.MetadataResponseTopic().setName(tp.topic()).setErrorCode(Errors.NONE.code()).setPartitions(Collections.singletonList(partitionMetadata)).setIsInternal(false);
        MetadataResponseData.MetadataResponseTopicCollection topics = new MetadataResponseData.MetadataResponseTopicCollection();
        topics.add(topicMetadata);
        MetadataResponseData data = new MetadataResponseData().setClusterId("clusterId").setControllerId(0).setTopics(topics).setBrokers(new MetadataResponseData.MetadataResponseBrokerCollection());
        for (version = ApiKeys.METADATA.oldestVersion(); version < 9; version = (short)(version + 1)) {
            struct = data.toStruct(version);
            response = new MetadataResponse(struct, version);
            Assert.assertFalse((boolean)response.hasReliableLeaderEpochs());
            this.metadata.updateWithCurrentRequestVersion(response, false, 100L);
            Assert.assertTrue((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
            responseMetadata = (MetadataResponse.PartitionMetadata)this.metadata.partitionMetadataIfCurrent(tp).get();
            Assert.assertEquals(Optional.empty(), (Object)responseMetadata.leaderEpoch);
        }
        for (version = 9; version <= ApiKeys.METADATA.latestVersion(); version = (short)(version + 1)) {
            struct = data.toStruct(version);
            response = new MetadataResponse(struct, version);
            Assert.assertTrue((boolean)response.hasReliableLeaderEpochs());
            this.metadata.updateWithCurrentRequestVersion(response, false, 100L);
            Assert.assertTrue((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
            responseMetadata = (MetadataResponse.PartitionMetadata)this.metadata.partitionMetadataIfCurrent(tp).get();
            Assert.assertEquals(Optional.of(10), (Object)responseMetadata.leaderEpoch);
        }
    }

    @Test
    public void testStaleMetadata() {
        TopicPartition tp = new TopicPartition("topic", 0);
        MetadataResponseData.MetadataResponsePartition partitionMetadata = new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(tp.partition()).setLeaderId(1).setLeaderEpoch(10).setReplicaNodes(Arrays.asList(1, 2, 3)).setIsrNodes(Arrays.asList(1, 2, 3)).setOfflineReplicas(Collections.emptyList()).setErrorCode(Errors.NONE.code());
        MetadataResponseData.MetadataResponseTopic topicMetadata = new MetadataResponseData.MetadataResponseTopic().setName(tp.topic()).setErrorCode(Errors.NONE.code()).setPartitions(Collections.singletonList(partitionMetadata)).setIsInternal(false);
        MetadataResponseData.MetadataResponseTopicCollection topics = new MetadataResponseData.MetadataResponseTopicCollection();
        topics.add(topicMetadata);
        MetadataResponseData data = new MetadataResponseData().setClusterId("clusterId").setControllerId(0).setTopics(topics).setBrokers(new MetadataResponseData.MetadataResponseBrokerCollection());
        this.metadata.updateWithCurrentRequestVersion(new MetadataResponse(data), false, 100L);
        partitionMetadata.setPartitionIndex(tp.partition()).setLeaderId(1).setLeaderEpoch(9).setReplicaNodes(Arrays.asList(1, 2, 3)).setIsrNodes(Arrays.asList(1, 2)).setOfflineReplicas(Collections.emptyList()).setErrorCode(Errors.NONE.code());
        this.metadata.updateWithCurrentRequestVersion(new MetadataResponse(data), false, 101L);
        Assert.assertEquals(Optional.of(10), (Object)this.metadata.lastSeenLeaderEpoch(tp));
        Assert.assertTrue((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
        MetadataResponse.PartitionMetadata responseMetadata = (MetadataResponse.PartitionMetadata)this.metadata.partitionMetadataIfCurrent(tp).get();
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)responseMetadata.inSyncReplicaIds);
        Assert.assertEquals(Optional.of(10), (Object)responseMetadata.leaderEpoch);
    }

    @Test
    public void testFailedUpdate() {
        long time = 100L;
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, time);
        Assert.assertEquals((long)100L, (long)this.metadata.timeToNextUpdate(1000L));
        this.metadata.failedUpdate(1100L);
        Assert.assertEquals((long)100L, (long)this.metadata.timeToNextUpdate(1100L));
        Assert.assertEquals((long)100L, (long)this.metadata.lastSuccessfulUpdate());
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, time);
        Assert.assertEquals((long)100L, (long)this.metadata.timeToNextUpdate(1000L));
    }

    @Test
    public void testClusterListenerGetsNotifiedOfUpdate() {
        MockClusterResourceListener mockClusterListener = new MockClusterResourceListener();
        ClusterResourceListeners listeners = new ClusterResourceListeners();
        listeners.maybeAdd((Object)mockClusterListener);
        this.metadata = new Metadata(this.refreshBackoffMs, this.metadataExpireMs, new LogContext(), listeners);
        String hostName = "www.example.com";
        this.metadata.bootstrap(Collections.singletonList(new InetSocketAddress(hostName, 9002)));
        Assert.assertFalse((String)"ClusterResourceListener should not called when metadata is updated with bootstrap Cluster", (boolean)MockClusterResourceListener.IS_ON_UPDATE_CALLED.get());
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("topic", 1);
        partitionCounts.put("topic1", 1);
        MetadataResponse metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, partitionCounts);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 100L);
        Assert.assertEquals((String)"MockClusterResourceListener did not get cluster metadata correctly", (Object)"dummy", (Object)mockClusterListener.clusterResource().clusterId());
        Assert.assertTrue((String)"MockClusterResourceListener should be called when metadata is updated with non-bootstrap Cluster", (boolean)MockClusterResourceListener.IS_ON_UPDATE_CALLED.get());
    }

    @Test
    public void testRequestUpdate() {
        Assert.assertFalse((boolean)this.metadata.updateRequested());
        int[] epochs = new int[]{42, 42, 41, 41, 42, 43, 43, 42, 41, 44};
        boolean[] updateResult = new boolean[]{true, false, false, false, false, true, false, false, false, true};
        TopicPartition tp = new TopicPartition("topic", 0);
        MetadataResponse metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic", 1), _tp -> 0);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 10L);
        for (int i = 0; i < epochs.length; ++i) {
            this.metadata.updateLastSeenEpochIfNewer(tp, epochs[i]);
            if (updateResult[i]) {
                Assert.assertTrue((String)("Expected metadata update to be requested [" + i + "]"), (boolean)this.metadata.updateRequested());
            } else {
                Assert.assertFalse((String)("Did not expect metadata update to be requested [" + i + "]"), (boolean)this.metadata.updateRequested());
            }
            this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, 0L);
            Assert.assertFalse((boolean)this.metadata.updateRequested());
        }
    }

    @Test
    public void testUpdateLastEpoch() {
        TopicPartition tp = new TopicPartition("topic-1", 0);
        MetadataResponse metadataResponse = MetadataTest.emptyMetadataResponse();
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 0L);
        Assert.assertFalse((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 0));
        Assert.assertFalse((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 1));
        Assert.assertFalse((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 2));
        Assert.assertFalse((boolean)this.metadata.lastSeenLeaderEpoch(tp).isPresent());
        metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1), _tp -> 10);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 1L);
        TestUtils.assertOptional(this.metadata.lastSeenLeaderEpoch(tp), leaderAndEpoch -> Assert.assertEquals((long)leaderAndEpoch.intValue(), (long)10L));
        Assert.assertFalse((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 1));
        TestUtils.assertOptional(this.metadata.lastSeenLeaderEpoch(tp), leaderAndEpoch -> Assert.assertEquals((long)leaderAndEpoch.intValue(), (long)10L));
        Assert.assertFalse((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 10));
        TestUtils.assertOptional(this.metadata.lastSeenLeaderEpoch(tp), leaderAndEpoch -> Assert.assertEquals((long)leaderAndEpoch.intValue(), (long)10L));
        Assert.assertTrue((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 12));
        TestUtils.assertOptional(this.metadata.lastSeenLeaderEpoch(tp), leaderAndEpoch -> Assert.assertEquals((long)leaderAndEpoch.intValue(), (long)12L));
        metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1), _tp -> 12);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 2L);
        TestUtils.assertOptional(this.metadata.lastSeenLeaderEpoch(tp), leaderAndEpoch -> Assert.assertEquals((long)leaderAndEpoch.intValue(), (long)12L));
        metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1), _tp -> 11);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 3L);
        TestUtils.assertOptional(this.metadata.lastSeenLeaderEpoch(tp), leaderAndEpoch -> Assert.assertEquals((long)leaderAndEpoch.intValue(), (long)12L));
    }

    @Test
    public void testRejectOldMetadata() {
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("topic-1", 1);
        TopicPartition tp = new TopicPartition("topic-1", 0);
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, 0L);
        MetadataResponse metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 100);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 10L);
        Assert.assertNotNull((Object)this.metadata.fetch().partition(tp));
        Assert.assertTrue((boolean)this.metadata.lastSeenLeaderEpoch(tp).isPresent());
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
        metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 99, (error, partition, leader, leaderEpoch, replicas, isr, offlineReplicas) -> new MetadataResponse.PartitionMetadata(error, partition, leader, leaderEpoch, replicas, Collections.emptyList(), offlineReplicas), ApiKeys.METADATA.latestVersion());
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 20L);
        Assert.assertEquals((long)this.metadata.fetch().partition(tp).inSyncReplicas().length, (long)1L);
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
        metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 100, (error, partition, leader, leaderEpoch, replicas, isr, offlineReplicas) -> new MetadataResponse.PartitionMetadata(error, partition, leader, leaderEpoch, replicas, Collections.emptyList(), offlineReplicas), ApiKeys.METADATA.latestVersion());
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 20L);
        Assert.assertEquals((long)this.metadata.fetch().partition(tp).inSyncReplicas().length, (long)0L);
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
        metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), Collections.emptyMap());
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 20L);
        Assert.assertNull((Object)this.metadata.fetch().partition(tp));
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
        metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 99);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 10L);
        Assert.assertNull((Object)this.metadata.fetch().partition(tp));
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
    }

    @Test
    public void testOutOfBandEpochUpdate() {
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("topic-1", 5);
        TopicPartition tp = new TopicPartition("topic-1", 0);
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, 0L);
        Assert.assertFalse((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 99));
        MetadataResponse metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 100);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 10L);
        Assert.assertNotNull((Object)this.metadata.fetch().partition(tp));
        Assert.assertTrue((boolean)this.metadata.lastSeenLeaderEpoch(tp).isPresent());
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
        Assert.assertTrue((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 101));
        Assert.assertNotNull((Object)this.metadata.fetch().partition(tp));
        Assert.assertEquals((long)Objects.requireNonNull(this.metadata.fetch().partitionCountForTopic("topic-1")).longValue(), (long)5L);
        Assert.assertFalse((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)101L);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 20L);
        Assert.assertNotNull((Object)this.metadata.fetch().partition(tp));
        Assert.assertEquals((long)Objects.requireNonNull(this.metadata.fetch().partitionCountForTopic("topic-1")).longValue(), (long)5L);
        Assert.assertFalse((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)101L);
        metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 101);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 30L);
        Assert.assertNotNull((Object)this.metadata.fetch().partition(tp));
        Assert.assertEquals((long)Objects.requireNonNull(this.metadata.fetch().partitionCountForTopic("topic-1")).longValue(), (long)5L);
        Assert.assertTrue((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)101L);
    }

    @Test
    public void testNoEpoch() {
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, 0L);
        MetadataResponse metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1));
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 10L);
        TopicPartition tp = new TopicPartition("topic-1", 0);
        Assert.assertFalse((boolean)this.metadata.lastSeenLeaderEpoch(tp).isPresent());
        Assert.assertTrue((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
        Assert.assertEquals((long)0L, (long)((MetadataResponse.PartitionMetadata)this.metadata.partitionMetadataIfCurrent(tp).get()).partition());
        Assert.assertEquals(Optional.of(0), (Object)((MetadataResponse.PartitionMetadata)this.metadata.partitionMetadataIfCurrent((TopicPartition)tp).get()).leaderId);
        this.metadata.updateLastSeenEpochIfNewer(tp, 10);
        Assert.assertTrue((boolean)this.metadata.partitionMetadataIfCurrent(tp).isPresent());
        Assert.assertFalse((boolean)((MetadataResponse.PartitionMetadata)this.metadata.partitionMetadataIfCurrent((TopicPartition)tp).get()).leaderEpoch.isPresent());
    }

    @Test
    public void testClusterCopy() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        counts.put("topic1", 2);
        counts.put("topic2", 3);
        counts.put("__consumer_offsets", 3);
        errors.put("topic3", Errors.INVALID_TOPIC_EXCEPTION);
        errors.put("topic4", Errors.TOPIC_AUTHORIZATION_FAILED);
        MetadataResponse metadataResponse = TestUtils.metadataUpdateWith("dummy", 4, errors, counts);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 0L);
        Cluster cluster = this.metadata.fetch();
        Assert.assertEquals((Object)cluster.clusterResource().clusterId(), (Object)"dummy");
        Assert.assertEquals((long)cluster.nodes().size(), (long)4L);
        Assert.assertEquals((Object)cluster.invalidTopics(), Collections.singleton("topic3"));
        Assert.assertEquals((Object)cluster.unauthorizedTopics(), Collections.singleton("topic4"));
        Assert.assertEquals((long)cluster.topics().size(), (long)3L);
        Assert.assertEquals((Object)cluster.internalTopics(), Collections.singleton("__consumer_offsets"));
        Assert.assertEquals((long)cluster.partitionsForTopic("topic1").size(), (long)2L);
        Assert.assertEquals((long)cluster.partitionsForTopic("topic2").size(), (long)3L);
        InetSocketAddress address = InetSocketAddress.createUnresolved("localhost", 0);
        Cluster fromMetadata = MetadataCache.bootstrap(Collections.singletonList(address)).cluster();
        Cluster fromCluster = Cluster.bootstrap(Collections.singletonList(address));
        Assert.assertEquals((Object)fromMetadata, (Object)fromCluster);
        Cluster fromMetadataEmpty = MetadataCache.empty().cluster();
        Cluster fromClusterEmpty = Cluster.empty();
        Assert.assertEquals((Object)fromMetadataEmpty, (Object)fromClusterEmpty);
    }

    @Test
    public void testRequestVersion() {
        MockTime time = new MockTime();
        this.metadata.requestUpdate();
        Metadata.MetadataRequestAndVersion versionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        this.metadata.update(versionAndBuilder.requestVersion, TestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), false, time.milliseconds());
        Assert.assertFalse((boolean)this.metadata.updateRequested());
        this.metadata.requestUpdateForNewTopics();
        versionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        this.metadata.requestUpdateForNewTopics();
        this.metadata.update(versionAndBuilder.requestVersion, TestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), true, time.milliseconds());
        Assert.assertTrue((boolean)this.metadata.updateRequested());
        versionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        this.metadata.update(versionAndBuilder.requestVersion, TestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), true, time.milliseconds());
        Assert.assertFalse((boolean)this.metadata.updateRequested());
    }

    @Test
    public void testPartialMetadataUpdate() {
        MockTime time = new MockTime();
        this.metadata = new Metadata(this.refreshBackoffMs, this.metadataExpireMs, new LogContext(), new ClusterResourceListeners()){

            protected MetadataRequest.Builder newMetadataRequestBuilderForNewTopics() {
                return this.newMetadataRequestBuilder();
            }
        };
        Assert.assertFalse((boolean)this.metadata.updateRequested());
        this.metadata.requestUpdate();
        Metadata.MetadataRequestAndVersion versionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        Assert.assertFalse((boolean)versionAndBuilder.isPartialUpdate);
        this.metadata.update(versionAndBuilder.requestVersion, TestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), false, time.milliseconds());
        Assert.assertFalse((boolean)this.metadata.updateRequested());
        this.metadata.requestUpdateForNewTopics();
        versionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        Assert.assertTrue((boolean)versionAndBuilder.isPartialUpdate);
        this.metadata.update(versionAndBuilder.requestVersion, TestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), true, time.milliseconds());
        Assert.assertFalse((boolean)this.metadata.updateRequested());
        this.metadata.requestUpdate();
        this.metadata.requestUpdateForNewTopics();
        versionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        Assert.assertFalse((boolean)versionAndBuilder.isPartialUpdate);
        this.metadata.update(versionAndBuilder.requestVersion, TestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), false, time.milliseconds());
        Assert.assertFalse((boolean)this.metadata.updateRequested());
        this.metadata.requestUpdateForNewTopics();
        long refreshTimeMs = time.milliseconds() + this.metadata.metadataExpireMs();
        versionAndBuilder = this.metadata.newMetadataRequestAndVersion(refreshTimeMs);
        Assert.assertFalse((boolean)versionAndBuilder.isPartialUpdate);
        this.metadata.update(versionAndBuilder.requestVersion, TestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), true, refreshTimeMs);
        Assert.assertFalse((boolean)this.metadata.updateRequested());
        this.metadata.requestUpdateForNewTopics();
        versionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        Assert.assertTrue((boolean)versionAndBuilder.isPartialUpdate);
        this.metadata.requestUpdateForNewTopics();
        Metadata.MetadataRequestAndVersion overlappingVersionAndBuilder = this.metadata.newMetadataRequestAndVersion(time.milliseconds());
        Assert.assertTrue((boolean)overlappingVersionAndBuilder.isPartialUpdate);
        Assert.assertTrue((boolean)this.metadata.updateRequested());
        this.metadata.update(versionAndBuilder.requestVersion, TestUtils.metadataUpdateWith(1, Collections.singletonMap("topic-1", 1)), true, time.milliseconds());
        Assert.assertTrue((boolean)this.metadata.updateRequested());
        this.metadata.update(overlappingVersionAndBuilder.requestVersion, TestUtils.metadataUpdateWith(1, Collections.singletonMap("topic-2", 1)), true, time.milliseconds());
        Assert.assertFalse((boolean)this.metadata.updateRequested());
    }

    @Test
    public void testInvalidTopicError() {
        MockTime time = new MockTime();
        String invalidTopic = "topic dfsa";
        MetadataResponse invalidTopicResponse = TestUtils.metadataUpdateWith("clusterId", 1, Collections.singletonMap(invalidTopic, Errors.INVALID_TOPIC_EXCEPTION), Collections.emptyMap());
        this.metadata.updateWithCurrentRequestVersion(invalidTopicResponse, false, time.milliseconds());
        InvalidTopicException e = (InvalidTopicException)Assert.assertThrows(InvalidTopicException.class, () -> this.metadata.maybeThrowAnyException());
        Assert.assertEquals(Collections.singleton(invalidTopic), (Object)e.invalidTopics());
        this.metadata.maybeThrowAnyException();
        this.metadata.updateWithCurrentRequestVersion(invalidTopicResponse, false, time.milliseconds());
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, time.milliseconds());
        this.metadata.maybeThrowAnyException();
    }

    @Test
    public void testTopicAuthorizationError() {
        MockTime time = new MockTime();
        String invalidTopic = "foo";
        MetadataResponse unauthorizedTopicResponse = TestUtils.metadataUpdateWith("clusterId", 1, Collections.singletonMap(invalidTopic, Errors.TOPIC_AUTHORIZATION_FAILED), Collections.emptyMap());
        this.metadata.updateWithCurrentRequestVersion(unauthorizedTopicResponse, false, time.milliseconds());
        TopicAuthorizationException e = (TopicAuthorizationException)Assert.assertThrows(TopicAuthorizationException.class, () -> this.metadata.maybeThrowAnyException());
        Assert.assertEquals(Collections.singleton(invalidTopic), (Object)e.unauthorizedTopics());
        this.metadata.maybeThrowAnyException();
        this.metadata.updateWithCurrentRequestVersion(unauthorizedTopicResponse, false, time.milliseconds());
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, time.milliseconds());
        this.metadata.maybeThrowAnyException();
    }

    @Test
    public void testMetadataTopicErrors() {
        MockTime time = new MockTime();
        HashMap<String, Errors> topicErrors = new HashMap<String, Errors>(3);
        topicErrors.put("invalidTopic", Errors.INVALID_TOPIC_EXCEPTION);
        topicErrors.put("sensitiveTopic1", Errors.TOPIC_AUTHORIZATION_FAILED);
        topicErrors.put("sensitiveTopic2", Errors.TOPIC_AUTHORIZATION_FAILED);
        MetadataResponse metadataResponse = TestUtils.metadataUpdateWith("clusterId", 1, topicErrors, Collections.emptyMap());
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, time.milliseconds());
        TopicAuthorizationException e1 = (TopicAuthorizationException)Assert.assertThrows(TopicAuthorizationException.class, () -> this.metadata.maybeThrowExceptionForTopic("sensitiveTopic1"));
        Assert.assertEquals(Collections.singleton("sensitiveTopic1"), (Object)e1.unauthorizedTopics());
        this.metadata.maybeThrowAnyException();
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, time.milliseconds());
        TopicAuthorizationException e2 = (TopicAuthorizationException)Assert.assertThrows(TopicAuthorizationException.class, () -> this.metadata.maybeThrowExceptionForTopic("sensitiveTopic2"));
        Assert.assertEquals(Collections.singleton("sensitiveTopic2"), (Object)e2.unauthorizedTopics());
        this.metadata.maybeThrowAnyException();
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, time.milliseconds());
        InvalidTopicException e3 = (InvalidTopicException)Assert.assertThrows(InvalidTopicException.class, () -> this.metadata.maybeThrowExceptionForTopic("invalidTopic"));
        Assert.assertEquals(Collections.singleton("invalidTopic"), (Object)e3.invalidTopics());
        this.metadata.maybeThrowAnyException();
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, time.milliseconds());
        this.metadata.maybeThrowExceptionForTopic("anotherTopic");
        this.metadata.maybeThrowAnyException();
    }

    @Test
    public void testNodeIfOffline() {
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("topic-1", 1);
        Node node0 = new Node(0, "localhost", 9092);
        Node node1 = new Node(1, "localhost", 9093);
        MetadataResponse metadataResponse = TestUtils.metadataUpdateWith("dummy", 2, Collections.emptyMap(), partitionCounts, _tp -> 99, (error, partition, leader, leaderEpoch, replicas, isr, offlineReplicas) -> new MetadataResponse.PartitionMetadata(error, partition, Optional.of(node0.id()), leaderEpoch, Collections.singletonList(node0.id()), Collections.emptyList(), Collections.singletonList(node1.id())), ApiKeys.METADATA.latestVersion());
        this.metadata.updateWithCurrentRequestVersion(MetadataTest.emptyMetadataResponse(), false, 0L);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, false, 10L);
        TopicPartition tp = new TopicPartition("topic-1", 0);
        TestUtils.assertOptional(this.metadata.fetch().nodeIfOnline(tp, 0), node -> Assert.assertEquals((long)node.id(), (long)0L));
        Assert.assertFalse((boolean)this.metadata.fetch().nodeIfOnline(tp, 1).isPresent());
        Assert.assertEquals((long)this.metadata.fetch().nodeById(0).id(), (long)0L);
        Assert.assertEquals((long)this.metadata.fetch().nodeById(1).id(), (long)1L);
    }

    @Test
    public void testLeaderMetadataInconsistentWithBrokerMetadata() {
        TopicPartition tp = new TopicPartition("topic", 0);
        Node node0 = new Node(0, "localhost", 9092);
        Node node1 = new Node(1, "localhost", 9093);
        Node node2 = new Node(2, "localhost", 9094);
        MetadataResponseData.MetadataResponsePartition firstPartitionMetadata = new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(10).setLeaderId(0).setReplicaNodes(Arrays.asList(0, 1, 2)).setIsrNodes(Arrays.asList(0, 1, 2)).setOfflineReplicas(Collections.emptyList());
        MetadataResponseData.MetadataResponsePartition secondPartitionMetadata = new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(8).setLeaderId(1).setReplicaNodes(Arrays.asList(0, 1, 2)).setIsrNodes(Arrays.asList(1, 2)).setOfflineReplicas(Collections.singletonList(0));
        this.metadata.updateWithCurrentRequestVersion(new MetadataResponse(new MetadataResponseData().setTopics(this.buildTopicCollection(tp.topic(), firstPartitionMetadata)).setBrokers(this.buildBrokerCollection(Arrays.asList(node0, node1, node2)))), false, 10L);
        this.metadata.updateWithCurrentRequestVersion(new MetadataResponse(new MetadataResponseData().setTopics(this.buildTopicCollection(tp.topic(), secondPartitionMetadata)).setBrokers(this.buildBrokerCollection(Arrays.asList(node1, node2)))), false, 20L);
        Assert.assertNull((Object)this.metadata.fetch().leaderFor(tp));
        Assert.assertEquals(Optional.of(10), (Object)this.metadata.lastSeenLeaderEpoch(tp));
        Assert.assertFalse((boolean)this.metadata.currentLeader((TopicPartition)tp).leader.isPresent());
    }

    private MetadataResponseData.MetadataResponseTopicCollection buildTopicCollection(String topic, MetadataResponseData.MetadataResponsePartition partitionMetadata) {
        MetadataResponseData.MetadataResponseTopic topicMetadata = new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setIsInternal(false);
        topicMetadata.setPartitions(Collections.singletonList(partitionMetadata));
        MetadataResponseData.MetadataResponseTopicCollection topics = new MetadataResponseData.MetadataResponseTopicCollection();
        topics.add(topicMetadata);
        return topics;
    }

    private MetadataResponseData.MetadataResponseBrokerCollection buildBrokerCollection(List<Node> nodes) {
        MetadataResponseData.MetadataResponseBrokerCollection brokers = new MetadataResponseData.MetadataResponseBrokerCollection();
        for (Node node : nodes) {
            MetadataResponseData.MetadataResponseBroker broker = new MetadataResponseData.MetadataResponseBroker().setNodeId(node.id()).setHost(node.host()).setPort(node.port()).setRack(node.rack());
            brokers.add(broker);
        }
        return brokers;
    }

    @Test
    public void testMetadataMerge() {
        MockTime time = new MockTime();
        final AtomicReference retainTopics = new AtomicReference(new HashSet());
        this.metadata = new Metadata(this.refreshBackoffMs, this.metadataExpireMs, new LogContext(), new ClusterResourceListeners()){

            protected boolean retainTopic(String topic, boolean isInternal, long nowMs) {
                return ((Set)retainTopics.get()).contains(topic);
            }
        };
        String oldClusterId = "oldClusterId";
        int oldNodes = 2;
        HashMap<String, Errors> oldTopicErrors = new HashMap<String, Errors>();
        oldTopicErrors.put("oldInvalidTopic", Errors.INVALID_TOPIC_EXCEPTION);
        oldTopicErrors.put("keepInvalidTopic", Errors.INVALID_TOPIC_EXCEPTION);
        oldTopicErrors.put("oldUnauthorizedTopic", Errors.TOPIC_AUTHORIZATION_FAILED);
        oldTopicErrors.put("keepUnauthorizedTopic", Errors.TOPIC_AUTHORIZATION_FAILED);
        HashMap<String, Integer> oldTopicPartitionCounts = new HashMap<String, Integer>();
        oldTopicPartitionCounts.put("oldValidTopic", 2);
        oldTopicPartitionCounts.put("keepValidTopic", 3);
        retainTopics.set(new HashSet<String>(Arrays.asList("oldInvalidTopic", "keepInvalidTopic", "oldUnauthorizedTopic", "keepUnauthorizedTopic", "oldValidTopic", "keepValidTopic")));
        MetadataResponse metadataResponse = TestUtils.metadataUpdateWith(oldClusterId, oldNodes, oldTopicErrors, oldTopicPartitionCounts, _tp -> 100);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, true, time.milliseconds());
        Cluster cluster = this.metadata.fetch();
        Assert.assertEquals((Object)cluster.clusterResource().clusterId(), (Object)oldClusterId);
        Assert.assertEquals((long)cluster.nodes().size(), (long)oldNodes);
        Assert.assertEquals((Object)cluster.invalidTopics(), new HashSet<String>(Arrays.asList("oldInvalidTopic", "keepInvalidTopic")));
        Assert.assertEquals((Object)cluster.unauthorizedTopics(), new HashSet<String>(Arrays.asList("oldUnauthorizedTopic", "keepUnauthorizedTopic")));
        Assert.assertEquals((Object)cluster.topics(), new HashSet<String>(Arrays.asList("oldValidTopic", "keepValidTopic")));
        Assert.assertEquals((long)cluster.partitionsForTopic("oldValidTopic").size(), (long)2L);
        Assert.assertEquals((long)cluster.partitionsForTopic("keepValidTopic").size(), (long)3L);
        String newClusterId = "newClusterId";
        int newNodes = oldNodes + 1;
        HashMap<String, Errors> newTopicErrors = new HashMap<String, Errors>();
        newTopicErrors.put("newInvalidTopic", Errors.INVALID_TOPIC_EXCEPTION);
        newTopicErrors.put("newUnauthorizedTopic", Errors.TOPIC_AUTHORIZATION_FAILED);
        HashMap<String, Integer> newTopicPartitionCounts = new HashMap<String, Integer>();
        newTopicPartitionCounts.put("keepValidTopic", 2);
        newTopicPartitionCounts.put("newValidTopic", 4);
        retainTopics.set(new HashSet<String>(Arrays.asList("keepInvalidTopic", "newInvalidTopic", "keepUnauthorizedTopic", "newUnauthorizedTopic", "keepValidTopic", "newValidTopic")));
        metadataResponse = TestUtils.metadataUpdateWith(newClusterId, newNodes, newTopicErrors, newTopicPartitionCounts, _tp -> 200);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, true, time.milliseconds());
        cluster = this.metadata.fetch();
        Assert.assertEquals((Object)cluster.clusterResource().clusterId(), (Object)newClusterId);
        Assert.assertEquals((long)cluster.nodes().size(), (long)newNodes);
        Assert.assertEquals((Object)cluster.invalidTopics(), new HashSet<String>(Arrays.asList("keepInvalidTopic", "newInvalidTopic")));
        Assert.assertEquals((Object)cluster.unauthorizedTopics(), new HashSet<String>(Arrays.asList("keepUnauthorizedTopic", "newUnauthorizedTopic")));
        Assert.assertEquals((Object)cluster.topics(), new HashSet<String>(Arrays.asList("keepValidTopic", "newValidTopic")));
        Assert.assertEquals((long)cluster.partitionsForTopic("keepValidTopic").size(), (long)2L);
        Assert.assertEquals((long)cluster.partitionsForTopic("newValidTopic").size(), (long)4L);
        retainTopics.set(Collections.emptySet());
        metadataResponse = TestUtils.metadataUpdateWith(newClusterId, newNodes, newTopicErrors, newTopicPartitionCounts, _tp -> 300);
        this.metadata.updateWithCurrentRequestVersion(metadataResponse, true, time.milliseconds());
        cluster = this.metadata.fetch();
        Assert.assertEquals((Object)cluster.clusterResource().clusterId(), (Object)newClusterId);
        Assert.assertEquals((long)cluster.nodes().size(), (long)newNodes);
        Assert.assertEquals((Object)cluster.invalidTopics(), Collections.emptySet());
        Assert.assertEquals((Object)cluster.unauthorizedTopics(), Collections.emptySet());
        Assert.assertEquals((Object)cluster.topics(), Collections.emptySet());
    }
}

