/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.junit.Assert;
import org.junit.Test;

public class ConsumerConfigTest {
    private final Deserializer<byte[]> keyDeserializer = new ByteArrayDeserializer();
    private final Deserializer<String> valueDeserializer = new StringDeserializer();
    private final String keyDeserializerClassName = this.keyDeserializer.getClass().getName();
    private final String valueDeserializerClassName = this.valueDeserializer.getClass().getName();
    private final Object keyDeserializerClass = this.keyDeserializer.getClass();
    private final Object valueDeserializerClass = this.valueDeserializer.getClass();

    @Test
    public void testOverrideClientId() {
        Properties properties = new Properties();
        properties.setProperty("key.deserializer", this.keyDeserializerClassName);
        properties.setProperty("value.deserializer", this.valueDeserializerClassName);
        properties.setProperty("group.id", "test-group");
        ConsumerConfig config = new ConsumerConfig(properties);
        Assert.assertFalse((boolean)config.getString("client.id").isEmpty());
    }

    @Test
    public void testOverrideEnableAutoCommit() {
        Properties properties = new Properties();
        properties.setProperty("key.deserializer", this.keyDeserializerClassName);
        properties.setProperty("value.deserializer", this.valueDeserializerClassName);
        ConsumerConfig config = new ConsumerConfig(properties);
        boolean overrideEnableAutoCommit = config.maybeOverrideEnableAutoCommit();
        Assert.assertFalse((boolean)overrideEnableAutoCommit);
        properties.setProperty("enable.auto.commit", "true");
        config = new ConsumerConfig(properties);
        try {
            config.maybeOverrideEnableAutoCommit();
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void testDeserializerToPropertyConfig() {
        Properties properties = new Properties();
        properties.setProperty("key.deserializer", this.keyDeserializerClassName);
        properties.setProperty("value.deserializer", this.valueDeserializerClassName);
        Properties newProperties = ConsumerConfig.addDeserializerToConfig((Properties)properties, null, null);
        Assert.assertEquals((Object)newProperties.get("key.deserializer"), (Object)this.keyDeserializerClassName);
        Assert.assertEquals((Object)newProperties.get("value.deserializer"), (Object)this.valueDeserializerClassName);
        properties.clear();
        properties.setProperty("value.deserializer", this.valueDeserializerClassName);
        newProperties = ConsumerConfig.addDeserializerToConfig((Properties)properties, this.keyDeserializer, null);
        Assert.assertEquals((Object)newProperties.get("key.deserializer"), (Object)this.keyDeserializerClassName);
        Assert.assertEquals((Object)newProperties.get("value.deserializer"), (Object)this.valueDeserializerClassName);
        properties.clear();
        properties.setProperty("key.deserializer", this.keyDeserializerClassName);
        newProperties = ConsumerConfig.addDeserializerToConfig((Properties)properties, null, this.valueDeserializer);
        Assert.assertEquals((Object)newProperties.get("key.deserializer"), (Object)this.keyDeserializerClassName);
        Assert.assertEquals((Object)newProperties.get("value.deserializer"), (Object)this.valueDeserializerClassName);
        properties.clear();
        newProperties = ConsumerConfig.addDeserializerToConfig((Properties)properties, this.keyDeserializer, this.valueDeserializer);
        Assert.assertEquals((Object)newProperties.get("key.deserializer"), (Object)this.keyDeserializerClassName);
        Assert.assertEquals((Object)newProperties.get("value.deserializer"), (Object)this.valueDeserializerClassName);
    }

    @Test
    public void testAppendDeserializerToConfig() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.deserializer", this.keyDeserializerClass);
        configs.put("value.deserializer", this.valueDeserializerClass);
        Map newConfigs = ConsumerConfig.appendDeserializerToConfig(configs, null, null);
        Assert.assertEquals(newConfigs.get("key.deserializer"), (Object)this.keyDeserializerClass);
        Assert.assertEquals(newConfigs.get("value.deserializer"), (Object)this.valueDeserializerClass);
        configs.clear();
        configs.put("value.deserializer", this.valueDeserializerClass);
        newConfigs = ConsumerConfig.appendDeserializerToConfig(configs, this.keyDeserializer, null);
        Assert.assertEquals(newConfigs.get("key.deserializer"), (Object)this.keyDeserializerClass);
        Assert.assertEquals(newConfigs.get("value.deserializer"), (Object)this.valueDeserializerClass);
        configs.clear();
        configs.put("key.deserializer", this.keyDeserializerClass);
        newConfigs = ConsumerConfig.appendDeserializerToConfig(configs, null, this.valueDeserializer);
        Assert.assertEquals(newConfigs.get("key.deserializer"), (Object)this.keyDeserializerClass);
        Assert.assertEquals(newConfigs.get("value.deserializer"), (Object)this.valueDeserializerClass);
        configs.clear();
        newConfigs = ConsumerConfig.appendDeserializerToConfig(configs, this.keyDeserializer, this.valueDeserializer);
        Assert.assertEquals(newConfigs.get("key.deserializer"), (Object)this.keyDeserializerClass);
        Assert.assertEquals(newConfigs.get("value.deserializer"), (Object)this.valueDeserializerClass);
    }

    @Test
    public void ensureDefaultThrowOnUnsupportedStableFlagToFalse() {
        Properties properties = new Properties();
        properties.setProperty("key.deserializer", this.keyDeserializerClassName);
        properties.setProperty("value.deserializer", this.valueDeserializerClassName);
        Assert.assertFalse((boolean)new ConsumerConfig(properties).getBoolean("internal.throw.on.fetch.stable.offset.unsupported"));
    }
}

