/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.header.internals;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.junit.Assert;
import org.junit.Test;

public class RecordHeadersTest {
    @Test
    public void testAdd() {
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("key", "value".getBytes()));
        Header header = (Header)headers.iterator().next();
        RecordHeadersTest.assertHeader("key", "value", header);
        headers.add((Header)new RecordHeader("key2", "value2".getBytes()));
        RecordHeadersTest.assertHeader("key2", "value2", headers.lastHeader("key2"));
        Assert.assertEquals((long)2L, (long)this.getCount((Headers)headers));
    }

    @Test
    public void testRemove() {
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("key", "value".getBytes()));
        Assert.assertTrue((boolean)headers.iterator().hasNext());
        headers.remove("key");
        Assert.assertFalse((boolean)headers.iterator().hasNext());
    }

    @Test
    public void testAddRemoveInterleaved() {
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("key", "value".getBytes()));
        headers.add((Header)new RecordHeader("key2", "value2".getBytes()));
        Assert.assertTrue((boolean)headers.iterator().hasNext());
        headers.remove("key");
        Assert.assertEquals((long)1L, (long)this.getCount((Headers)headers));
        headers.add((Header)new RecordHeader("key3", "value3".getBytes()));
        Assert.assertNull((Object)headers.lastHeader("key"));
        RecordHeadersTest.assertHeader("key2", "value2", headers.lastHeader("key2"));
        RecordHeadersTest.assertHeader("key3", "value3", headers.lastHeader("key3"));
        Assert.assertEquals((long)2L, (long)this.getCount((Headers)headers));
        headers.remove("key2");
        Assert.assertNull((Object)headers.lastHeader("key"));
        Assert.assertNull((Object)headers.lastHeader("key2"));
        RecordHeadersTest.assertHeader("key3", "value3", headers.lastHeader("key3"));
        Assert.assertEquals((long)1L, (long)this.getCount((Headers)headers));
        headers.add((Header)new RecordHeader("key3", "value4".getBytes()));
        RecordHeadersTest.assertHeader("key3", "value4", headers.lastHeader("key3"));
        Assert.assertEquals((long)2L, (long)this.getCount((Headers)headers));
        headers.add((Header)new RecordHeader("key", "valueNew".getBytes()));
        Assert.assertEquals((long)3L, (long)this.getCount((Headers)headers));
        RecordHeadersTest.assertHeader("key", "valueNew", headers.lastHeader("key"));
        headers.remove("key3");
        Assert.assertEquals((long)1L, (long)this.getCount((Headers)headers));
        Assert.assertNull((Object)headers.lastHeader("key2"));
        headers.remove("key");
        Assert.assertFalse((boolean)headers.iterator().hasNext());
    }

    @Test
    public void testLastHeader() {
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("key", "value".getBytes()));
        headers.add((Header)new RecordHeader("key", "value2".getBytes()));
        headers.add((Header)new RecordHeader("key", "value3".getBytes()));
        RecordHeadersTest.assertHeader("key", "value3", headers.lastHeader("key"));
        Assert.assertEquals((long)3L, (long)this.getCount((Headers)headers));
    }

    @Test
    public void testReadOnly() throws IOException {
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("key", "value".getBytes()));
        Iterator headerIteratorBeforeClose = headers.iterator();
        headers.setReadOnly();
        try {
            headers.add((Header)new RecordHeader("key", "value".getBytes()));
            Assert.fail((String)"IllegalStateException expected as headers are closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            headers.remove("key");
            Assert.fail((String)"IllegalStateException expected as headers are closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Iterator headerIterator = headers.iterator();
            headerIterator.next();
            headerIterator.remove();
            Assert.fail((String)"IllegalStateException expected as headers are closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            headerIteratorBeforeClose.next();
            headerIteratorBeforeClose.remove();
            Assert.fail((String)"IllegalStateException expected as headers are closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testHeaders() throws IOException {
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("key", "value".getBytes()));
        headers.add((Header)new RecordHeader("key1", "key1value".getBytes()));
        headers.add((Header)new RecordHeader("key", "value2".getBytes()));
        headers.add((Header)new RecordHeader("key2", "key2value".getBytes()));
        Iterator keyHeaders = headers.headers("key").iterator();
        RecordHeadersTest.assertHeader("key", "value", (Header)keyHeaders.next());
        RecordHeadersTest.assertHeader("key", "value2", (Header)keyHeaders.next());
        Assert.assertFalse((boolean)keyHeaders.hasNext());
        keyHeaders = headers.headers("key1").iterator();
        RecordHeadersTest.assertHeader("key1", "key1value", (Header)keyHeaders.next());
        Assert.assertFalse((boolean)keyHeaders.hasNext());
        keyHeaders = headers.headers("key2").iterator();
        RecordHeadersTest.assertHeader("key2", "key2value", (Header)keyHeaders.next());
        Assert.assertFalse((boolean)keyHeaders.hasNext());
    }

    @Test
    public void testNew() throws IOException {
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("key", "value".getBytes()));
        headers.setReadOnly();
        RecordHeaders newHeaders = new RecordHeaders((Iterable)headers);
        newHeaders.add((Header)new RecordHeader("key", "value2".getBytes()));
        RecordHeadersTest.assertHeader("key", "value", headers.lastHeader("key"));
        Assert.assertEquals((long)1L, (long)this.getCount((Headers)headers));
        RecordHeadersTest.assertHeader("key", "value2", newHeaders.lastHeader("key"));
        Assert.assertEquals((long)2L, (long)this.getCount((Headers)newHeaders));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNpeWhenAddingNullHeader() {
        new RecordHeaders().add(null);
    }

    private int getCount(Headers headers) {
        int count = 0;
        Iterator headerIterator = headers.iterator();
        while (headerIterator.hasNext()) {
            headerIterator.next();
            ++count;
        }
        return count;
    }

    static void assertHeader(String key, String value, Header actual) {
        Assert.assertEquals((Object)key, (Object)actual.key());
        Assert.assertTrue((boolean)Arrays.equals(value.getBytes(), actual.value()));
    }
}

