/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class KafkaChannelTest {
    @Test
    public void testSending() throws IOException {
        Authenticator authenticator = (Authenticator)Mockito.mock(Authenticator.class);
        TransportLayer transport = (TransportLayer)Mockito.mock(TransportLayer.class);
        MemoryPool pool = (MemoryPool)Mockito.mock(MemoryPool.class);
        ChannelMetadataRegistry metadataRegistry = (ChannelMetadataRegistry)Mockito.mock(ChannelMetadataRegistry.class);
        KafkaChannel channel = new KafkaChannel("0", transport, () -> authenticator, 1024, pool, metadataRegistry);
        NetworkSend send = new NetworkSend("0", ByteBuffer.wrap(TestUtils.randomBytes(128)));
        channel.setSend((Send)send);
        Assert.assertTrue((boolean)channel.hasSend());
        Assert.assertThrows(IllegalStateException.class, () -> channel.setSend((Send)send));
        Mockito.when((Object)transport.write((ByteBuffer[])Mockito.any(ByteBuffer[].class))).thenReturn((Object)4L);
        Assert.assertEquals((long)4L, (long)channel.write());
        Assert.assertEquals((long)128L, (long)send.remaining());
        Assert.assertNull((Object)channel.maybeCompleteSend());
        Mockito.when((Object)transport.write((ByteBuffer[])Mockito.any(ByteBuffer[].class))).thenReturn((Object)64L);
        Assert.assertEquals((long)64L, (long)channel.write());
        Assert.assertEquals((long)64L, (long)send.remaining());
        Assert.assertNull((Object)channel.maybeCompleteSend());
        Mockito.when((Object)transport.write((ByteBuffer[])Mockito.any(ByteBuffer[].class))).thenReturn((Object)64L);
        Assert.assertEquals((long)64L, (long)channel.write());
        Assert.assertEquals((long)0L, (long)send.remaining());
        Assert.assertEquals((Object)send, (Object)channel.maybeCompleteSend());
    }

    @Test
    public void testReceiving() throws IOException {
        Authenticator authenticator = (Authenticator)Mockito.mock(Authenticator.class);
        TransportLayer transport = (TransportLayer)Mockito.mock(TransportLayer.class);
        MemoryPool pool = (MemoryPool)Mockito.mock(MemoryPool.class);
        ChannelMetadataRegistry metadataRegistry = (ChannelMetadataRegistry)Mockito.mock(ChannelMetadataRegistry.class);
        ArgumentCaptor sizeCaptor = ArgumentCaptor.forClass(Integer.class);
        Mockito.when((Object)pool.tryAllocate(((Integer)sizeCaptor.capture()).intValue())).thenAnswer(invocation -> ByteBuffer.allocate((Integer)sizeCaptor.getValue()));
        KafkaChannel channel = new KafkaChannel("0", transport, () -> authenticator, 1024, pool, metadataRegistry);
        ArgumentCaptor bufferCaptor = ArgumentCaptor.forClass(ByteBuffer.class);
        Mockito.when((Object)transport.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).putInt(128);
            return 4;
        }).thenReturn((Object)0);
        Assert.assertEquals((long)4L, (long)channel.read());
        Assert.assertEquals((long)4L, (long)channel.currentReceive().bytesRead());
        Assert.assertNull((Object)channel.maybeCompleteReceive());
        Mockito.reset((Object[])new TransportLayer[]{transport});
        Mockito.when((Object)transport.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).put(TestUtils.randomBytes(64));
            return 64;
        });
        Assert.assertEquals((long)64L, (long)channel.read());
        Assert.assertEquals((long)68L, (long)channel.currentReceive().bytesRead());
        Assert.assertNull((Object)channel.maybeCompleteReceive());
        Mockito.reset((Object[])new TransportLayer[]{transport});
        Mockito.when((Object)transport.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).put(TestUtils.randomBytes(64));
            return 64;
        });
        Assert.assertEquals((long)64L, (long)channel.read());
        Assert.assertEquals((long)132L, (long)channel.currentReceive().bytesRead());
        Assert.assertNotNull((Object)channel.maybeCompleteReceive());
        Assert.assertNull((Object)channel.currentReceive());
    }
}

