/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;

public class ByteBufferChannel
implements GatheringByteChannel {
    private final ByteBuffer buf;
    private boolean closed = false;

    public ByteBufferChannel(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size should be not be greater than Integer.MAX_VALUE");
        }
        this.buf = ByteBuffer.allocate((int)size);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        int position = this.buf.position();
        for (int i = 0; i < length; ++i) {
            ByteBuffer src = srcs[i].duplicate();
            if (i == 0) {
                src.position(offset);
            }
            this.buf.put(src);
        }
        return this.buf.position() - position;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int position = this.buf.position();
        this.buf.put(src);
        return this.buf.position() - position;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.buf.flip();
        this.closed = true;
    }

    public ByteBuffer buffer() {
        return this.buf;
    }
}

