/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.MetadataRequest;
import org.junit.Assert;
import org.junit.Test;

public class MetadataRequestTest {
    @Test
    public void testEmptyMeansAllTopicsV0() {
        MetadataRequestData data = new MetadataRequestData();
        MetadataRequest parsedRequest = new MetadataRequest(data, 0);
        Assert.assertTrue((boolean)parsedRequest.isAllTopics());
        Assert.assertNull((Object)parsedRequest.topics());
    }

    @Test
    public void testEmptyMeansEmptyForVersionsAboveV0() {
        for (int i = 1; i < MetadataRequestData.SCHEMAS.length; ++i) {
            MetadataRequestData data = new MetadataRequestData();
            data.setAllowAutoTopicCreation(true);
            MetadataRequest parsedRequest = new MetadataRequest(data, (short)i);
            Assert.assertFalse((boolean)parsedRequest.isAllTopics());
            Assert.assertEquals(Collections.emptyList(), (Object)parsedRequest.topics());
        }
    }

    @Test
    public void testMetadataRequestVersion() {
        MetadataRequest.Builder builder = new MetadataRequest.Builder(Collections.singletonList("topic"), false);
        Assert.assertEquals((long)ApiKeys.METADATA.oldestVersion(), (long)builder.oldestAllowedVersion());
        Assert.assertEquals((long)ApiKeys.METADATA.latestVersion(), (long)builder.latestAllowedVersion());
        short version = 5;
        MetadataRequest.Builder builder2 = new MetadataRequest.Builder(Collections.singletonList("topic"), false, version);
        Assert.assertEquals((long)version, (long)builder2.oldestAllowedVersion());
        Assert.assertEquals((long)version, (long)builder2.latestAllowedVersion());
        short minVersion = 1;
        short maxVersion = 6;
        MetadataRequest.Builder builder3 = new MetadataRequest.Builder(Collections.singletonList("topic"), false, minVersion, maxVersion);
        Assert.assertEquals((long)minVersion, (long)builder3.oldestAllowedVersion());
        Assert.assertEquals((long)maxVersion, (long)builder3.latestAllowedVersion());
    }
}

