/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageTestUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class UpdateMetadataRequestTest {
    @Test
    public void testUnsupportedVersion() {
        UpdateMetadataRequest.Builder builder = new UpdateMetadataRequest.Builder((short)(ApiKeys.UPDATE_METADATA.latestVersion() + 1), 0, 0, 0L, Collections.emptyList(), Collections.emptyList());
        Assert.assertThrows(UnsupportedVersionException.class, () -> ((UpdateMetadataRequest.Builder)builder).build());
    }

    @Test
    public void testGetErrorResponse() {
        for (short version = ApiKeys.UPDATE_METADATA.oldestVersion(); version < ApiKeys.UPDATE_METADATA.latestVersion(); version = (short)(version + 1)) {
            UpdateMetadataRequest.Builder builder = new UpdateMetadataRequest.Builder(version, 0, 0, 0L, Collections.emptyList(), Collections.emptyList());
            UpdateMetadataRequest request = (UpdateMetadataRequest)builder.build();
            UpdateMetadataResponse response = request.getErrorResponse(0, (Throwable)new ClusterAuthorizationException("Not authorized"));
            Assert.assertEquals((Object)Errors.CLUSTER_AUTHORIZATION_FAILED, (Object)response.error());
        }
    }

    @Test
    public void testVersionLogic() {
        for (short version = ApiKeys.UPDATE_METADATA.oldestVersion(); version <= ApiKeys.UPDATE_METADATA.latestVersion(); version = (short)(version + 1)) {
            List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates = Arrays.asList(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic0").setPartitionIndex(0).setControllerEpoch(2).setLeader(0).setLeaderEpoch(10).setIsr(Arrays.asList(0, 1)).setZkVersion(10).setReplicas(Arrays.asList(0, 1, 2)).setOfflineReplicas(Arrays.asList(2)), new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic0").setPartitionIndex(1).setControllerEpoch(2).setLeader(1).setLeaderEpoch(11).setIsr(Arrays.asList(1, 2, 3)).setZkVersion(11).setReplicas(Arrays.asList(1, 2, 3)).setOfflineReplicas(Collections.emptyList()), new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic1").setPartitionIndex(0).setControllerEpoch(2).setLeader(2).setLeaderEpoch(11).setIsr(Arrays.asList(2, 3)).setZkVersion(11).setReplicas(Arrays.asList(2, 3, 4)).setOfflineReplicas(Collections.emptyList()));
            ArrayList<UpdateMetadataRequestData.UpdateMetadataEndpoint> broker0Endpoints = new ArrayList<UpdateMetadataRequestData.UpdateMetadataEndpoint>();
            broker0Endpoints.add(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9090).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id));
            if (version >= 1) {
                broker0Endpoints.add(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9091).setSecurityProtocol(SecurityProtocol.SSL.id));
            }
            if (version >= 3) {
                ((UpdateMetadataRequestData.UpdateMetadataEndpoint)broker0Endpoints.get(0)).setListener("listener0");
                ((UpdateMetadataRequestData.UpdateMetadataEndpoint)broker0Endpoints.get(1)).setListener("listener1");
            }
            List<UpdateMetadataRequestData.UpdateMetadataBroker> liveBrokers = Arrays.asList(new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack0").setEndpoints(broker0Endpoints), new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(Arrays.asList(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(9090).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener("PLAINTEXT"))));
            UpdateMetadataRequest request = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 1, 2, 3L, partitionStates, liveBrokers).build();
            Assert.assertEquals(new HashSet<UpdateMetadataRequestData.UpdateMetadataPartitionState>(partitionStates), this.iterableToSet(request.partitionStates()));
            Assert.assertEquals(liveBrokers, (Object)request.liveBrokers());
            Assert.assertEquals((long)1L, (long)request.controllerId());
            Assert.assertEquals((long)2L, (long)request.controllerEpoch());
            Assert.assertEquals((long)3L, (long)request.brokerEpoch());
            ByteBuffer byteBuffer = MessageTestUtil.messageToByteBuffer((Message)request.data(), request.version());
            UpdateMetadataRequest deserializedRequest = new UpdateMetadataRequest(new UpdateMetadataRequestData((Readable)new ByteBufferAccessor(byteBuffer), version), version);
            if (version < 2) {
                for (UpdateMetadataRequestData.UpdateMetadataBroker liveBroker : liveBrokers) {
                    liveBroker.setRack("");
                }
            }
            if (version < 3) {
                for (UpdateMetadataRequestData.UpdateMetadataBroker liveBroker : liveBrokers) {
                    for (UpdateMetadataRequestData.UpdateMetadataEndpoint endpoint : liveBroker.endpoints()) {
                        SecurityProtocol securityProtocol = SecurityProtocol.forId((short)endpoint.securityProtocol());
                        endpoint.setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value());
                    }
                }
            }
            if (version < 4) {
                partitionStates.get(0).setOfflineReplicas(Collections.emptyList());
            }
            Assert.assertEquals(new HashSet<UpdateMetadataRequestData.UpdateMetadataPartitionState>(partitionStates), this.iterableToSet(deserializedRequest.partitionStates()));
            Assert.assertEquals(liveBrokers, (Object)deserializedRequest.liveBrokers());
            Assert.assertEquals((long)1L, (long)request.controllerId());
            Assert.assertEquals((long)2L, (long)request.controllerEpoch());
            Assert.assertEquals((long)3L, (long)request.brokerEpoch());
        }
    }

    @Test
    public void testTopicPartitionGroupingSizeReduction() {
        Set<TopicPartition> tps = TestUtils.generateRandomTopicPartitions(10, 10);
        ArrayList<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates = new ArrayList<UpdateMetadataRequestData.UpdateMetadataPartitionState>();
        for (TopicPartition tp : tps) {
            partitionStates.add(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()));
        }
        UpdateMetadataRequest.Builder builder = new UpdateMetadataRequest.Builder(5, 0, 0, 0L, partitionStates, Collections.emptyList());
        Assert.assertTrue((MessageTestUtil.messageSize((Message)builder.build((short)5).data(), (short)5) < MessageTestUtil.messageSize((Message)builder.build((short)4).data(), (short)4) ? 1 : 0) != 0);
    }

    private <T> Set<T> iterableToSet(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toSet());
    }
}

