/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.unsecured;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;
import org.junit.Assert;
import org.junit.Test;

public class OAuthBearerUnsecuredJwsTest {
    private static final String QUOTE = "\"";
    private static final String HEADER_COMPACT_SERIALIZATION = Base64.getUrlEncoder().withoutPadding().encodeToString("{\"alg\":\"none\"}".getBytes(StandardCharsets.UTF_8)) + ".";

    @Test
    public void validClaims() throws OAuthBearerIllegalTokenException {
        double issuedAtSeconds = 100.1;
        double expirationTimeSeconds = 300.3;
        StringBuilder sb = new StringBuilder("{");
        OAuthBearerUnsecuredJwsTest.appendJsonText(sb, "sub", "SUBJECT");
        OAuthBearerUnsecuredJwsTest.appendCommaJsonText(sb, "iat", issuedAtSeconds);
        OAuthBearerUnsecuredJwsTest.appendCommaJsonText(sb, "exp", expirationTimeSeconds);
        sb.append("}");
        String compactSerialization = HEADER_COMPACT_SERIALIZATION + Base64.getUrlEncoder().withoutPadding().encodeToString(sb.toString().getBytes(StandardCharsets.UTF_8)) + ".";
        OAuthBearerUnsecuredJws testJwt = new OAuthBearerUnsecuredJws(compactSerialization, "sub", "scope");
        Assert.assertEquals((Object)compactSerialization, (Object)testJwt.value());
        Assert.assertEquals((Object)"sub", (Object)testJwt.principalClaimName());
        Assert.assertEquals((long)1L, (long)testJwt.header().size());
        Assert.assertEquals((Object)"none", testJwt.header().get("alg"));
        Assert.assertEquals((Object)"scope", (Object)testJwt.scopeClaimName());
        Assert.assertEquals((Object)expirationTimeSeconds, (Object)testJwt.expirationTime());
        Assert.assertTrue((boolean)testJwt.isClaimType("exp", Number.class));
        Assert.assertEquals((Object)issuedAtSeconds, (Object)testJwt.issuedAt());
        Assert.assertEquals((Object)"SUBJECT", (Object)testJwt.subject());
    }

    @Test
    public void validCompactSerialization() {
        String subject = "foo";
        long issuedAt = 100L;
        long expirationTime = issuedAt + 3600L;
        List<String> scope = Arrays.asList("scopeValue1", "scopeValue2");
        String validCompactSerialization = OAuthBearerUnsecuredJwsTest.compactSerialization(subject, issuedAt, expirationTime, scope);
        OAuthBearerUnsecuredJws jws = new OAuthBearerUnsecuredJws(validCompactSerialization, "sub", "scope");
        Assert.assertEquals((long)1L, (long)jws.header().size());
        Assert.assertEquals((Object)"none", jws.header().get("alg"));
        Assert.assertEquals((long)4L, (long)jws.claims().size());
        Assert.assertEquals((Object)subject, jws.claims().get("sub"));
        Assert.assertEquals((Object)subject, (Object)jws.principalName());
        Assert.assertEquals((long)issuedAt, (long)((Number)Number.class.cast(jws.claims().get("iat"))).longValue());
        Assert.assertEquals((long)expirationTime, (long)((Number)Number.class.cast(jws.claims().get("exp"))).longValue());
        Assert.assertEquals((long)(expirationTime * 1000L), (long)jws.lifetimeMs());
        Assert.assertEquals(scope, jws.claims().get("scope"));
        Assert.assertEquals(new HashSet<String>(scope), (Object)jws.scope());
        Assert.assertEquals((long)3L, (long)jws.splits().size());
        Assert.assertEquals((Object)validCompactSerialization.split("\\.")[0], jws.splits().get(0));
        Assert.assertEquals((Object)validCompactSerialization.split("\\.")[1], jws.splits().get(1));
        Assert.assertEquals((Object)"", jws.splits().get(2));
    }

    @Test(expected=OAuthBearerIllegalTokenException.class)
    public void missingPrincipal() {
        String subject = null;
        long issuedAt = 100L;
        Long expirationTime = null;
        List<String> scope = Arrays.asList("scopeValue1", "scopeValue2");
        String validCompactSerialization = OAuthBearerUnsecuredJwsTest.compactSerialization(subject, issuedAt, expirationTime, scope);
        new OAuthBearerUnsecuredJws(validCompactSerialization, "sub", "scope");
    }

    @Test(expected=OAuthBearerIllegalTokenException.class)
    public void blankPrincipalName() {
        String subject = "   ";
        long issuedAt = 100L;
        long expirationTime = issuedAt + 3600L;
        List<String> scope = Arrays.asList("scopeValue1", "scopeValue2");
        String validCompactSerialization = OAuthBearerUnsecuredJwsTest.compactSerialization(subject, issuedAt, expirationTime, scope);
        new OAuthBearerUnsecuredJws(validCompactSerialization, "sub", "scope");
    }

    private static String compactSerialization(String subject, Long issuedAt, Long expirationTime, List<String> scope) {
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        String algorithm = "none";
        String headerJson = "{\"alg\":\"" + algorithm + "\"}";
        String encodedHeader = encoder.encodeToString(headerJson.getBytes(StandardCharsets.UTF_8));
        String subjectJson = subject != null ? "\"sub\":\"" + subject + QUOTE : null;
        String issuedAtJson = issuedAt != null ? "\"iat\":" + issuedAt : null;
        String expirationTimeJson = expirationTime != null ? "\"exp\":" + expirationTime : null;
        String scopeJson = scope != null ? OAuthBearerUnsecuredJwsTest.scopeJson(scope) : null;
        String claimsJson = OAuthBearerUnsecuredJwsTest.claimsJson(subjectJson, issuedAtJson, expirationTimeJson, scopeJson);
        String encodedClaims = encoder.encodeToString(claimsJson.getBytes(StandardCharsets.UTF_8));
        return encodedHeader + "." + encodedClaims + ".";
    }

    private static String claimsJson(String ... jsonValues) {
        StringBuilder claimsJsonBuilder = new StringBuilder("{");
        int initialLength = claimsJsonBuilder.length();
        for (String jsonValue : jsonValues) {
            if (jsonValue == null) continue;
            if (claimsJsonBuilder.length() > initialLength) {
                claimsJsonBuilder.append(',');
            }
            claimsJsonBuilder.append(jsonValue);
        }
        claimsJsonBuilder.append('}');
        return claimsJsonBuilder.toString();
    }

    private static String scopeJson(List<String> scope) {
        StringBuilder scopeJsonBuilder = new StringBuilder("\"scope\":[");
        int initialLength = scopeJsonBuilder.length();
        for (String scopeValue : scope) {
            if (scopeJsonBuilder.length() > initialLength) {
                scopeJsonBuilder.append(',');
            }
            scopeJsonBuilder.append('\"').append(scopeValue).append('\"');
        }
        scopeJsonBuilder.append(']');
        return scopeJsonBuilder.toString();
    }

    private static void appendCommaJsonText(StringBuilder sb, String claimName, Number claimValue) {
        sb.append(',').append(QUOTE).append(OAuthBearerUnsecuredJwsTest.escape(claimName)).append(QUOTE).append(":").append(claimValue);
    }

    private static void appendJsonText(StringBuilder sb, String claimName, String claimValue) {
        sb.append(QUOTE).append(OAuthBearerUnsecuredJwsTest.escape(claimName)).append(QUOTE).append(":").append(QUOTE).append(OAuthBearerUnsecuredJwsTest.escape(claimValue)).append(QUOTE);
    }

    private static String escape(String jsonStringValue) {
        return jsonStringValue.replace(QUOTE, "\\\"").replace("\\", "\\\\");
    }
}

