/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.plain.internals;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.plain.internals.PlainSaslServer;
import org.apache.kafka.common.security.plain.internals.PlainServerCallbackHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PlainSaslServerTest {
    private static final String USER_A = "userA";
    private static final String PASSWORD_A = "passwordA";
    private static final String USER_B = "userB";
    private static final String PASSWORD_B = "passwordB";
    private PlainSaslServer saslServer;

    @Before
    public void setUp() {
        TestJaasConfig jaasConfig = new TestJaasConfig();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("user_userA", PASSWORD_A);
        options.put("user_userB", PASSWORD_B);
        jaasConfig.addEntry("jaasContext", PlainLoginModule.class.getName(), options);
        JaasContext jaasContext = new JaasContext("jaasContext", JaasContext.Type.SERVER, (Configuration)jaasConfig, null);
        PlainServerCallbackHandler callbackHandler = new PlainServerCallbackHandler();
        callbackHandler.configure(null, "PLAIN", jaasContext.configurationEntries());
        this.saslServer = new PlainSaslServer((CallbackHandler)callbackHandler);
    }

    @Test
    public void noAuthorizationIdSpecified() throws Exception {
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.saslMessage("", USER_A, PASSWORD_A));
        Assert.assertEquals((long)0L, (long)nextChallenge.length);
    }

    @Test
    public void authorizatonIdEqualsAuthenticationId() throws Exception {
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.saslMessage(USER_A, USER_A, PASSWORD_A));
        Assert.assertEquals((long)0L, (long)nextChallenge.length);
    }

    @Test(expected=SaslAuthenticationException.class)
    public void authorizatonIdNotEqualsAuthenticationId() throws Exception {
        this.saslServer.evaluateResponse(this.saslMessage(USER_B, USER_A, PASSWORD_A));
    }

    @Test
    public void emptyTokens() {
        Exception e = (Exception)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("", "", "")));
        Assert.assertEquals((Object)"Authentication failed: username not specified", (Object)e.getMessage());
        e = (Exception)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("", "", "p")));
        Assert.assertEquals((Object)"Authentication failed: username not specified", (Object)e.getMessage());
        e = (Exception)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("", "u", "")));
        Assert.assertEquals((Object)"Authentication failed: password not specified", (Object)e.getMessage());
        e = (Exception)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("a", "", "")));
        Assert.assertEquals((Object)"Authentication failed: username not specified", (Object)e.getMessage());
        e = (Exception)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("a", "", "p")));
        Assert.assertEquals((Object)"Authentication failed: username not specified", (Object)e.getMessage());
        e = (Exception)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("a", "u", "")));
        Assert.assertEquals((Object)"Authentication failed: password not specified", (Object)e.getMessage());
        String nul = "\u0000";
        e = (Exception)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(String.format("%s%s%s%s%s%s", "a", nul, "u", nul, "p", nul).getBytes(StandardCharsets.UTF_8)));
        Assert.assertEquals((Object)"Invalid SASL/PLAIN response: expected 3 tokens, got 4", (Object)e.getMessage());
        e = (Exception)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(String.format("%s%s%s", "", nul, "u").getBytes(StandardCharsets.UTF_8)));
        Assert.assertEquals((Object)"Invalid SASL/PLAIN response: expected 3 tokens, got 2", (Object)e.getMessage());
    }

    private byte[] saslMessage(String authorizationId, String userName, String password) {
        String nul = "\u0000";
        String message = String.format("%s%s%s%s%s", authorizationId, nul, userName, nul, password);
        return message.getBytes(StandardCharsets.UTF_8);
    }
}

