/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AppInfoParserTest {
    private static final String EXPECTED_COMMIT_VERSION = "unknown";
    private static final String EXPECTED_VERSION = "unknown";
    private static final Long EXPECTED_START_MS = 1552313875722L;
    private static final String METRICS_PREFIX = "app-info-test";
    private static final String METRICS_ID = "test";
    private Metrics metrics;
    private MBeanServer mBeanServer;

    @Before
    public void setUp() {
        this.metrics = new Metrics((Time)new MockTime(1L));
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    @After
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testRegisterAppInfoRegistersMetrics() throws JMException {
        this.registerAppInfo();
    }

    @Test
    public void testUnregisterAppInfoUnregistersMetrics() throws JMException {
        this.registerAppInfo();
        AppInfoParser.unregisterAppInfo((String)METRICS_PREFIX, (String)METRICS_ID, (Metrics)this.metrics);
        Assert.assertFalse((boolean)this.mBeanServer.isRegistered(this.expectedAppObjectName()));
        Assert.assertNull((Object)this.metrics.metric(this.metrics.metricName("commit-id", "app-info")));
        Assert.assertNull((Object)this.metrics.metric(this.metrics.metricName("version", "app-info")));
        Assert.assertNull((Object)this.metrics.metric(this.metrics.metricName("start-time-ms", "app-info")));
    }

    private void registerAppInfo() throws JMException {
        Assert.assertEquals((Object)"unknown", (Object)AppInfoParser.getCommitId());
        Assert.assertEquals((Object)"unknown", (Object)AppInfoParser.getVersion());
        AppInfoParser.registerAppInfo((String)METRICS_PREFIX, (String)METRICS_ID, (Metrics)this.metrics, (long)EXPECTED_START_MS);
        Assert.assertTrue((boolean)this.mBeanServer.isRegistered(this.expectedAppObjectName()));
        Assert.assertEquals((Object)"unknown", (Object)this.metrics.metric(this.metrics.metricName("commit-id", "app-info")).metricValue());
        Assert.assertEquals((Object)"unknown", (Object)this.metrics.metric(this.metrics.metricName("version", "app-info")).metricValue());
        Assert.assertEquals((Object)EXPECTED_START_MS, (Object)this.metrics.metric(this.metrics.metricName("start-time-ms", "app-info")).metricValue());
    }

    private ObjectName expectedAppObjectName() throws MalformedObjectNameException {
        return new ObjectName("app-info-test:type=app-info,id=test");
    }
}

