/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterMirrorsResponseData
implements ApiMessage {
    int throttleTimeMs;
    List<OpData> ops;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("ops", new CompactArrayOf(OpData.SCHEMA_0), "The cluster link creation results."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AlterMirrorsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AlterMirrorsResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public AlterMirrorsResponseData() {
        this.throttleTimeMs = 0;
        this.ops = new ArrayList<OpData>(0);
    }

    @Override
    public short apiKey() {
        return 10006;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field ops was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<OpData> newCollection = new ArrayList<OpData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new OpData(_readable, _version));
        }
        this.ops = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeUnsignedVarint(this.ops.size() + 1);
        for (OpData opsElement : this.ops) {
            opsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] _nestedObjects = struct.getArray("ops");
        this.ops = new ArrayList<OpData>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.ops.add(new OpData((Struct)nestedObject, _version));
        }
        if (!_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        _taggedFields = new TreeMap();
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] _nestedObjects = new Struct[this.ops.size()];
        int i = 0;
        for (OpData element : this.ops) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("ops", (Object)_nestedObjects);
        struct.set("_tagged_fields", _taggedFields);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        int _arraySize = 0;
        _arraySize += ByteUtils.sizeOfUnsignedVarint(this.ops.size() + 1);
        for (OpData opsElement : this.ops) {
            _arraySize += opsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        return _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterMirrorsResponseData)) {
            return false;
        }
        AlterMirrorsResponseData other = (AlterMirrorsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.ops == null ? other.ops != null : !this.ops.equals(other.ops)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.ops == null ? 0 : this.ops.hashCode());
        return hashCode;
    }

    @Override
    public AlterMirrorsResponseData duplicate() {
        AlterMirrorsResponseData _duplicate = new AlterMirrorsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<OpData> newOps = new ArrayList<OpData>(this.ops.size());
        for (OpData _element : this.ops) {
            newOps.add(_element.duplicate());
        }
        _duplicate.ops = newOps;
        return _duplicate;
    }

    public String toString() {
        return "AlterMirrorsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", ops=" + MessageUtil.deepToString(this.ops.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<OpData> ops() {
        return this.ops;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterMirrorsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public AlterMirrorsResponseData setOps(List<OpData> v) {
        this.ops = v;
        return this;
    }

    public static class ClearTopicMirrorData
    implements Message {
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public ClearTopicMirrorData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ClearTopicMirrorData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public ClearTopicMirrorData() {
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ClearTopicMirrorData");
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ClearTopicMirrorData");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ClearTopicMirrorData");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ClearTopicMirrorData");
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClearTopicMirrorData)) {
                return false;
            }
            ClearTopicMirrorData other = (ClearTopicMirrorData)obj;
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            return hashCode;
        }

        @Override
        public ClearTopicMirrorData duplicate() {
            ClearTopicMirrorData _duplicate = new ClearTopicMirrorData();
            return _duplicate;
        }

        public String toString() {
            return "ClearTopicMirrorData()";
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }
    }

    public static class StopTopicMirrorData
    implements Message {
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public StopTopicMirrorData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public StopTopicMirrorData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public StopTopicMirrorData() {
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of StopTopicMirrorData");
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of StopTopicMirrorData");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of StopTopicMirrorData");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of StopTopicMirrorData");
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StopTopicMirrorData)) {
                return false;
            }
            StopTopicMirrorData other = (StopTopicMirrorData)obj;
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            return hashCode;
        }

        @Override
        public StopTopicMirrorData duplicate() {
            StopTopicMirrorData _duplicate = new StopTopicMirrorData();
            return _duplicate;
        }

        public String toString() {
            return "StopTopicMirrorData()";
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }
    }

    public static class OpData
    implements Message {
        short errorCode;
        String errorMessage;
        List<StopTopicMirrorData> stopTopicMirror;
        List<ClearTopicMirrorData> clearTopicMirror;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or `0` if the link creation succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the link creation succeeded."), new Field("stop_topic_mirror", CompactArrayOf.nullable(StopTopicMirrorData.SCHEMA_0), "Stops a topic's mirroring to become a writable topic."), new Field("clear_topic_mirror", CompactArrayOf.nullable(ClearTopicMirrorData.SCHEMA_0), "Clears a topic's mirror information."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public OpData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public OpData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public OpData() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.stopTopicMirror = null;
            this.clearTopicMirror = null;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<StopTopicMirrorData> newCollection;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OpData");
            }
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _readable.readString(length);
            }
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.stopTopicMirror = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<StopTopicMirrorData>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new StopTopicMirrorData(_readable, _version));
                }
                this.stopTopicMirror = newCollection;
            }
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.clearTopicMirror = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((StopTopicMirrorData)((Object)new ClearTopicMirrorData(_readable, _version)));
                }
                this.clearTopicMirror = newCollection;
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            if (this.stopTopicMirror == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.stopTopicMirror.size() + 1);
                _stringBytes = this.stopTopicMirror.iterator();
                while (_stringBytes.hasNext()) {
                    StopTopicMirrorData stopTopicMirrorElement = (StopTopicMirrorData)_stringBytes.next();
                    stopTopicMirrorElement.write(_writable, _cache, _version);
                }
            }
            if (this.clearTopicMirror == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.clearTopicMirror.size() + 1);
                for (ClearTopicMirrorData clearTopicMirrorElement : this.clearTopicMirror) {
                    clearTopicMirrorElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OpData");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.errorCode = struct.getShort("error_code");
            this.errorMessage = struct.getString("error_message");
            Object[] _nestedObjects = struct.getArray("stop_topic_mirror");
            if (_nestedObjects == null) {
                this.stopTopicMirror = null;
            } else {
                this.stopTopicMirror = new ArrayList<StopTopicMirrorData>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.stopTopicMirror.add(new StopTopicMirrorData((Struct)nestedObject, _version));
                }
            }
            _nestedObjects = struct.getArray("clear_topic_mirror");
            if (_nestedObjects == null) {
                this.clearTopicMirror = null;
            } else {
                this.clearTopicMirror = new ArrayList<ClearTopicMirrorData>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.clearTopicMirror.add(new ClearTopicMirrorData((Struct)nestedObject, _version));
                }
            }
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            int i;
            Struct[] _nestedObjects;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OpData");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("error_message", (Object)this.errorMessage);
            if (this.stopTopicMirror == null) {
                struct.set("stop_topic_mirror", null);
            } else {
                _nestedObjects = new Struct[this.stopTopicMirror.size()];
                i = 0;
                for (StopTopicMirrorData stopTopicMirrorData : this.stopTopicMirror) {
                    _nestedObjects[i++] = stopTopicMirrorData.toStruct(_version);
                }
                struct.set("stop_topic_mirror", (Object)_nestedObjects);
            }
            if (this.clearTopicMirror == null) {
                struct.set("clear_topic_mirror", null);
            } else {
                _nestedObjects = new Struct[this.clearTopicMirror.size()];
                i = 0;
                for (ClearTopicMirrorData clearTopicMirrorData : this.clearTopicMirror) {
                    _nestedObjects[i++] = clearTopicMirrorData.toStruct(_version);
                }
                struct.set("clear_topic_mirror", (Object)_nestedObjects);
            }
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OpData");
            }
            _size += 2;
            if (this.errorMessage == null) {
                ++_size;
            } else {
                byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            }
            if (this.stopTopicMirror == null) {
                ++_size;
            } else {
                int _arraySize = 0;
                _arraySize += ByteUtils.sizeOfUnsignedVarint(this.stopTopicMirror.size() + 1);
                for (StopTopicMirrorData stopTopicMirrorElement : this.stopTopicMirror) {
                    _arraySize += stopTopicMirrorElement.size(_cache, _version);
                }
                _size += _arraySize;
            }
            if (this.clearTopicMirror == null) {
                ++_size;
            } else {
                int _arraySize = 0;
                _arraySize += ByteUtils.sizeOfUnsignedVarint(this.clearTopicMirror.size() + 1);
                for (ClearTopicMirrorData clearTopicMirrorElement : this.clearTopicMirror) {
                    _arraySize += clearTopicMirrorElement.size(_cache, _version);
                }
                _size += _arraySize;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OpData)) {
                return false;
            }
            OpData other = (OpData)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.stopTopicMirror == null ? other.stopTopicMirror != null : !this.stopTopicMirror.equals(other.stopTopicMirror)) {
                return false;
            }
            if (this.clearTopicMirror == null ? other.clearTopicMirror != null : !this.clearTopicMirror.equals(other.clearTopicMirror)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.stopTopicMirror == null ? 0 : this.stopTopicMirror.hashCode());
            hashCode = 31 * hashCode + (this.clearTopicMirror == null ? 0 : this.clearTopicMirror.hashCode());
            return hashCode;
        }

        @Override
        public OpData duplicate() {
            OpData _duplicate = new OpData();
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            if (this.stopTopicMirror == null) {
                _duplicate.stopTopicMirror = null;
            } else {
                ArrayList<StopTopicMirrorData> newStopTopicMirror = new ArrayList<StopTopicMirrorData>(this.stopTopicMirror.size());
                for (StopTopicMirrorData stopTopicMirrorData : this.stopTopicMirror) {
                    newStopTopicMirror.add(stopTopicMirrorData.duplicate());
                }
                _duplicate.stopTopicMirror = newStopTopicMirror;
            }
            if (this.clearTopicMirror == null) {
                _duplicate.clearTopicMirror = null;
            } else {
                ArrayList<ClearTopicMirrorData> newClearTopicMirror = new ArrayList<ClearTopicMirrorData>(this.clearTopicMirror.size());
                for (ClearTopicMirrorData clearTopicMirrorData : this.clearTopicMirror) {
                    newClearTopicMirror.add(clearTopicMirrorData.duplicate());
                }
                _duplicate.clearTopicMirror = newClearTopicMirror;
            }
            return _duplicate;
        }

        public String toString() {
            return "OpData(errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", stopTopicMirror=" + (this.stopTopicMirror == null ? "null" : MessageUtil.deepToString(this.stopTopicMirror.iterator())) + ", clearTopicMirror=" + (this.clearTopicMirror == null ? "null" : MessageUtil.deepToString(this.clearTopicMirror.iterator())) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public List<StopTopicMirrorData> stopTopicMirror() {
            return this.stopTopicMirror;
        }

        public List<ClearTopicMirrorData> clearTopicMirror() {
            return this.clearTopicMirror;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OpData setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public OpData setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public OpData setStopTopicMirror(List<StopTopicMirrorData> v) {
            this.stopTopicMirror = v;
            return this;
        }

        public OpData setClearTopicMirror(List<ClearTopicMirrorData> v) {
            this.clearTopicMirror = v;
            return this;
        }
    }
}

