/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeBrokerAdditionsResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    List<BrokerAdditionsResponse> brokerAdditions;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code"), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("broker_additions", new ArrayOf(BrokerAdditionsResponse.SCHEMA_0), "Addition operations on brokers that are being or have been added."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeBrokerAdditionsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeBrokerAdditionsResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public DescribeBrokerAdditionsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.brokerAdditions = new ArrayList<BrokerAdditionsResponse>(0);
    }

    @Override
    public short apiKey() {
        return 10010;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        short length = _readable.readShort();
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString(length);
        }
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field brokerAdditions was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<BrokerAdditionsResponse> newCollection = new ArrayList<BrokerAdditionsResponse>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new BrokerAdditionsResponse(_readable, _version));
        }
        this.brokerAdditions = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeShort((short)-1);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeInt(this.brokerAdditions.size());
        _stringBytes = this.brokerAdditions.iterator();
        while (_stringBytes.hasNext()) {
            BrokerAdditionsResponse brokerAdditionsElement = (BrokerAdditionsResponse)_stringBytes.next();
            brokerAdditionsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.errorCode = struct.getShort("error_code");
        this.errorMessage = struct.getString("error_message");
        Object[] _nestedObjects = struct.getArray("broker_additions");
        this.brokerAdditions = new ArrayList<BrokerAdditionsResponse>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.brokerAdditions.add(new BrokerAdditionsResponse((Struct)nestedObject, _version));
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        struct.set("error_code", (Object)this.errorCode);
        struct.set("error_message", (Object)this.errorMessage);
        Struct[] _nestedObjects = new Struct[this.brokerAdditions.size()];
        int i = 0;
        for (BrokerAdditionsResponse element : this.brokerAdditions) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("broker_additions", (Object)_nestedObjects);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        _size += 2;
        if (this.errorMessage == null) {
            _size += 2;
        } else {
            byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size += _stringBytes.length + 2;
        }
        int _arraySize = 0;
        _arraySize += 4;
        for (BrokerAdditionsResponse brokerAdditionsElement : this.brokerAdditions) {
            _arraySize += brokerAdditionsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeBrokerAdditionsResponseData)) {
            return false;
        }
        DescribeBrokerAdditionsResponseData other = (DescribeBrokerAdditionsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.brokerAdditions == null ? other.brokerAdditions != null : !this.brokerAdditions.equals(other.brokerAdditions)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.brokerAdditions == null ? 0 : this.brokerAdditions.hashCode());
        return hashCode;
    }

    @Override
    public DescribeBrokerAdditionsResponseData duplicate() {
        DescribeBrokerAdditionsResponseData _duplicate = new DescribeBrokerAdditionsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        ArrayList<BrokerAdditionsResponse> newBrokerAdditions = new ArrayList<BrokerAdditionsResponse>(this.brokerAdditions.size());
        for (BrokerAdditionsResponse _element : this.brokerAdditions) {
            newBrokerAdditions.add(_element.duplicate());
        }
        _duplicate.brokerAdditions = newBrokerAdditions;
        return _duplicate;
    }

    public String toString() {
        return "DescribeBrokerAdditionsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", brokerAdditions=" + MessageUtil.deepToString(this.brokerAdditions.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<BrokerAdditionsResponse> brokerAdditions() {
        return this.brokerAdditions;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeBrokerAdditionsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeBrokerAdditionsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeBrokerAdditionsResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeBrokerAdditionsResponseData setBrokerAdditions(List<BrokerAdditionsResponse> v) {
        this.brokerAdditions = v;
        return this;
    }

    public static class BrokerAdditionsResponse
    implements Message {
        int brokerId;
        long createTimeMs;
        long lastUpdateTimeMs;
        String generalOperationStatus;
        String partitionReassignmentsStatus;
        short additionErrorCode;
        String additionErrorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The Broker ID being added."), new Field("create_time_ms", Type.INT64, "The timestamp at which this operation was created, in milliseconds since the unix epoch"), new Field("last_update_time_ms", Type.INT64, "The timestamp denoting when this operation was last updated, in milliseconds since the unix epoch"), new Field("general_operation_status", Type.STRING, "The high-level status of the balancer operation."), new Field("partition_reassignments_status", Type.STRING, "The low-level, detailed status of the partition reassignments that are part of the broker addition operation."), new Field("addition_error_code", Type.INT16, "The error code for the broker addition operation."), new Field("addition_error_message", Type.NULLABLE_STRING, "The error message for the broker addition, or null if there was no error."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public BrokerAdditionsResponse(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public BrokerAdditionsResponse(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public BrokerAdditionsResponse() {
            this.brokerId = 0;
            this.createTimeMs = 0L;
            this.lastUpdateTimeMs = 0L;
            this.generalOperationStatus = "";
            this.partitionReassignmentsStatus = "";
            this.additionErrorCode = 0;
            this.additionErrorMessage = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerAdditionsResponse");
            }
            this.brokerId = _readable.readInt();
            this.createTimeMs = _readable.readLong();
            this.lastUpdateTimeMs = _readable.readLong();
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field generalOperationStatus was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field generalOperationStatus had invalid length " + length);
            }
            this.generalOperationStatus = _readable.readString(length);
            length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field partitionReassignmentsStatus was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field partitionReassignmentsStatus had invalid length " + length);
            }
            this.partitionReassignmentsStatus = _readable.readString(length);
            this.additionErrorCode = _readable.readShort();
            length = _readable.readShort();
            if (length < 0) {
                this.additionErrorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field additionErrorMessage had invalid length " + length);
                }
                this.additionErrorMessage = _readable.readString(length);
            }
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            _writable.writeLong(this.createTimeMs);
            _writable.writeLong(this.lastUpdateTimeMs);
            byte[] _stringBytes = _cache.getSerializedValue(this.generalOperationStatus);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.partitionReassignmentsStatus);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.additionErrorCode);
            if (this.additionErrorMessage == null) {
                _writable.writeShort((short)-1);
            } else {
                _stringBytes = _cache.getSerializedValue(this.additionErrorMessage);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerAdditionsResponse");
            }
            this._unknownTaggedFields = null;
            this.brokerId = struct.getInt("broker_id");
            this.createTimeMs = struct.getLong("create_time_ms");
            this.lastUpdateTimeMs = struct.getLong("last_update_time_ms");
            this.generalOperationStatus = struct.getString("general_operation_status");
            this.partitionReassignmentsStatus = struct.getString("partition_reassignments_status");
            this.additionErrorCode = struct.getShort("addition_error_code");
            this.additionErrorMessage = struct.getString("addition_error_message");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of BrokerAdditionsResponse");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("broker_id", (Object)this.brokerId);
            struct.set("create_time_ms", (Object)this.createTimeMs);
            struct.set("last_update_time_ms", (Object)this.lastUpdateTimeMs);
            struct.set("general_operation_status", (Object)this.generalOperationStatus);
            struct.set("partition_reassignments_status", (Object)this.partitionReassignmentsStatus);
            struct.set("addition_error_code", (Object)this.additionErrorCode);
            struct.set("addition_error_message", (Object)this.additionErrorMessage);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerAdditionsResponse");
            }
            _size += 4;
            _size += 8;
            _size += 8;
            byte[] _stringBytes = this.generalOperationStatus.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'generalOperationStatus' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.generalOperationStatus, _stringBytes);
            _size += _stringBytes.length + 2;
            _stringBytes = this.partitionReassignmentsStatus.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'partitionReassignmentsStatus' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.partitionReassignmentsStatus, _stringBytes);
            _size += _stringBytes.length + 2;
            _size += 2;
            if (this.additionErrorMessage == null) {
                _size += 2;
            } else {
                _stringBytes = this.additionErrorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'additionErrorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.additionErrorMessage, _stringBytes);
                _size += _stringBytes.length + 2;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerAdditionsResponse)) {
                return false;
            }
            BrokerAdditionsResponse other = (BrokerAdditionsResponse)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.createTimeMs != other.createTimeMs) {
                return false;
            }
            if (this.lastUpdateTimeMs != other.lastUpdateTimeMs) {
                return false;
            }
            if (this.generalOperationStatus == null ? other.generalOperationStatus != null : !this.generalOperationStatus.equals(other.generalOperationStatus)) {
                return false;
            }
            if (this.partitionReassignmentsStatus == null ? other.partitionReassignmentsStatus != null : !this.partitionReassignmentsStatus.equals(other.partitionReassignmentsStatus)) {
                return false;
            }
            if (this.additionErrorCode != other.additionErrorCode) {
                return false;
            }
            if (this.additionErrorMessage == null ? other.additionErrorMessage != null : !this.additionErrorMessage.equals(other.additionErrorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            hashCode = 31 * hashCode + ((int)(this.createTimeMs >> 32) ^ (int)this.createTimeMs);
            hashCode = 31 * hashCode + ((int)(this.lastUpdateTimeMs >> 32) ^ (int)this.lastUpdateTimeMs);
            hashCode = 31 * hashCode + (this.generalOperationStatus == null ? 0 : this.generalOperationStatus.hashCode());
            hashCode = 31 * hashCode + (this.partitionReassignmentsStatus == null ? 0 : this.partitionReassignmentsStatus.hashCode());
            hashCode = 31 * hashCode + this.additionErrorCode;
            hashCode = 31 * hashCode + (this.additionErrorMessage == null ? 0 : this.additionErrorMessage.hashCode());
            return hashCode;
        }

        @Override
        public BrokerAdditionsResponse duplicate() {
            BrokerAdditionsResponse _duplicate = new BrokerAdditionsResponse();
            _duplicate.brokerId = this.brokerId;
            _duplicate.createTimeMs = this.createTimeMs;
            _duplicate.lastUpdateTimeMs = this.lastUpdateTimeMs;
            _duplicate.generalOperationStatus = this.generalOperationStatus;
            _duplicate.partitionReassignmentsStatus = this.partitionReassignmentsStatus;
            _duplicate.additionErrorCode = this.additionErrorCode;
            _duplicate.additionErrorMessage = this.additionErrorMessage == null ? null : this.additionErrorMessage;
            return _duplicate;
        }

        public String toString() {
            return "BrokerAdditionsResponse(brokerId=" + this.brokerId + ", createTimeMs=" + this.createTimeMs + ", lastUpdateTimeMs=" + this.lastUpdateTimeMs + ", generalOperationStatus=" + (this.generalOperationStatus == null ? "null" : "'" + this.generalOperationStatus.toString() + "'") + ", partitionReassignmentsStatus=" + (this.partitionReassignmentsStatus == null ? "null" : "'" + this.partitionReassignmentsStatus.toString() + "'") + ", additionErrorCode=" + this.additionErrorCode + ", additionErrorMessage=" + (this.additionErrorMessage == null ? "null" : "'" + this.additionErrorMessage.toString() + "'") + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public long createTimeMs() {
            return this.createTimeMs;
        }

        public long lastUpdateTimeMs() {
            return this.lastUpdateTimeMs;
        }

        public String generalOperationStatus() {
            return this.generalOperationStatus;
        }

        public String partitionReassignmentsStatus() {
            return this.partitionReassignmentsStatus;
        }

        public short additionErrorCode() {
            return this.additionErrorCode;
        }

        public String additionErrorMessage() {
            return this.additionErrorMessage;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BrokerAdditionsResponse setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public BrokerAdditionsResponse setCreateTimeMs(long v) {
            this.createTimeMs = v;
            return this;
        }

        public BrokerAdditionsResponse setLastUpdateTimeMs(long v) {
            this.lastUpdateTimeMs = v;
            return this;
        }

        public BrokerAdditionsResponse setGeneralOperationStatus(String v) {
            this.generalOperationStatus = v;
            return this;
        }

        public BrokerAdditionsResponse setPartitionReassignmentsStatus(String v) {
            this.partitionReassignmentsStatus = v;
            return this;
        }

        public BrokerAdditionsResponse setAdditionErrorCode(short v) {
            this.additionErrorCode = v;
            return this;
        }

        public BrokerAdditionsResponse setAdditionErrorMessage(String v) {
            this.additionErrorMessage = v;
            return this;
        }
    }
}

