/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeMirrorsRequestData
implements ApiMessage {
    List<String> topics;
    boolean includePartitions;
    int timeoutMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("topics", new CompactArrayOf(Type.COMPACT_STRING), "The name of the topics to include in the response."), new Field("include_partitions", Type.BOOLEAN, "Whether to include partition-level mirror information in the response."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeMirrorsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeMirrorsRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public DescribeMirrorsRequestData() {
        this.topics = new ArrayList<String>(0);
        this.includePartitions = false;
        this.timeoutMs = 0;
    }

    @Override
    public short apiKey() {
        return 10009;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topics element was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topics element had invalid length " + length);
            }
            newCollection.add(_readable.readString(length));
        }
        this.topics = newCollection;
        this.includePartitions = _readable.readByte() != 0;
        this.timeoutMs = _readable.readInt();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        for (String topicsElement : this.topics) {
            byte[] _stringBytes = _cache.getSerializedValue(topicsElement);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeByte(this.includePartitions ? (byte)1 : 0);
        _writable.writeInt(this.timeoutMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<String>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add((String)nestedObject);
        }
        this.includePartitions = struct.getBoolean("include_partitions");
        this.timeoutMs = struct.getInt("timeout_ms");
        if (!_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        _taggedFields = new TreeMap();
        Struct struct = new Struct(SCHEMAS[_version]);
        String[] _nestedObjects = new String[this.topics.size()];
        int i = 0;
        for (String element : this.topics) {
            _nestedObjects[i++] = element;
        }
        struct.set("topics", (Object)_nestedObjects);
        struct.set("include_partitions", (Object)this.includePartitions);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        struct.set("_tagged_fields", _taggedFields);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize += ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1);
        for (String topicsElement : this.topics) {
            byte[] _stringBytes = topicsElement.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicsElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(topicsElement, _stringBytes);
            _arraySize += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
        }
        _size += _arraySize;
        ++_size;
        _size += 4;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        return _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeMirrorsRequestData)) {
            return false;
        }
        DescribeMirrorsRequestData other = (DescribeMirrorsRequestData)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.includePartitions != other.includePartitions) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + (this.includePartitions ? 1231 : 1237);
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    @Override
    public DescribeMirrorsRequestData duplicate() {
        DescribeMirrorsRequestData _duplicate = new DescribeMirrorsRequestData();
        ArrayList<String> newTopics = new ArrayList<String>(this.topics.size());
        for (String _element : this.topics) {
            newTopics.add(_element);
        }
        _duplicate.topics = newTopics;
        _duplicate.includePartitions = this.includePartitions;
        _duplicate.timeoutMs = this.timeoutMs;
        return _duplicate;
    }

    public String toString() {
        return "DescribeMirrorsRequestData(topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", includePartitions=" + (this.includePartitions ? "true" : "false") + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<String> topics() {
        return this.topics;
    }

    public boolean includePartitions() {
        return this.includePartitions;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeMirrorsRequestData setTopics(List<String> v) {
        this.topics = v;
        return this;
    }

    public DescribeMirrorsRequestData setIncludePartitions(boolean v) {
        this.includePartitions = v;
        return this;
    }

    public DescribeMirrorsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }
}

