/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ElectLeadersRequestData
implements ApiMessage {
    byte electionType;
    List<TopicPartitions> topicPartitions;
    int timeoutMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("topic_partitions", ArrayOf.nullable(TopicPartitions.SCHEMA_0), "The topic partitions to elect leaders."), new Field("timeout_ms", Type.INT32, "The time in ms to wait for the election to complete."));
    public static final Schema SCHEMA_1 = new Schema(new Field("election_type", Type.INT8, "Type of elections to conduct for the partition. A value of '0' elects the preferred replica. A value of '1' elects the first live replica if there are no in-sync replica."), new Field("topic_partitions", ArrayOf.nullable(TopicPartitions.SCHEMA_0), "The topic partitions to elect leaders."), new Field("timeout_ms", Type.INT32, "The time in ms to wait for the election to complete."));
    public static final Schema SCHEMA_2 = new Schema(new Field("election_type", Type.INT8, "Type of elections to conduct for the partition. A value of '0' elects the preferred replica. A value of '1' elects the first live replica if there are no in-sync replica."), new Field("topic_partitions", CompactArrayOf.nullable(TopicPartitions.SCHEMA_2), "The topic partitions to elect leaders."), new Field("timeout_ms", Type.INT32, "The time in ms to wait for the election to complete."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public ElectLeadersRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ElectLeadersRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public ElectLeadersRequestData() {
        this.electionType = 0;
        this.topicPartitions = new ArrayList<TopicPartitions>(0);
        this.timeoutMs = 60000;
    }

    @Override
    public short apiKey() {
        return 43;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<TopicPartitions> newCollection;
        int arrayLength;
        this.electionType = _version >= 1 ? _readable.readByte() : (byte)0;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.topicPartitions = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new TopicPartitions(_readable, _version));
                }
                this.topicPartitions = newCollection;
            }
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                this.topicPartitions = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<TopicPartitions>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new TopicPartitions(_readable, _version));
                }
                this.topicPartitions = newCollection;
            }
        }
        this.timeoutMs = _readable.readInt();
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeByte(this.electionType);
        } else if (this.electionType != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default electionType at version " + _version);
        }
        if (_version >= 2) {
            if (this.topicPartitions == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.topicPartitions.size() + 1);
                for (TopicPartitions topicPartitionsElement : this.topicPartitions) {
                    topicPartitionsElement.write(_writable, _cache, _version);
                }
            }
        } else if (this.topicPartitions == null) {
            _writable.writeInt(-1);
        } else {
            _writable.writeInt(this.topicPartitions.size());
            for (TopicPartitions topicPartitionsElement : this.topicPartitions) {
                topicPartitionsElement.write(_writable, _cache, _version);
            }
        }
        _writable.writeInt(this.timeoutMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.electionType = _version >= 1 ? struct.getByte("election_type") : (byte)0;
        Object[] _nestedObjects = struct.getArray("topic_partitions");
        if (_nestedObjects == null) {
            this.topicPartitions = null;
        } else {
            this.topicPartitions = new ArrayList<TopicPartitions>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.topicPartitions.add(new TopicPartitions((Struct)nestedObject, _version));
            }
        }
        this.timeoutMs = struct.getInt("timeout_ms");
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 1) {
            struct.set("election_type", (Object)this.electionType);
        } else if (this.electionType != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default electionType at version " + _version);
        }
        if (this.topicPartitions == null) {
            struct.set("topic_partitions", null);
        } else {
            Struct[] _nestedObjects = new Struct[this.topicPartitions.size()];
            int i = 0;
            for (TopicPartitions element : this.topicPartitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("topic_partitions", (Object)_nestedObjects);
        }
        struct.set("timeout_ms", (Object)this.timeoutMs);
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 1) {
            ++_size;
        }
        if (this.topicPartitions == null) {
            _size = _version >= 2 ? ++_size : (_size += 4);
        } else {
            int _arraySize = 0;
            _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.topicPartitions.size() + 1)) : (_arraySize += 4);
            for (TopicPartitions topicPartitionsElement : this.topicPartitions) {
                _arraySize += topicPartitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        _size += 4;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ElectLeadersRequestData)) {
            return false;
        }
        ElectLeadersRequestData other = (ElectLeadersRequestData)obj;
        if (this.electionType != other.electionType) {
            return false;
        }
        if (this.topicPartitions == null ? other.topicPartitions != null : !this.topicPartitions.equals(other.topicPartitions)) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.electionType;
        hashCode = 31 * hashCode + (this.topicPartitions == null ? 0 : this.topicPartitions.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    @Override
    public ElectLeadersRequestData duplicate() {
        ElectLeadersRequestData _duplicate = new ElectLeadersRequestData();
        _duplicate.electionType = this.electionType;
        if (this.topicPartitions == null) {
            _duplicate.topicPartitions = null;
        } else {
            ArrayList<TopicPartitions> newTopicPartitions = new ArrayList<TopicPartitions>(this.topicPartitions.size());
            for (TopicPartitions _element : this.topicPartitions) {
                newTopicPartitions.add(_element.duplicate());
            }
            _duplicate.topicPartitions = newTopicPartitions;
        }
        _duplicate.timeoutMs = this.timeoutMs;
        return _duplicate;
    }

    public String toString() {
        return "ElectLeadersRequestData(electionType=" + this.electionType + ", topicPartitions=" + (this.topicPartitions == null ? "null" : MessageUtil.deepToString(this.topicPartitions.iterator())) + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public byte electionType() {
        return this.electionType;
    }

    public List<TopicPartitions> topicPartitions() {
        return this.topicPartitions;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ElectLeadersRequestData setElectionType(byte v) {
        this.electionType = v;
        return this;
    }

    public ElectLeadersRequestData setTopicPartitions(List<TopicPartitions> v) {
        this.topicPartitions = v;
        return this;
    }

    public ElectLeadersRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public static class TopicPartitions
    implements Message {
        String topic;
        List<Integer> partitionId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public TopicPartitions(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicPartitions(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public TopicPartitions() {
            this.topic = "";
            this.partitionId = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicPartitions");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _readable.readString(length);
            int arrayLength = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitionId was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitionId = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topic);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.partitionId.size() + 1);
            } else {
                _writable.writeInt(this.partitionId.size());
            }
            _stringBytes = this.partitionId.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionIdElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionIdElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicPartitions");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.topic = struct.getString("topic");
            Object[] _nestedObjects = struct.getArray("partition_id");
            this.partitionId = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitionId.add((Integer)nestedObject);
            }
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TopicPartitions");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("topic", (Object)this.topic);
            Integer[] _nestedObjects = new Integer[this.partitionId.size()];
            int i = 0;
            for (Integer element : this.partitionId) {
                _nestedObjects[i++] = element;
            }
            struct.set("partition_id", (Object)_nestedObjects);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicPartitions");
            }
            byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            int _arraySize = 0;
            _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.partitionId.size() + 1)) : (_arraySize += 4);
            _size += (_arraySize += this.partitionId.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicPartitions)) {
                return false;
            }
            TopicPartitions other = (TopicPartitions)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.partitionId == null ? other.partitionId != null : !this.partitionId.equals(other.partitionId)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.partitionId == null ? 0 : this.partitionId.hashCode());
            return hashCode;
        }

        @Override
        public TopicPartitions duplicate() {
            TopicPartitions _duplicate = new TopicPartitions();
            _duplicate.topic = this.topic;
            ArrayList<Integer> newPartitionId = new ArrayList<Integer>(this.partitionId.size());
            for (Integer _element : this.partitionId) {
                newPartitionId.add(_element);
            }
            _duplicate.partitionId = newPartitionId;
            return _duplicate;
        }

        public String toString() {
            return "TopicPartitions(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitionId=" + MessageUtil.deepToString(this.partitionId.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<Integer> partitionId() {
            return this.partitionId;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicPartitions setTopic(String v) {
            this.topic = v;
            return this;
        }

        public TopicPartitions setPartitionId(List<Integer> v) {
            this.partitionId = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topic", Type.STRING, "The name of a topic."), new Field("partition_id", new ArrayOf(Type.INT32), "The partitions of this topic whose leader should be elected."));
            SCHEMA_2 = new Schema(new Field("topic", Type.COMPACT_STRING, "The name of a topic."), new Field("partition_id", new CompactArrayOf(Type.INT32), "The partitions of this topic whose leader should be elected."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

