/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.DescribeMirrorsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.TopicMirrorDescription;

public class DescribeMirrorsResponse
extends AbstractResponse {
    private final DescribeMirrorsResponseData data;

    public DescribeMirrorsResponse(DescribeMirrorsResponseData data) {
        this.data = data;
    }

    public DescribeMirrorsResponse(Map<String, CompletableFuture<TopicMirrorDescription>> result, int throttleTimeMs) {
        ArrayList<DescribeMirrorsResponseData.TopicData> topicDatas = new ArrayList<DescribeMirrorsResponseData.TopicData>(result.size());
        for (Map.Entry<String, CompletableFuture<TopicMirrorDescription>> entry : result.entrySet()) {
            CompletableFuture<TopicMirrorDescription> future = entry.getValue();
            DescribeMirrorsResponseData.TopicData topicData = new DescribeMirrorsResponseData.TopicData().setTopic(entry.getKey());
            try {
                TopicMirrorDescription desc = future.get();
                topicData.setLinkName(desc.linkName()).setLinkId(desc.linkId().toString()).setMirrorTopic(desc.mirrorTopic()).setState(desc.state().toString()).setStateTimeMs(desc.stateTimeMs());
            }
            catch (Throwable e) {
                Throwable cause = e;
                if (e instanceof ExecutionException) {
                    cause = ((ExecutionException)e).getCause();
                }
                Errors error = Errors.forException(cause);
                topicData.setErrorCode(error.code()).setErrorMessage(cause.getMessage());
            }
            topicDatas.add(topicData);
        }
        this.data = new DescribeMirrorsResponseData().setThrottleTimeMs(throttleTimeMs).setTopics(topicDatas);
    }

    public DescribeMirrorsResponse(Collection<String> topics, int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        ArrayList<DescribeMirrorsResponseData.TopicData> topicDatas = new ArrayList<DescribeMirrorsResponseData.TopicData>(topics.size());
        for (String topic : topics) {
            topicDatas.add(new DescribeMirrorsResponseData.TopicData().setTopic(topic).setErrorCode(error.code()).setErrorMessage(e.getMessage()));
        }
        this.data = new DescribeMirrorsResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()).setErrorMessage(e.getMessage()).setTopics(topicDatas);
    }

    public DescribeMirrorsResponse(Struct struct, short version) {
        this.data = new DescribeMirrorsResponseData(struct, version);
    }

    public void complete(Map<String, KafkaFutureImpl<TopicMirrorDescription>> result) {
        Errors error = Errors.forCode(this.data.errorCode());
        if (error != Errors.NONE) {
            ApiException e = error.exception(this.data.errorMessage());
            for (KafkaFutureImpl<TopicMirrorDescription> future : result.values()) {
                future.completeExceptionally(e);
            }
            return;
        }
        for (DescribeMirrorsResponseData.TopicData topicData : this.data.topics()) {
            KafkaFutureImpl<TopicMirrorDescription> future = result.get(topicData.topic());
            if (future == null) {
                throw new IllegalArgumentException("Result must contain topic with name: " + topicData.topic());
            }
            Errors topicError = Errors.forCode(topicData.errorCode());
            if (topicError == Errors.NONE) {
                future.complete(new TopicMirrorDescription(topicData.linkName(), UUID.fromString(topicData.linkId()), topicData.mirrorTopic(), this.toState(topicData.state()), topicData.stateTimeMs()));
                continue;
            }
            future.completeExceptionally(topicError.exception(this.data.errorMessage()));
        }
    }

    public DescribeMirrorsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.incrementErrorCount(this.data.errorCode(), errorCounts);
        for (DescribeMirrorsResponseData.TopicData topicData : this.data.topics()) {
            this.incrementErrorCount(topicData.errorCode(), errorCounts);
        }
        return errorCounts;
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    private TopicMirrorDescription.State toState(String state) {
        try {
            return TopicMirrorDescription.State.valueOf(state);
        }
        catch (IllegalArgumentException e) {
            return TopicMirrorDescription.State.UNKNOWN;
        }
    }

    private void incrementErrorCount(short errorCode, Map<Errors, Integer> errorCounts) {
        Errors error = Errors.forCode(errorCode);
        errorCounts.put(error, errorCounts.getOrDefault((Object)error, 0) + 1);
    }
}

