/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterMirrorsResponseData;
import org.apache.kafka.common.protocol.MessageUtil;

public class AlterMirrorsResponseDataJsonConverter {
    public static AlterMirrorsResponseData read(JsonNode _node, short _version) {
        AlterMirrorsResponseData _object = new AlterMirrorsResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("AlterMirrorsResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        }
        _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "AlterMirrorsResponseData");
        JsonNode _resultsNode = _node.get("results");
        if (_resultsNode == null) {
            throw new RuntimeException("AlterMirrorsResponseData: unable to locate field 'results', which is mandatory in version " + _version);
        }
        if (!_resultsNode.isArray()) {
            throw new RuntimeException("AlterMirrorsResponseData expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<AlterMirrorsResponseData.AlterMirrorResult> _collection = new ArrayList<AlterMirrorsResponseData.AlterMirrorResult>(_resultsNode.size());
        _object.results = _collection;
        for (JsonNode _element : _resultsNode) {
            _collection.add(AlterMirrorResultJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(AlterMirrorsResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", (JsonNode)new IntNode(_object.throttleTimeMs));
        ArrayNode _resultsArray = new ArrayNode(JsonNodeFactory.instance);
        for (AlterMirrorsResponseData.AlterMirrorResult _element : _object.results) {
            _resultsArray.add(AlterMirrorResultJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("results", (JsonNode)_resultsArray);
        return _node;
    }

    public static JsonNode write(AlterMirrorsResponseData _object, short _version) {
        return AlterMirrorsResponseDataJsonConverter.write(_object, _version, true);
    }

    public static class StopTopicMirrorDataJsonConverter {
        public static AlterMirrorsResponseData.StopTopicMirrorData read(JsonNode _node, short _version) {
            AlterMirrorsResponseData.StopTopicMirrorData _object = new AlterMirrorsResponseData.StopTopicMirrorData();
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of StopTopicMirrorData");
            }
            return _object;
        }

        public static JsonNode write(AlterMirrorsResponseData.StopTopicMirrorData _object, short _version, boolean _serializeRecords) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of StopTopicMirrorData");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            return _node;
        }

        public static JsonNode write(AlterMirrorsResponseData.StopTopicMirrorData _object, short _version) {
            return StopTopicMirrorDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class PauseTopicMirrorDataJsonConverter {
        public static AlterMirrorsResponseData.PauseTopicMirrorData read(JsonNode _node, short _version) {
            AlterMirrorsResponseData.PauseTopicMirrorData _object = new AlterMirrorsResponseData.PauseTopicMirrorData();
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PauseTopicMirrorData");
            }
            return _object;
        }

        public static JsonNode write(AlterMirrorsResponseData.PauseTopicMirrorData _object, short _version, boolean _serializeRecords) {
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of PauseTopicMirrorData");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            return _node;
        }

        public static JsonNode write(AlterMirrorsResponseData.PauseTopicMirrorData _object, short _version) {
            return PauseTopicMirrorDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class ClearTopicMirrorDataJsonConverter {
        public static AlterMirrorsResponseData.ClearTopicMirrorData read(JsonNode _node, short _version) {
            AlterMirrorsResponseData.ClearTopicMirrorData _object = new AlterMirrorsResponseData.ClearTopicMirrorData();
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ClearTopicMirrorData");
            }
            return _object;
        }

        public static JsonNode write(AlterMirrorsResponseData.ClearTopicMirrorData _object, short _version, boolean _serializeRecords) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ClearTopicMirrorData");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            return _node;
        }

        public static JsonNode write(AlterMirrorsResponseData.ClearTopicMirrorData _object, short _version) {
            return ClearTopicMirrorDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class AlterMirrorResultJsonConverter {
        public static AlterMirrorsResponseData.AlterMirrorResult read(JsonNode _node, short _version) {
            AlterMirrorsResponseData.AlterMirrorResult _object = new AlterMirrorsResponseData.AlterMirrorResult();
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("AlterMirrorResult: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "AlterMirrorResult");
            JsonNode _errorMessageNode = _node.get("errorMessage");
            if (_errorMessageNode == null) {
                throw new RuntimeException("AlterMirrorResult: unable to locate field 'errorMessage', which is mandatory in version " + _version);
            }
            if (_errorMessageNode.isNull()) {
                _object.errorMessage = null;
            } else {
                if (!_errorMessageNode.isTextual()) {
                    throw new RuntimeException("AlterMirrorResult expected a string type, but got " + _node.getNodeType());
                }
                _object.errorMessage = _errorMessageNode.asText();
            }
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                if (_version >= 2) {
                    throw new RuntimeException("AlterMirrorResult: unable to locate field 'topic', which is mandatory in version " + _version);
                }
                _object.topic = "";
            } else {
                if (!_topicNode.isTextual()) {
                    throw new RuntimeException("AlterMirrorResult expected a string type, but got " + _node.getNodeType());
                }
                _object.topic = _topicNode.asText();
            }
            JsonNode _stopTopicMirrorNode = _node.get("stopTopicMirror");
            if (_stopTopicMirrorNode == null) {
                if (_version <= 1) {
                    throw new RuntimeException("AlterMirrorResult: unable to locate field 'stopTopicMirror', which is mandatory in version " + _version);
                }
                _object.stopTopicMirror = null;
            } else if (_stopTopicMirrorNode.isNull()) {
                _object.stopTopicMirror = null;
            } else {
                if (!_stopTopicMirrorNode.isArray()) {
                    throw new RuntimeException("AlterMirrorResult expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<AlterMirrorsResponseData.StopTopicMirrorData> _collection = new ArrayList<AlterMirrorsResponseData.StopTopicMirrorData>(_stopTopicMirrorNode.size());
                _object.stopTopicMirror = _collection;
                for (Object _element : _stopTopicMirrorNode) {
                    _collection.add(StopTopicMirrorDataJsonConverter.read((JsonNode)_element, _version));
                }
            }
            JsonNode _clearTopicMirrorNode = _node.get("clearTopicMirror");
            if (_clearTopicMirrorNode == null) {
                if (_version <= 1) {
                    throw new RuntimeException("AlterMirrorResult: unable to locate field 'clearTopicMirror', which is mandatory in version " + _version);
                }
                _object.clearTopicMirror = null;
            } else if (_clearTopicMirrorNode.isNull()) {
                _object.clearTopicMirror = null;
            } else {
                if (!_clearTopicMirrorNode.isArray()) {
                    throw new RuntimeException("AlterMirrorResult expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<AlterMirrorsResponseData.ClearTopicMirrorData> _collection = new ArrayList<AlterMirrorsResponseData.ClearTopicMirrorData>(_clearTopicMirrorNode.size());
                _object.clearTopicMirror = _collection;
                for (JsonNode _element : _clearTopicMirrorNode) {
                    _collection.add(ClearTopicMirrorDataJsonConverter.read(_element, _version));
                }
            }
            JsonNode _pauseTopicMirrorNode = _node.get("pauseTopicMirror");
            if (_pauseTopicMirrorNode == null) {
                if (_version >= 1 && _version <= 1) {
                    throw new RuntimeException("AlterMirrorResult: unable to locate field 'pauseTopicMirror', which is mandatory in version " + _version);
                }
                _object.pauseTopicMirror = null;
            } else if (_pauseTopicMirrorNode.isNull()) {
                _object.pauseTopicMirror = null;
            } else {
                if (!_pauseTopicMirrorNode.isArray()) {
                    throw new RuntimeException("AlterMirrorResult expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<AlterMirrorsResponseData.PauseTopicMirrorData> _collection = new ArrayList<AlterMirrorsResponseData.PauseTopicMirrorData>(_pauseTopicMirrorNode.size());
                _object.pauseTopicMirror = _collection;
                for (JsonNode _element : _pauseTopicMirrorNode) {
                    _collection.add(PauseTopicMirrorDataJsonConverter.read(_element, _version));
                }
            }
            return _object;
        }

        public static JsonNode write(AlterMirrorsResponseData.AlterMirrorResult _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
            if (_object.errorMessage == null) {
                _node.set("errorMessage", (JsonNode)NullNode.instance);
            } else {
                _node.set("errorMessage", (JsonNode)new TextNode(_object.errorMessage));
            }
            if (_version >= 2) {
                _node.set("topic", (JsonNode)new TextNode(_object.topic));
            } else if (!_object.topic.equals("")) {
                throw new UnsupportedVersionException("Attempted to write a non-default topic at version " + _version);
            }
            if (_version <= 1) {
                if (_object.stopTopicMirror == null) {
                    _node.set("stopTopicMirror", (JsonNode)NullNode.instance);
                } else {
                    ArrayNode _stopTopicMirrorArray = new ArrayNode(JsonNodeFactory.instance);
                    for (AlterMirrorsResponseData.StopTopicMirrorData stopTopicMirrorData : _object.stopTopicMirror) {
                        _stopTopicMirrorArray.add(StopTopicMirrorDataJsonConverter.write(stopTopicMirrorData, _version, _serializeRecords));
                    }
                    _node.set("stopTopicMirror", (JsonNode)_stopTopicMirrorArray);
                }
            } else if (_object.stopTopicMirror != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default stopTopicMirror at version " + _version);
            }
            if (_version <= 1) {
                if (_object.clearTopicMirror == null) {
                    _node.set("clearTopicMirror", (JsonNode)NullNode.instance);
                } else {
                    ArrayNode _clearTopicMirrorArray = new ArrayNode(JsonNodeFactory.instance);
                    for (AlterMirrorsResponseData.ClearTopicMirrorData clearTopicMirrorData : _object.clearTopicMirror) {
                        _clearTopicMirrorArray.add(ClearTopicMirrorDataJsonConverter.write(clearTopicMirrorData, _version, _serializeRecords));
                    }
                    _node.set("clearTopicMirror", (JsonNode)_clearTopicMirrorArray);
                }
            } else if (_object.clearTopicMirror != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default clearTopicMirror at version " + _version);
            }
            if (_version >= 1 && _version <= 1) {
                if (_object.pauseTopicMirror == null) {
                    _node.set("pauseTopicMirror", (JsonNode)NullNode.instance);
                } else {
                    ArrayNode _pauseTopicMirrorArray = new ArrayNode(JsonNodeFactory.instance);
                    for (AlterMirrorsResponseData.PauseTopicMirrorData pauseTopicMirrorData : _object.pauseTopicMirror) {
                        _pauseTopicMirrorArray.add(PauseTopicMirrorDataJsonConverter.write(pauseTopicMirrorData, _version, _serializeRecords));
                    }
                    _node.set("pauseTopicMirror", (JsonNode)_pauseTopicMirrorArray);
                }
            } else if (_object.pauseTopicMirror != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default pauseTopicMirror at version " + _version);
            }
            return _node;
        }

        public static JsonNode write(AlterMirrorsResponseData.AlterMirrorResult _object, short _version) {
            return AlterMirrorResultJsonConverter.write(_object, _version, true);
        }
    }
}

