/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.SelectionKey;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.PlaintextTransportLayer;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaintextChannelBuilder
implements ChannelBuilder {
    private static final Logger log = LoggerFactory.getLogger(PlaintextChannelBuilder.class);
    private final ListenerName listenerName;
    private Map<String, ?> configs;
    private final Mode mode;

    public PlaintextChannelBuilder(Mode mode, ListenerName listenerName) {
        this.mode = mode;
        this.listenerName = listenerName;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        this.configs = configs;
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize, MemoryPool memoryPool, ChannelMetadataRegistry metadataRegistry, Time time) throws KafkaException {
        try {
            PlaintextTransportLayer transportLayer = this.buildTransportLayer(key);
            BrokerInterceptor interceptor = ConfluentConfigs.buildBrokerInterceptor(this.mode, this.configs);
            Supplier<Authenticator> authenticatorCreator = () -> new PlaintextAuthenticator(this.configs, transportLayer, this.listenerName);
            return this.buildChannel(id, transportLayer, authenticatorCreator, maxReceiveSize, memoryPool != null ? memoryPool : MemoryPool.NONE, metadataRegistry, interceptor, time);
        }
        catch (Exception e) {
            log.warn("Failed to create channel due to ", (Throwable)e);
            throw new KafkaException(e);
        }
    }

    KafkaChannel buildChannel(String id, TransportLayer transportLayer, Supplier<Authenticator> authenticatorCreator, int maxReceiveSize, MemoryPool memoryPool, ChannelMetadataRegistry metadataRegistry, BrokerInterceptor interceptor, Time time) {
        return new KafkaChannel(id, transportLayer, authenticatorCreator, maxReceiveSize, memoryPool, metadataRegistry, interceptor, time);
    }

    protected PlaintextTransportLayer buildTransportLayer(SelectionKey key) throws IOException {
        return new PlaintextTransportLayer(key);
    }

    @Override
    public void close() {
    }

    private static class PlaintextAuthenticator
    implements Authenticator {
        private final PlaintextTransportLayer transportLayer;
        private final KafkaPrincipalBuilder principalBuilder;
        private final ListenerName listenerName;

        private PlaintextAuthenticator(Map<String, ?> configs, PlaintextTransportLayer transportLayer, ListenerName listenerName) {
            this.transportLayer = transportLayer;
            this.principalBuilder = ChannelBuilders.createPrincipalBuilder(configs, transportLayer, this, null, null);
            this.listenerName = listenerName;
        }

        @Override
        public void authenticate() {
        }

        @Override
        public KafkaPrincipal principal() {
            return this.principalBuilder.build(this.authenticationContext());
        }

        @Override
        public Optional<KafkaPrincipalSerde> principalSerde() {
            return this.principalBuilder instanceof KafkaPrincipalSerde ? Optional.of((KafkaPrincipalSerde)((Object)this.principalBuilder)) : Optional.empty();
        }

        @Override
        public boolean complete() {
            return true;
        }

        @Override
        public AuthenticationContext authenticationContext() {
            InetAddress clientAddress = this.transportLayer.socketChannel().socket().getInetAddress();
            if (this.listenerName == null) {
                throw new IllegalStateException("Unexpected call to principal()/authenticationContext() when listenerName is null");
            }
            return new PlaintextAuthenticationContext(clientAddress, this.listenerName.value());
        }

        @Override
        public void close() {
            if (this.principalBuilder instanceof Closeable) {
                Utils.closeQuietly((Closeable)((Object)this.principalBuilder), "principal builder");
            }
        }
    }
}

