/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class ReverseNode
extends Node {
    public static final int NO_REQUEST_ID = -1;
    private final UUID linkId;
    private final int requestId;
    private final int remoteBrokerId;
    private final ListenerName localListenerName;
    private final KafkaPrincipal localPrincipal;
    private final CompletableFuture<Void> future;

    public ReverseNode(int id, int remoteBrokerId, String remoteHost, int remotePort, UUID linkId, int requestId, ListenerName localListenerName, KafkaPrincipal localPrincipal) {
        super(id, remoteHost, remotePort, null);
        this.remoteBrokerId = remoteBrokerId;
        this.linkId = linkId;
        this.requestId = requestId;
        this.localListenerName = localListenerName;
        this.localPrincipal = localPrincipal;
        this.future = new CompletableFuture();
    }

    public CompletableFuture<Void> future() {
        return this.future;
    }

    public ListenerName localListenerName() {
        return this.localListenerName;
    }

    public KafkaPrincipal localPrincipal() {
        return this.localPrincipal;
    }

    public UUID linkId() {
        return this.linkId;
    }

    public Optional<Integer> requestId() {
        return this.requestId == -1 ? Optional.empty() : Optional.of(this.requestId);
    }

    public int remoteBrokerId() {
        return this.remoteBrokerId;
    }

    @Override
    public String toString() {
        return "ReverseNode(node=" + super.toString() + ", remoteBrokerId=" + this.remoteBrokerId + ", linkId=" + this.linkId + ", requestId=" + this.requestId + ", localListenerName=" + this.localListenerName + ", localPrincipal=" + this.localPrincipal + ")";
    }

    public static interface ConnectionProvider {
        public void initiateConnect(Node var1);
    }

    public static interface ReverseCallback {
        public void onReverseConnection(KafkaChannel var1, ReverseNode var2);
    }
}

