/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractResponse;

public class FetchResponse<T extends BaseRecords>
extends AbstractResponse {
    public static final long INVALID_HIGHWATERMARK = -1L;
    public static final long INVALID_LAST_STABLE_OFFSET = -1L;
    public static final long INVALID_LOG_START_OFFSET = -1L;
    public static final int INVALID_PREFERRED_REPLICA_ID = -1;
    private final FetchResponseData data;
    private final LinkedHashMap<TopicPartition, PartitionData<T>> responseDataMap;

    @Override
    public FetchResponseData data() {
        return this.data;
    }

    public FetchResponse(Errors error, LinkedHashMap<TopicPartition, PartitionData<T>> responseData, int throttleTimeMs, int sessionId) {
        super(ApiKeys.FETCH);
        this.data = FetchResponse.toMessage(throttleTimeMs, error, responseData.entrySet().iterator(), sessionId);
        this.responseDataMap = responseData;
    }

    public FetchResponse(FetchResponseData fetchResponseData) {
        super(ApiKeys.FETCH);
        this.data = fetchResponseData;
        this.responseDataMap = FetchResponse.toResponseDataMap(fetchResponseData);
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    public LinkedHashMap<TopicPartition, PartitionData<T>> responseData() {
        return this.responseDataMap;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public int sessionId() {
        return this.data.sessionId();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.updateErrorCounts(errorCounts, this.error());
        this.responseDataMap.values().forEach(response -> this.updateErrorCounts(errorCounts, response.error()));
        return errorCounts;
    }

    public static FetchResponse<MemoryRecords> parse(ByteBuffer buffer, short version, MessageContext context) {
        return new FetchResponse<MemoryRecords>(new FetchResponseData(new ByteBufferAccessor(buffer), version, context));
    }

    private static <T extends BaseRecords> LinkedHashMap<TopicPartition, PartitionData<T>> toResponseDataMap(FetchResponseData message) {
        LinkedHashMap responseMap = new LinkedHashMap();
        message.responses().forEach(topicResponse -> topicResponse.partitionResponses().forEach(partitionResponse -> {
            TopicPartition tp = new TopicPartition(topicResponse.topic(), partitionResponse.partition());
            PartitionData partitionData = new PartitionData((FetchResponseData.FetchablePartitionResponse)partitionResponse);
            responseMap.put(tp, partitionData);
        }));
        return responseMap;
    }

    private static <T extends BaseRecords> FetchResponseData toMessage(int throttleTimeMs, Errors error, Iterator<Map.Entry<TopicPartition, PartitionData<T>>> partIterator, int sessionId) {
        ArrayList<FetchResponseData.FetchableTopicResponse> topicResponseList = new ArrayList<FetchResponseData.FetchableTopicResponse>();
        partIterator.forEachRemaining(entry -> {
            FetchResponseData.FetchableTopicResponse previousTopic;
            PartitionData partitionData = (PartitionData)entry.getValue();
            partitionData.partitionResponse.setPartition(((TopicPartition)entry.getKey()).partition());
            FetchResponseData.FetchableTopicResponse fetchableTopicResponse = previousTopic = topicResponseList.isEmpty() ? null : (FetchResponseData.FetchableTopicResponse)topicResponseList.get(topicResponseList.size() - 1);
            if (previousTopic != null && previousTopic.topic().equals(((TopicPartition)entry.getKey()).topic())) {
                previousTopic.partitionResponses().add(partitionData.partitionResponse);
            } else {
                ArrayList<FetchResponseData.FetchablePartitionResponse> partitionResponses = new ArrayList<FetchResponseData.FetchablePartitionResponse>();
                partitionResponses.add(partitionData.partitionResponse);
                topicResponseList.add(new FetchResponseData.FetchableTopicResponse().setTopic(((TopicPartition)entry.getKey()).topic()).setPartitionResponses(partitionResponses));
            }
        });
        return new FetchResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()).setSessionId(sessionId).setResponses(topicResponseList);
    }

    public static <T extends BaseRecords> int sizeOf(short version, Iterator<Map.Entry<TopicPartition, PartitionData<T>>> partIterator) {
        FetchResponseData data = FetchResponse.toMessage(0, Errors.NONE, partIterator, 0);
        ObjectSerializationCache cache = new ObjectSerializationCache();
        return 4 + data.size(cache, version);
    }

    public static <T extends BaseRecords> int recordsSize(PartitionData<T> partition) {
        return partition.records() == null ? 0 : partition.records().sizeInBytes();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 8;
    }

    public static final class PartitionData<T extends BaseRecords> {
        private final FetchResponseData.FetchablePartitionResponse partitionResponse;
        private final Optional<Integer> preferredReplica;
        private final List<AbortedTransaction> abortedTransactions;
        private final Errors error;

        private PartitionData(FetchResponseData.FetchablePartitionResponse partitionResponse) {
            this.partitionResponse = partitionResponse;
            this.preferredReplica = Optional.of(partitionResponse.preferredReadReplica()).filter(replicaId -> replicaId != -1);
            this.abortedTransactions = partitionResponse.abortedTransactions() == null ? null : partitionResponse.abortedTransactions().stream().map(AbortedTransaction::fromMessage).collect(Collectors.toList());
            this.error = Errors.forCode(partitionResponse.errorCode());
        }

        public PartitionData(Errors error, long highWatermark, long lastStableOffset, long logStartOffset, Optional<Integer> preferredReadReplica, List<AbortedTransaction> abortedTransactions, Optional<FetchResponseData.EpochEndOffset> divergingEpoch, T records) {
            this.preferredReplica = preferredReadReplica;
            this.abortedTransactions = abortedTransactions;
            this.error = error;
            FetchResponseData.FetchablePartitionResponse partitionResponse = new FetchResponseData.FetchablePartitionResponse();
            partitionResponse.setErrorCode(error.code()).setHighWatermark(highWatermark).setLastStableOffset(lastStableOffset).setLogStartOffset(logStartOffset);
            if (abortedTransactions != null) {
                partitionResponse.setAbortedTransactions(abortedTransactions.stream().map(aborted -> new FetchResponseData.AbortedTransaction().setProducerId(aborted.producerId).setFirstOffset(aborted.firstOffset)).collect(Collectors.toList()));
            } else {
                partitionResponse.setAbortedTransactions(null);
            }
            partitionResponse.setPreferredReadReplica(preferredReadReplica.orElse(-1));
            partitionResponse.setRecordSet((BaseRecords)records);
            divergingEpoch.ifPresent(partitionResponse::setDivergingEpoch);
            this.partitionResponse = partitionResponse;
        }

        public PartitionData(Errors error, long highWatermark, long lastStableOffset, long logStartOffset, Optional<Integer> preferredReadReplica, List<AbortedTransaction> abortedTransactions, T records) {
            this(error, highWatermark, lastStableOffset, logStartOffset, preferredReadReplica, abortedTransactions, Optional.empty(), records);
        }

        public PartitionData(Errors error, long highWatermark, long lastStableOffset, long logStartOffset, List<AbortedTransaction> abortedTransactions, T records) {
            this(error, highWatermark, lastStableOffset, logStartOffset, Optional.empty(), abortedTransactions, records);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionData that = (PartitionData)o;
            return this.partitionResponse.equals(that.partitionResponse);
        }

        public int hashCode() {
            return this.partitionResponse.hashCode();
        }

        public String toString() {
            return "(error=" + (Object)((Object)this.error()) + ", highWaterMark=" + this.highWatermark() + ", lastStableOffset = " + this.lastStableOffset() + ", logStartOffset = " + this.logStartOffset() + ", preferredReadReplica = " + this.preferredReadReplica().map(Object::toString).orElse("absent") + ", abortedTransactions = " + this.abortedTransactions() + ", divergingEpoch =" + this.divergingEpoch() + ", recordsSizeInBytes=" + this.records().sizeInBytes() + ")";
        }

        public Errors error() {
            return this.error;
        }

        public long highWatermark() {
            return this.partitionResponse.highWatermark();
        }

        public long lastStableOffset() {
            return this.partitionResponse.lastStableOffset();
        }

        public long logStartOffset() {
            return this.partitionResponse.logStartOffset();
        }

        public Optional<Integer> preferredReadReplica() {
            return this.preferredReplica;
        }

        public List<AbortedTransaction> abortedTransactions() {
            return this.abortedTransactions;
        }

        public Optional<FetchResponseData.EpochEndOffset> divergingEpoch() {
            FetchResponseData.EpochEndOffset epochEndOffset = this.partitionResponse.divergingEpoch();
            if (epochEndOffset.epoch() < 0) {
                return Optional.empty();
            }
            return Optional.of(epochEndOffset);
        }

        public T records() {
            return (T)this.partitionResponse.recordSet();
        }
    }

    public static final class AbortedTransaction {
        public final long producerId;
        public final long firstOffset;

        public AbortedTransaction(long producerId, long firstOffset) {
            this.producerId = producerId;
            this.firstOffset = firstOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbortedTransaction that = (AbortedTransaction)o;
            return this.producerId == that.producerId && this.firstOffset == that.firstOffset;
        }

        public int hashCode() {
            int result = Long.hashCode(this.producerId);
            result = 31 * result + Long.hashCode(this.firstOffset);
            return result;
        }

        public String toString() {
            return "(producerId=" + this.producerId + ", firstOffset=" + this.firstOffset + ")";
        }

        static AbortedTransaction fromMessage(FetchResponseData.AbortedTransaction abortedTransaction) {
            return new AbortedTransaction(abortedTransaction.producerId(), abortedTransaction.firstOffset());
        }
    }
}

