/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxnOffsetCommitRequest
extends AbstractRequest {
    private static final Logger log = LoggerFactory.getLogger(TxnOffsetCommitRequest.class);
    private final TxnOffsetCommitRequestData data;

    public TxnOffsetCommitRequest(TxnOffsetCommitRequestData data, short version) {
        super(ApiKeys.TXN_OFFSET_COMMIT, version);
        this.data = data;
    }

    public Map<TopicPartition, CommittedOffset> offsets() {
        List<TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic> topics = this.data.topics();
        HashMap<TopicPartition, CommittedOffset> offsetMap = new HashMap<TopicPartition, CommittedOffset>();
        for (TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic topic : topics) {
            for (TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition partition : topic.partitions()) {
                offsetMap.put(new TopicPartition(topic.name(), partition.partitionIndex()), new CommittedOffset(partition.committedOffset(), partition.committedMetadata(), RequestUtils.getLeaderEpoch(partition.committedLeaderEpoch())));
            }
        }
        return offsetMap;
    }

    static List<TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic> getTopics(Map<TopicPartition, CommittedOffset> pendingTxnOffsetCommits) {
        HashMap<String, List> topicPartitionMap = new HashMap<String, List>();
        for (Map.Entry<TopicPartition, CommittedOffset> entry2 : pendingTxnOffsetCommits.entrySet()) {
            TopicPartition topicPartition = entry2.getKey();
            CommittedOffset offset = entry2.getValue();
            List partitions = topicPartitionMap.getOrDefault(topicPartition.topic(), new ArrayList());
            partitions.add(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(topicPartition.partition()).setCommittedOffset(offset.offset).setCommittedLeaderEpoch(offset.leaderEpoch.orElse(-1)).setCommittedMetadata(offset.metadata));
            topicPartitionMap.put(topicPartition.topic(), partitions);
        }
        return topicPartitionMap.entrySet().stream().map(entry -> new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName((String)entry.getKey()).setPartitions((List)entry.getValue())).collect(Collectors.toList());
    }

    @Override
    public TxnOffsetCommitRequestData data() {
        return this.data;
    }

    static List<TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic> getErrorResponseTopics(List<TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic> requestTopics, Errors e) {
        ArrayList<TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic> responseTopicData = new ArrayList<TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic>();
        for (TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic entry : requestTopics) {
            ArrayList<TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition> responsePartitions = new ArrayList<TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition>();
            for (TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition requestPartition : entry.partitions()) {
                responsePartitions.add(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(requestPartition.partitionIndex()).setErrorCode(e.code()));
            }
            responseTopicData.add(new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName(entry.name()).setPartitions(responsePartitions));
        }
        return responseTopicData;
    }

    @Override
    public TxnOffsetCommitResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        List<TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic> responseTopicData = TxnOffsetCommitRequest.getErrorResponseTopics(this.data.topics(), Errors.forException(e));
        return new TxnOffsetCommitResponse(new TxnOffsetCommitResponseData().setThrottleTimeMs(throttleTimeMs).setTopics(responseTopicData));
    }

    public static TxnOffsetCommitRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new TxnOffsetCommitRequest(new TxnOffsetCommitRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class CommittedOffset {
        public final long offset;
        public final String metadata;
        public final Optional<Integer> leaderEpoch;

        public CommittedOffset(long offset, String metadata, Optional<Integer> leaderEpoch) {
            this.offset = offset;
            this.metadata = metadata;
            this.leaderEpoch = leaderEpoch;
        }

        public String toString() {
            return "CommittedOffset(offset=" + this.offset + ", leaderEpoch=" + this.leaderEpoch + ", metadata='" + this.metadata + "')";
        }

        public boolean equals(Object other) {
            if (!(other instanceof CommittedOffset)) {
                return false;
            }
            CommittedOffset otherOffset = (CommittedOffset)other;
            return this.offset == otherOffset.offset && this.leaderEpoch.equals(otherOffset.leaderEpoch) && Objects.equals(this.metadata, otherOffset.metadata);
        }

        public int hashCode() {
            return Objects.hash(this.offset, this.leaderEpoch, this.metadata);
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<TxnOffsetCommitRequest> {
        public final TxnOffsetCommitRequestData data;
        private final boolean autoDowngrade;

        public Builder(String transactionalId, String consumerGroupId, long producerId, short producerEpoch, Map<TopicPartition, CommittedOffset> pendingTxnOffsetCommits, boolean autoDowngrade) {
            this(transactionalId, consumerGroupId, producerId, producerEpoch, pendingTxnOffsetCommits, "", -1, Optional.empty(), autoDowngrade);
        }

        public Builder(String transactionalId, String consumerGroupId, long producerId, short producerEpoch, Map<TopicPartition, CommittedOffset> pendingTxnOffsetCommits, String memberId, int generationId, Optional<String> groupInstanceId, boolean autoDowngrade) {
            super(ApiKeys.TXN_OFFSET_COMMIT);
            this.data = new TxnOffsetCommitRequestData().setTransactionalId(transactionalId).setGroupId(consumerGroupId).setProducerId(producerId).setProducerEpoch(producerEpoch).setTopics(TxnOffsetCommitRequest.getTopics(pendingTxnOffsetCommits)).setMemberId(memberId).setGenerationId(generationId).setGroupInstanceId(groupInstanceId.orElse(null));
            this.autoDowngrade = autoDowngrade;
        }

        @Override
        public TxnOffsetCommitRequest build(short version) {
            if (version < 3 && this.groupMetadataSet()) {
                if (this.autoDowngrade) {
                    log.trace("Downgrade the request by resetting group metadata fields: [member.id:{}, generation.id:{}, group.instance.id:{}], because broker only supports TxnOffsetCommit version {}. Need v3 or newer to enable this feature", new Object[]{this.data.memberId(), this.data.generationId(), this.data.groupInstanceId(), version});
                    this.data.setGenerationId(-1).setMemberId("").setGroupInstanceId(null);
                } else {
                    throw new UnsupportedVersionException("Broker unexpectedly doesn't support group metadata commit API on version " + version);
                }
            }
            return new TxnOffsetCommitRequest(this.data, version);
        }

        private boolean groupMetadataSet() {
            return !this.data.memberId().equals("") || this.data.generationId() != -1 || this.data.groupInstanceId() != null;
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

