/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;

public abstract class AbstractSensorCreator {
    public static final long EXPIRY_SECONDS = TimeUnit.DAYS.toSeconds(7L);
    protected final String name;
    protected final String descriptiveName;

    public AbstractSensorCreator(String name, String descriptiveName) {
        this.name = name;
        this.descriptiveName = descriptiveName;
    }

    public Sensor createSensor(Metrics metrics, String sensorName) {
        return metrics.sensor(sensorName, metrics.config(), EXPIRY_SECONDS, new Sensor[0]);
    }

    public Sensor createSensor(Metrics metrics, String sensorName, long expirySeconds) {
        return metrics.sensor(sensorName, metrics.config(), expirySeconds, new Sensor[0]);
    }

    protected Meter createMeter(Metrics metrics, String groupName, Map<String, String> metricTags, String baseName, String descriptiveName) {
        MetricName rateMetricName = metrics.metricName(baseName + "-rate", groupName, String.format("The number of %s per second", descriptiveName), metricTags);
        MetricName totalMetricName = metrics.metricName(baseName + "-total", groupName, String.format("The total number of %s", descriptiveName), metricTags);
        return new Meter(rateMetricName, totalMetricName);
    }
}

