/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterLeadershipPriorityRequestData;
import org.apache.kafka.common.message.AlterLeadershipPriorityResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterLeadershipPriorityResponse;
import org.apache.kafka.common.requests.ApiError;

public class AlterLeadershipPriorityRequest
extends AbstractRequest {
    private final AlterLeadershipPriorityRequestData data;

    public AlterLeadershipPriorityRequest(AlterLeadershipPriorityRequestData data, short apiVersion) {
        super(ApiKeys.ALTER_LEADERSHIP_PRIORITY, apiVersion);
        this.data = data;
    }

    @Override
    public AlterLeadershipPriorityRequestData data() {
        return this.data;
    }

    @Override
    public AlterLeadershipPriorityResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult> resultList = this.data.brokerIds().stream().map(brokerId -> new AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult().setBrokerId((int)brokerId).setErrorCode(apiError.error().code()).setErrorMessage(apiError.error().message()).setLeadershipPriority(this.data.priorityOperationCode())).collect(Collectors.toList());
        AlterLeadershipPriorityResponseData responseData = new AlterLeadershipPriorityResponseData().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setThrottleTimeMs(throttleTimeMs).setBrokerLeadershipPriorityResults(resultList);
        return new AlterLeadershipPriorityResponse(responseData);
    }

    public static AlterLeadershipPriorityRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AlterLeadershipPriorityRequest(new AlterLeadershipPriorityRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    private boolean hasValidBrokerIds() {
        if (this.data.brokerIds().isEmpty()) {
            return false;
        }
        for (Integer brokerId : this.data.brokerIds()) {
            if (brokerId >= 0) continue;
            return false;
        }
        return true;
    }

    public void validate() throws InvalidRequestException {
        if (!this.hasValidBrokerIds()) {
            throw Errors.INVALID_REQUEST.exception("Invalid brokerIds: " + this.data.brokerIds() + " must be a non-empty list where every brokerId is a non-negative integer.");
        }
        if (!this.hasValidReason()) {
            throw Errors.INVALID_REQUEST.exception("Invalid reason: " + this.data.reason() + ". Valid characters for the reason are the ASCII alphanumerics, '.', '_', and '-'. The string cannot start with the '.' character and must be between 1-32 characters");
        }
        if (!this.hasValidPriorityOperationCode()) {
            throw Errors.INVALID_REQUEST.exception("Invalid priorityOperationCode: " + this.data.priorityOperationCode() + ". Valid values for priorityOperationCode are demoting (0) or promoting (1).");
        }
    }

    private boolean hasValidReason() {
        return this.data.reason().matches("^[a-zA-Z_-][\\.a-zA-Z0-9_-]{0,31}$");
    }

    private boolean hasValidPriorityOperationCode() {
        return this.data.priorityOperationCode() == 0 || this.data.priorityOperationCode() == 1;
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterLeadershipPriorityRequest> {
        private final AlterLeadershipPriorityRequestData data;

        public Builder(AlterLeadershipPriorityRequestData data) {
            super(ApiKeys.ALTER_LEADERSHIP_PRIORITY);
            this.data = data;
        }

        @Override
        public AlterLeadershipPriorityRequest build(short version) {
            return new AlterLeadershipPriorityRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

