/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.http.server;

import io.confluent.kafka.http.server.KafkaHttpServer;
import io.confluent.kafka.http.server.KafkaHttpServerBinder;
import io.confluent.kafka.http.server.KafkaHttpServerInjector;
import io.confluent.kafka.http.server.KafkaHttpServerLoader;
import io.confluent.kafka.http.server.KafkaHttpServerLoadingException;
import io.confluent.kafka.http.server.KafkaHttpServerProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class KafkaHttpServerLoaderTest {
    @Test
    public void testServerImplReturnServer() {
        Optional httpServer = KafkaHttpServerLoader.load(KafkaHttpServerLoaderTest.configuration("test"), (KafkaHttpServerInjector)new KafkaHttpServerBinder().createInjector());
        Assertions.assertTrue((boolean)httpServer.isPresent());
    }

    @Test
    public void testThrowingServerThrowsLoadingException() {
        Assertions.assertThrows(KafkaHttpServerLoadingException.class, () -> KafkaHttpServerLoader.load(KafkaHttpServerLoaderTest.configuration("throwing"), (KafkaHttpServerInjector)new KafkaHttpServerBinder().createInjector()));
    }

    @Test
    public void testNoServerDoesNotReturnServer() {
        Optional httpServer = KafkaHttpServerLoader.load(KafkaHttpServerLoaderTest.configuration(""), (KafkaHttpServerInjector)new KafkaHttpServerBinder().createInjector());
        Assertions.assertFalse((boolean)httpServer.isPresent());
    }

    private static Map<String, Object> configuration(String server) {
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("kafka.http.server", server);
        return configuration;
    }

    public static final class ThrowingKafkaHttpServerProvider
    implements KafkaHttpServerProvider {
        public Optional<KafkaHttpServer> provide(Map<String, Object> configuration, KafkaHttpServerInjector injector) {
            if (configuration.getOrDefault("kafka.http.server", "").equals("throwing")) {
                throw new RuntimeException();
            }
            return Optional.empty();
        }
    }

    public static final class TestKafkaHttpServerProvider
    implements KafkaHttpServerProvider {
        public Optional<KafkaHttpServer> provide(Map<String, Object> configuration, KafkaHttpServerInjector injector) {
            if (configuration.getOrDefault("kafka.http.server", "").equals("test")) {
                return Optional.of(Mockito.mock(KafkaHttpServer.class));
            }
            return Optional.empty();
        }
    }
}

