/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.DeleteConsumerGroupsHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeleteConsumerGroupsHandlerTest {
    private final LogContext logContext = new LogContext();
    private final String groupId1 = "group-id1";

    @Test
    public void testBuildRequest() {
        DeleteConsumerGroupsHandler handler = new DeleteConsumerGroupsHandler(this.logContext);
        DeleteGroupsRequest request = (DeleteGroupsRequest)handler.buildBatchedRequest(1, Collections.singleton(CoordinatorKey.byGroupId((String)"group-id1"))).build();
        Assertions.assertEquals((int)1, (int)request.data().groupsNames().size());
        Assertions.assertEquals((Object)"group-id1", (Object)request.data().groupsNames().get(0));
    }

    @Test
    public void testSuccessfulHandleResponse() {
        this.assertCompleted(this.handleWithError(Errors.NONE));
    }

    @Test
    public void testUnmappedHandleResponse() {
        this.assertUnmapped(this.handleWithError(Errors.NOT_COORDINATOR));
        this.assertUnmapped(this.handleWithError(Errors.COORDINATOR_NOT_AVAILABLE));
    }

    @Test
    public void testRetriableHandleResponse() {
        this.assertRetriable(this.handleWithError(Errors.COORDINATOR_LOAD_IN_PROGRESS));
    }

    @Test
    public void testFailedHandleResponse() {
        this.assertFailed(GroupAuthorizationException.class, this.handleWithError(Errors.GROUP_AUTHORIZATION_FAILED));
        this.assertFailed(GroupIdNotFoundException.class, this.handleWithError(Errors.GROUP_ID_NOT_FOUND));
        this.assertFailed(InvalidGroupIdException.class, this.handleWithError(Errors.INVALID_GROUP_ID));
        this.assertFailed(GroupNotEmptyException.class, this.handleWithError(Errors.NON_EMPTY_GROUP));
    }

    private DeleteGroupsResponse buildResponse(Errors error) {
        DeleteGroupsResponse response = new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(new DeleteGroupsResponseData.DeletableGroupResultCollection(Collections.singletonList(new DeleteGroupsResponseData.DeletableGroupResult().setErrorCode(error.code()).setGroupId("group-id1")).iterator())));
        return response;
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Void> handleWithError(Errors error) {
        DeleteConsumerGroupsHandler handler = new DeleteConsumerGroupsHandler(this.logContext);
        DeleteGroupsResponse response = this.buildResponse(error);
        return handler.handleResponse(new Node(1, "host", 1234), Collections.singleton(CoordinatorKey.byGroupId((String)"group-id1")), (AbstractResponse)response);
    }

    private void assertUnmapped(AdminApiHandler.ApiResult<CoordinatorKey, Void> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.singletonList(CoordinatorKey.byGroupId((String)"group-id1")), (Object)result.unmappedKeys);
    }

    private void assertRetriable(AdminApiHandler.ApiResult<CoordinatorKey, Void> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
    }

    private void assertCompleted(AdminApiHandler.ApiResult<CoordinatorKey, Void> result) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group-id1");
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.completedKeys.keySet());
    }

    private void assertFailed(Class<? extends Throwable> expectedExceptionType, AdminApiHandler.ApiResult<CoordinatorKey, Void> result) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group-id1");
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.failedKeys.keySet());
        Assertions.assertTrue((boolean)expectedExceptionType.isInstance(result.failedKeys.get(key)));
    }
}

