/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Optional;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.consumer.internals.Heartbeat;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HeartbeatTest {
    private int sessionTimeoutMs = 300;
    private int heartbeatIntervalMs = 100;
    private int maxPollIntervalMs = 900;
    private long retryBackoffMs = 10L;
    private MockTime time = new MockTime();
    private Heartbeat heartbeat;

    @BeforeEach
    public void setUp() {
        GroupRebalanceConfig rebalanceConfig = new GroupRebalanceConfig(this.sessionTimeoutMs, this.maxPollIntervalMs, this.heartbeatIntervalMs, "group_id", Optional.empty(), this.retryBackoffMs, true);
        this.heartbeat = new Heartbeat(rebalanceConfig, (Time)this.time);
    }

    @Test
    public void testShouldHeartbeat() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep((long)((double)this.heartbeatIntervalMs * 1.1));
        Assertions.assertTrue((boolean)this.heartbeat.shouldHeartbeat(this.time.milliseconds()));
    }

    @Test
    public void testShouldNotHeartbeat() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(this.heartbeatIntervalMs / 2);
        Assertions.assertFalse((boolean)this.heartbeat.shouldHeartbeat(this.time.milliseconds()));
    }

    @Test
    public void testTimeToNextHeartbeat() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        Assertions.assertEquals((long)this.heartbeatIntervalMs, (long)this.heartbeat.timeToNextHeartbeat(this.time.milliseconds()));
        this.time.sleep(this.heartbeatIntervalMs);
        Assertions.assertEquals((long)0L, (long)this.heartbeat.timeToNextHeartbeat(this.time.milliseconds()));
        this.time.sleep(this.heartbeatIntervalMs);
        Assertions.assertEquals((long)0L, (long)this.heartbeat.timeToNextHeartbeat(this.time.milliseconds()));
    }

    @Test
    public void testSessionTimeoutExpired() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(this.sessionTimeoutMs + 5);
        Assertions.assertTrue((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
    }

    @Test
    public void testResetSession() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(this.sessionTimeoutMs + 5);
        this.heartbeat.resetSessionTimeout();
        Assertions.assertFalse((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
        this.time.sleep(this.maxPollIntervalMs + 1);
        this.heartbeat.resetSessionTimeout();
        Assertions.assertTrue((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
    }

    @Test
    public void testResetTimeouts() {
        this.time.sleep(this.maxPollIntervalMs);
        Assertions.assertTrue((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
        Assertions.assertEquals((long)0L, (long)this.heartbeat.timeToNextHeartbeat(this.time.milliseconds()));
        Assertions.assertTrue((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
        this.heartbeat.resetTimeouts();
        Assertions.assertFalse((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
        Assertions.assertEquals((long)this.heartbeatIntervalMs, (long)this.heartbeat.timeToNextHeartbeat(this.time.milliseconds()));
        Assertions.assertFalse((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
    }

    @Test
    public void testPollTimeout() {
        Assertions.assertFalse((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
        this.time.sleep(this.maxPollIntervalMs / 2);
        Assertions.assertFalse((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
        this.time.sleep(this.maxPollIntervalMs / 2 + 1);
        Assertions.assertTrue((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
    }
}

