/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterMirrorsResponseData
implements ApiMessage {
    int throttleTimeMs;
    List<AlterMirrorResult> results;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", (Type)new CompactArrayOf((Type)AlterMirrorResult.SCHEMA_0), "The results for alter mirror operations."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", (Type)new CompactArrayOf((Type)AlterMirrorResult.SCHEMA_1), "The results for alter mirror operations."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public AlterMirrorsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AlterMirrorsResponseData() {
        this.throttleTimeMs = 0;
        this.results = new ArrayList<AlterMirrorResult>(0);
    }

    public short apiKey() {
        return 10006;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 3;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field results was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<AlterMirrorResult> newCollection = new ArrayList<AlterMirrorResult>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new AlterMirrorResult(_readable, _version, _context));
        }
        this.results = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeUnsignedVarint(this.results.size() + 1);
        for (AlterMirrorResult resultsElement : this.results) {
            resultsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.results.size() + 1)));
        for (AlterMirrorResult resultsElement : this.results) {
            resultsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterMirrorsResponseData)) {
            return false;
        }
        AlterMirrorsResponseData other = (AlterMirrorsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.results == null ? other.results != null : !this.results.equals(other.results)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    public AlterMirrorsResponseData duplicate() {
        AlterMirrorsResponseData _duplicate = new AlterMirrorsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<AlterMirrorResult> newResults = new ArrayList<AlterMirrorResult>(this.results.size());
        for (AlterMirrorResult _element : this.results) {
            newResults.add(_element.duplicate());
        }
        _duplicate.results = newResults;
        return _duplicate;
    }

    public String toString() {
        return "AlterMirrorsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<AlterMirrorResult> results() {
        return this.results;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterMirrorsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public AlterMirrorsResponseData setResults(List<AlterMirrorResult> v) {
        this.results = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", (Type)new CompactArrayOf((Type)AlterMirrorResult.SCHEMA_2), "The results for alter mirror operations."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class PauseMirrorTopicData
    implements Message {
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field[]{Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public PauseMirrorTopicData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public PauseMirrorTopicData() {
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of PauseMirrorTopicData");
            }
            int _numTaggedFields = 0;
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PauseMirrorTopicData)) {
                return false;
            }
            PauseMirrorTopicData other = (PauseMirrorTopicData)obj;
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            return hashCode;
        }

        public PauseMirrorTopicData duplicate() {
            PauseMirrorTopicData _duplicate = new PauseMirrorTopicData();
            return _duplicate;
        }

        public String toString() {
            return "PauseMirrorTopicData()";
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }
    }

    public static class ClearMirrorTopicData
    implements Message {
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public ClearMirrorTopicData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ClearMirrorTopicData() {
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ClearMirrorTopicData");
            }
            int _numTaggedFields = 0;
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClearMirrorTopicData)) {
                return false;
            }
            ClearMirrorTopicData other = (ClearMirrorTopicData)obj;
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            return hashCode;
        }

        public ClearMirrorTopicData duplicate() {
            ClearMirrorTopicData _duplicate = new ClearMirrorTopicData();
            return _duplicate;
        }

        public String toString() {
            return "ClearMirrorTopicData()";
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class StopMirrorTopicData
    implements Message {
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public StopMirrorTopicData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public StopMirrorTopicData() {
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of StopMirrorTopicData");
            }
            int _numTaggedFields = 0;
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StopMirrorTopicData)) {
                return false;
            }
            StopMirrorTopicData other = (StopMirrorTopicData)obj;
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            return hashCode;
        }

        public StopMirrorTopicData duplicate() {
            StopMirrorTopicData _duplicate = new StopMirrorTopicData();
            return _duplicate;
        }

        public String toString() {
            return "StopMirrorTopicData()";
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class AlterMirrorResult
    implements Message {
        short errorCode;
        String errorMessage;
        String topic;
        List<StopMirrorTopicData> stopMirrorTopic;
        List<ClearMirrorTopicData> clearMirrorTopic;
        List<PauseMirrorTopicData> pauseMirrorTopic;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The error code, or `0` if alter operation succeeded."), new Field("error_message", (Type)Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if alter operation succeeded."), new Field("stop_mirror_topic", (Type)CompactArrayOf.nullable((Type)StopMirrorTopicData.SCHEMA_0), "Stops a topic's mirroring to become a writable topic."), new Field("clear_mirror_topic", (Type)CompactArrayOf.nullable((Type)ClearMirrorTopicData.SCHEMA_0), "Clears a topic's mirror information."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The error code, or `0` if alter operation succeeded."), new Field("error_message", (Type)Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if alter operation succeeded."), new Field("stop_mirror_topic", (Type)CompactArrayOf.nullable((Type)StopMirrorTopicData.SCHEMA_0), "Stops a topic's mirroring to become a writable topic."), new Field("clear_mirror_topic", (Type)CompactArrayOf.nullable((Type)ClearMirrorTopicData.SCHEMA_0), "Clears a topic's mirror information."), new Field("pause_mirror_topic", (Type)CompactArrayOf.nullable((Type)PauseMirrorTopicData.SCHEMA_1), "Pauses a mirror topic's replication."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public AlterMirrorResult(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public AlterMirrorResult() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.topic = "";
            this.stopMirrorTopic = null;
            this.clearMirrorTopic = null;
            this.pauseMirrorTopic = null;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ArrayList<StopMirrorTopicData> newCollection;
            int arrayLength;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterMirrorResult");
            }
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            if (_version >= 2) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field topic was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field topic had invalid length " + length);
                }
                this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            } else {
                this.topic = "";
            }
            if (_version <= 1) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.stopMirrorTopic = null;
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    newCollection = new ArrayList<StopMirrorTopicData>(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new StopMirrorTopicData(_readable, _version, _context));
                    }
                    this.stopMirrorTopic = newCollection;
                }
            } else {
                this.stopMirrorTopic = null;
            }
            if (_version <= 1) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.clearMirrorTopic = null;
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add((StopMirrorTopicData)((Object)new ClearMirrorTopicData(_readable, _version, _context)));
                    }
                    this.clearMirrorTopic = newCollection;
                }
            } else {
                this.clearMirrorTopic = null;
            }
            if (_version >= 1 && _version <= 1) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.pauseMirrorTopic = null;
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add((StopMirrorTopicData)((Object)new PauseMirrorTopicData(_readable, _version, _context)));
                    }
                    this.pauseMirrorTopic = newCollection;
                }
            } else {
                this.pauseMirrorTopic = null;
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue((Object)this.errorMessage);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            if (_version >= 2) {
                _stringBytes = _cache.getSerializedValue((Object)this.topic);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            } else if (!this.topic.equals("")) {
                throw new UnsupportedVersionException("Attempted to write a non-default topic at version " + _version);
            }
            if (_version <= 1) {
                if (this.stopMirrorTopic == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.stopMirrorTopic.size() + 1);
                    _stringBytes = this.stopMirrorTopic.iterator();
                    while (_stringBytes.hasNext()) {
                        StopMirrorTopicData stopMirrorTopicElement = (StopMirrorTopicData)_stringBytes.next();
                        stopMirrorTopicElement.write(_writable, _cache, _version, _context);
                    }
                }
            } else if (this.stopMirrorTopic != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default stopMirrorTopic at version " + _version);
            }
            if (_version <= 1) {
                if (this.clearMirrorTopic == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.clearMirrorTopic.size() + 1);
                    for (ClearMirrorTopicData clearMirrorTopicElement : this.clearMirrorTopic) {
                        clearMirrorTopicElement.write(_writable, _cache, _version, _context);
                    }
                }
            } else if (this.clearMirrorTopic != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default clearMirrorTopic at version " + _version);
            }
            if (_version >= 1 && _version <= 1) {
                if (this.pauseMirrorTopic == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.pauseMirrorTopic.size() + 1);
                    for (PauseMirrorTopicData pauseMirrorTopicElement : this.pauseMirrorTopic) {
                        pauseMirrorTopicElement.write(_writable, _cache, _version, _context);
                    }
                }
            } else if (this.pauseMirrorTopic != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default pauseMirrorTopic at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AlterMirrorResult");
            }
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            }
            if (_version >= 2) {
                _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'topic' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.topic, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            }
            if (_version <= 1) {
                if (this.stopMirrorTopic == null) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.stopMirrorTopic.size() + 1)));
                    for (StopMirrorTopicData stopMirrorTopicElement : this.stopMirrorTopic) {
                        stopMirrorTopicElement.addSize(_size, _cache, _version, _context);
                    }
                }
            }
            if (_version <= 1) {
                if (this.clearMirrorTopic == null) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.clearMirrorTopic.size() + 1)));
                    for (ClearMirrorTopicData clearMirrorTopicElement : this.clearMirrorTopic) {
                        clearMirrorTopicElement.addSize(_size, _cache, _version, _context);
                    }
                }
            }
            if (_version >= 1 && _version <= 1) {
                if (this.pauseMirrorTopic == null) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.pauseMirrorTopic.size() + 1)));
                    for (PauseMirrorTopicData pauseMirrorTopicElement : this.pauseMirrorTopic) {
                        pauseMirrorTopicElement.addSize(_size, _cache, _version, _context);
                    }
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterMirrorResult)) {
                return false;
            }
            AlterMirrorResult other = (AlterMirrorResult)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.stopMirrorTopic == null ? other.stopMirrorTopic != null : !this.stopMirrorTopic.equals(other.stopMirrorTopic)) {
                return false;
            }
            if (this.clearMirrorTopic == null ? other.clearMirrorTopic != null : !this.clearMirrorTopic.equals(other.clearMirrorTopic)) {
                return false;
            }
            if (this.pauseMirrorTopic == null ? other.pauseMirrorTopic != null : !this.pauseMirrorTopic.equals(other.pauseMirrorTopic)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.stopMirrorTopic == null ? 0 : this.stopMirrorTopic.hashCode());
            hashCode = 31 * hashCode + (this.clearMirrorTopic == null ? 0 : this.clearMirrorTopic.hashCode());
            hashCode = 31 * hashCode + (this.pauseMirrorTopic == null ? 0 : this.pauseMirrorTopic.hashCode());
            return hashCode;
        }

        public AlterMirrorResult duplicate() {
            AlterMirrorResult _duplicate = new AlterMirrorResult();
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.topic = this.topic;
            if (this.stopMirrorTopic == null) {
                _duplicate.stopMirrorTopic = null;
            } else {
                ArrayList<StopMirrorTopicData> newStopMirrorTopic = new ArrayList<StopMirrorTopicData>(this.stopMirrorTopic.size());
                for (StopMirrorTopicData stopMirrorTopicData : this.stopMirrorTopic) {
                    newStopMirrorTopic.add(stopMirrorTopicData.duplicate());
                }
                _duplicate.stopMirrorTopic = newStopMirrorTopic;
            }
            if (this.clearMirrorTopic == null) {
                _duplicate.clearMirrorTopic = null;
            } else {
                ArrayList<ClearMirrorTopicData> newClearMirrorTopic = new ArrayList<ClearMirrorTopicData>(this.clearMirrorTopic.size());
                for (ClearMirrorTopicData clearMirrorTopicData : this.clearMirrorTopic) {
                    newClearMirrorTopic.add(clearMirrorTopicData.duplicate());
                }
                _duplicate.clearMirrorTopic = newClearMirrorTopic;
            }
            if (this.pauseMirrorTopic == null) {
                _duplicate.pauseMirrorTopic = null;
            } else {
                ArrayList<PauseMirrorTopicData> newPauseMirrorTopic = new ArrayList<PauseMirrorTopicData>(this.pauseMirrorTopic.size());
                for (PauseMirrorTopicData pauseMirrorTopicData : this.pauseMirrorTopic) {
                    newPauseMirrorTopic.add(pauseMirrorTopicData.duplicate());
                }
                _duplicate.pauseMirrorTopic = newPauseMirrorTopic;
            }
            return _duplicate;
        }

        public String toString() {
            return "AlterMirrorResult(errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", stopMirrorTopic=" + (this.stopMirrorTopic == null ? "null" : MessageUtil.deepToString(this.stopMirrorTopic.iterator())) + ", clearMirrorTopic=" + (this.clearMirrorTopic == null ? "null" : MessageUtil.deepToString(this.clearMirrorTopic.iterator())) + ", pauseMirrorTopic=" + (this.pauseMirrorTopic == null ? "null" : MessageUtil.deepToString(this.pauseMirrorTopic.iterator())) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public String topic() {
            return this.topic;
        }

        public List<StopMirrorTopicData> stopMirrorTopic() {
            return this.stopMirrorTopic;
        }

        public List<ClearMirrorTopicData> clearMirrorTopic() {
            return this.clearMirrorTopic;
        }

        public List<PauseMirrorTopicData> pauseMirrorTopic() {
            return this.pauseMirrorTopic;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AlterMirrorResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public AlterMirrorResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public AlterMirrorResult setTopic(String v) {
            this.topic = v;
            return this;
        }

        public AlterMirrorResult setStopMirrorTopic(List<StopMirrorTopicData> v) {
            this.stopMirrorTopic = v;
            return this;
        }

        public AlterMirrorResult setClearMirrorTopic(List<ClearMirrorTopicData> v) {
            this.clearMirrorTopic = v;
            return this;
        }

        public AlterMirrorResult setPauseMirrorTopic(List<PauseMirrorTopicData> v) {
            this.pauseMirrorTopic = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The error code, or `0` if alter operation succeeded."), new Field("error_message", (Type)Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if alter operation succeeded."), new Field("topic", (Type)Type.COMPACT_STRING, "The mirror topic's name."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

