/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class DescribeClusterResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    String clusterId;
    int controllerId;
    DescribeClusterBrokerCollection brokers;
    int clusterAuthorizedOperations;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The top-level error code, or 0 if there was no error"), new Field("error_message", (Type)Type.COMPACT_NULLABLE_STRING, "The top-level error message, or null if there was no error."), new Field("cluster_id", (Type)Type.COMPACT_STRING, "The cluster ID that responding broker belongs to."), new Field("controller_id", (Type)Type.INT32, "The ID of the controller broker."), new Field("brokers", (Type)new CompactArrayOf((Type)DescribeClusterBroker.SCHEMA_0), "Each broker in the response."), new Field("cluster_authorized_operations", (Type)Type.INT32, "32-bit bitfield to represent authorized operations for this cluster."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeClusterResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeClusterResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = null;
        this.clusterId = "";
        this.controllerId = -1;
        this.brokers = new DescribeClusterBrokerCollection(0);
        this.clusterAuthorizedOperations = Integer.MIN_VALUE;
    }

    public short apiKey() {
        return 60;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString(length);
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field clusterId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field clusterId had invalid length " + length);
        }
        this.clusterId = _context.read(EntityType.CLUSTER_ID, _readable.readString(length));
        this.controllerId = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field brokers was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        DescribeClusterBrokerCollection newCollection = new DescribeClusterBrokerCollection(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new DescribeClusterBroker(_readable, _version, _context));
        }
        this.brokers = newCollection;
        this.clusterAuthorizedOperations = _readable.readInt();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue((Object)this.errorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _stringBytes = _cache.getSerializedValue((Object)this.clusterId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeInt(this.controllerId);
        _writable.writeUnsignedVarint(this.brokers.size() + 1);
        _stringBytes = this.brokers.iterator();
        while (_stringBytes.hasNext()) {
            DescribeClusterBroker brokersElement = (DescribeClusterBroker)_stringBytes.next();
            brokersElement.write(_writable, _cache, _version, _context);
        }
        _writable.writeInt(this.clusterAuthorizedOperations);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        }
        _stringBytes = _context.write(EntityType.CLUSTER_ID, this.clusterId).getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'clusterId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.clusterId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.brokers.size() + 1)));
        Iterator<RawTaggedField> iterator = this.brokers.iterator();
        while (iterator.hasNext()) {
            DescribeClusterBroker brokersElement = (DescribeClusterBroker)iterator.next();
            brokersElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeClusterResponseData)) {
            return false;
        }
        DescribeClusterResponseData other = (DescribeClusterResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.controllerId != other.controllerId) {
            return false;
        }
        if (this.brokers == null ? other.brokers != null : !this.brokers.equals((Object)other.brokers)) {
            return false;
        }
        if (this.clusterAuthorizedOperations != other.clusterAuthorizedOperations) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        hashCode = 31 * hashCode + this.controllerId;
        hashCode = 31 * hashCode + (this.brokers == null ? 0 : this.brokers.hashCode());
        hashCode = 31 * hashCode + this.clusterAuthorizedOperations;
        return hashCode;
    }

    public DescribeClusterResponseData duplicate() {
        DescribeClusterResponseData _duplicate = new DescribeClusterResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        _duplicate.clusterId = this.clusterId;
        _duplicate.controllerId = this.controllerId;
        DescribeClusterBrokerCollection newBrokers = new DescribeClusterBrokerCollection(this.brokers.size());
        Iterator iterator = this.brokers.iterator();
        while (iterator.hasNext()) {
            DescribeClusterBroker _element = (DescribeClusterBroker)iterator.next();
            newBrokers.add(_element.duplicate());
        }
        _duplicate.brokers = newBrokers;
        _duplicate.clusterAuthorizedOperations = this.clusterAuthorizedOperations;
        return _duplicate;
    }

    public String toString() {
        return "DescribeClusterResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", clusterId=" + (this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", controllerId=" + this.controllerId + ", brokers=" + MessageUtil.deepToString((Iterator)this.brokers.iterator()) + ", clusterAuthorizedOperations=" + this.clusterAuthorizedOperations + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public DescribeClusterBrokerCollection brokers() {
        return this.brokers;
    }

    public int clusterAuthorizedOperations() {
        return this.clusterAuthorizedOperations;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeClusterResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeClusterResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeClusterResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeClusterResponseData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public DescribeClusterResponseData setControllerId(int v) {
        this.controllerId = v;
        return this;
    }

    public DescribeClusterResponseData setBrokers(DescribeClusterBrokerCollection v) {
        this.brokers = v;
        return this;
    }

    public DescribeClusterResponseData setClusterAuthorizedOperations(int v) {
        this.clusterAuthorizedOperations = v;
        return this;
    }

    public static class DescribeClusterBrokerCollection
    extends ImplicitLinkedHashMultiCollection<DescribeClusterBroker> {
        public DescribeClusterBrokerCollection() {
        }

        public DescribeClusterBrokerCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public DescribeClusterBrokerCollection(Iterator<DescribeClusterBroker> iterator) {
            super(iterator);
        }

        public DescribeClusterBroker find(int brokerId) {
            DescribeClusterBroker _key = new DescribeClusterBroker();
            _key.setBrokerId(brokerId);
            return (DescribeClusterBroker)this.find(_key);
        }

        public List<DescribeClusterBroker> findAll(int brokerId) {
            DescribeClusterBroker _key = new DescribeClusterBroker();
            _key.setBrokerId(brokerId);
            return this.findAll(_key);
        }

        public DescribeClusterBrokerCollection duplicate() {
            DescribeClusterBrokerCollection _duplicate = new DescribeClusterBrokerCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                DescribeClusterBroker _element = (DescribeClusterBroker)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class TagKeyValueCollection
    extends ImplicitLinkedHashMultiCollection<TagKeyValue> {
        public TagKeyValueCollection() {
        }

        public TagKeyValueCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public TagKeyValueCollection(Iterator<TagKeyValue> iterator) {
            super(iterator);
        }

        public TagKeyValue find(String name) {
            TagKeyValue _key = new TagKeyValue();
            _key.setName(name);
            return (TagKeyValue)this.find(_key);
        }

        public List<TagKeyValue> findAll(String name) {
            TagKeyValue _key = new TagKeyValue();
            _key.setName(name);
            return this.findAll(_key);
        }

        public TagKeyValueCollection duplicate() {
            TagKeyValueCollection _duplicate = new TagKeyValueCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TagKeyValue _element = (TagKeyValue)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class TagKeyValue
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        String value;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The name of the tag."), new Field("value", (Type)Type.COMPACT_STRING, "The value of the tag."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TagKeyValue(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public TagKeyValue() {
            this.name = "";
            this.value = "";
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TagKeyValue");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field value was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field value had invalid length " + length);
            }
            this.value = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue((Object)this.value);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TagKeyValue");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'value' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.value, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof TagKeyValue)) {
                return false;
            }
            TagKeyValue other = (TagKeyValue)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TagKeyValue)) {
                return false;
            }
            TagKeyValue other = (TagKeyValue)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public TagKeyValue duplicate() {
            TagKeyValue _duplicate = new TagKeyValue();
            _duplicate.name = this.name;
            _duplicate.value = this.value;
            return _duplicate;
        }

        public String toString() {
            return "TagKeyValue(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", value=" + (this.value == null ? "null" : "'" + this.value.toString() + "'") + ")";
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TagKeyValue setName(String v) {
            this.name = v;
            return this;
        }

        public TagKeyValue setValue(String v) {
            this.value = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class DescribeClusterBroker
    implements Message,
    ImplicitLinkedHashCollection.Element {
        int brokerId;
        String host;
        int port;
        String rack;
        TagKeyValueCollection tags;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The broker ID."), new Field("host", (Type)Type.COMPACT_STRING, "The broker hostname."), new Field("port", (Type)Type.INT32, "The broker port."), new Field("rack", (Type)Type.COMPACT_NULLABLE_STRING, "The rack of the broker, or null if it has not been assigned to a rack."), Field.TaggedFieldsSection.of((Object[])new Object[]{10000, new Field("tags", (Type)new CompactArrayOf((Type)TagKeyValue.SCHEMA_0), "")})});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public DescribeClusterBroker(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public DescribeClusterBroker() {
            this.brokerId = 0;
            this.host = "";
            this.port = 0;
            this.rack = null;
            this.tags = new TagKeyValueCollection(0);
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeClusterBroker");
            }
            this.brokerId = _readable.readInt();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readInt();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.rack = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field rack had invalid length " + length);
                }
                this.rack = _readable.readString(length);
            }
            this.tags = new TagKeyValueCollection(0);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            block3: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 10000: {
                        int arrayLength = _readable.readUnsignedVarint() - 1;
                        if (arrayLength < 0) {
                            throw new RuntimeException("non-nullable field tags was serialized as null");
                        }
                        if (arrayLength > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        TagKeyValueCollection newCollection = new TagKeyValueCollection(arrayLength);
                        for (int i = 0; i < arrayLength; ++i) {
                            newCollection.add(new TagKeyValue(_readable, _version, _context));
                        }
                        this.tags = newCollection;
                        continue block3;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.port);
            if (this.rack == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue((Object)this.rack);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            if (!this.tags.isEmpty()) {
                ++_numTaggedFields;
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, 10000);
            if (!this.tags.isEmpty()) {
                _writable.writeUnsignedVarint(10000);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes((Object)this.tags).intValue());
                _writable.writeUnsignedVarint(this.tags.size() + 1);
                Iterator iterator = this.tags.iterator();
                while (iterator.hasNext()) {
                    TagKeyValue tagsElement = (TagKeyValue)iterator.next();
                    tagsElement.write(_writable, _cache, _version, _context);
                }
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeClusterBroker");
            }
            _size.addBytes(4);
            byte[] _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(4);
            if (this.rack == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = this.rack.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'rack' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.rack, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            }
            if (!this.tags.isEmpty()) {
                ++_numTaggedFields;
                _size.addBytes(2);
                int _sizeBeforeArray = _size.totalSize();
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.tags.size() + 1)));
                Iterator iterator = this.tags.iterator();
                while (iterator.hasNext()) {
                    TagKeyValue tagsElement = (TagKeyValue)iterator.next();
                    tagsElement.addSize(_size, _cache, _version, _context);
                }
                int _arraySize = _size.totalSize() - _sizeBeforeArray;
                _cache.setArraySizeInBytes((Object)this.tags, Integer.valueOf(_arraySize));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof DescribeClusterBroker)) {
                return false;
            }
            DescribeClusterBroker other = (DescribeClusterBroker)obj;
            return this.brokerId == other.brokerId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeClusterBroker)) {
                return false;
            }
            DescribeClusterBroker other = (DescribeClusterBroker)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            if (this.rack == null ? other.rack != null : !this.rack.equals(other.rack)) {
                return false;
            }
            if (this.tags == null ? other.tags != null : !this.tags.equals((Object)other.tags)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            return hashCode;
        }

        public DescribeClusterBroker duplicate() {
            DescribeClusterBroker _duplicate = new DescribeClusterBroker();
            _duplicate.brokerId = this.brokerId;
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            _duplicate.rack = this.rack == null ? null : this.rack;
            TagKeyValueCollection newTags = new TagKeyValueCollection(this.tags.size());
            Iterator iterator = this.tags.iterator();
            while (iterator.hasNext()) {
                TagKeyValue _element = (TagKeyValue)iterator.next();
                newTags.add(_element.duplicate());
            }
            _duplicate.tags = newTags;
            return _duplicate;
        }

        public String toString() {
            return "DescribeClusterBroker(brokerId=" + this.brokerId + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ", rack=" + (this.rack == null ? "null" : "'" + this.rack.toString() + "'") + ", tags=" + MessageUtil.deepToString((Iterator)this.tags.iterator()) + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public String rack() {
            return this.rack;
        }

        public TagKeyValueCollection tags() {
            return this.tags;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeClusterBroker setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public DescribeClusterBroker setHost(String v) {
            this.host = v;
            return this;
        }

        public DescribeClusterBroker setPort(int v) {
            this.port = v;
            return this;
        }

        public DescribeClusterBroker setRack(String v) {
            this.rack = v;
            return this;
        }

        public DescribeClusterBroker setTags(TagKeyValueCollection v) {
            this.tags = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }
    }
}

