/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ListOffsetsResponseData
implements ApiMessage {
    int throttleTimeMs;
    List<ListOffsetsTopicResponse> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)ListOffsetsTopicResponse.SCHEMA_0), "Each topic in the response.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)ListOffsetsTopicResponse.SCHEMA_1), "Each topic in the response.")});
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 7;

    public ListOffsetsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ListOffsetsResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new ArrayList<ListOffsetsTopicResponse>(0);
    }

    public short apiKey() {
        return 2;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 7;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        ArrayList<ListOffsetsTopicResponse> newCollection;
        int arrayLength;
        this.throttleTimeMs = _version >= 2 ? _readable.readInt() : 0;
        if (_version >= 6) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new ListOffsetsTopicResponse(_readable, _version, _context));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<ListOffsetsTopicResponse>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new ListOffsetsTopicResponse(_readable, _version, _context));
            }
            this.topics = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 6) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeInt(this.throttleTimeMs);
        }
        if (_version >= 6) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            for (ListOffsetsTopicResponse topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.topics.size());
            for (ListOffsetsTopicResponse topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version, _context);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 6) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _size.addBytes(4);
        }
        if (_version >= 6) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.topics.size() + 1)));
        } else {
            _size.addBytes(4);
        }
        for (ListOffsetsTopicResponse topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 6) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListOffsetsResponseData)) {
            return false;
        }
        ListOffsetsResponseData other = (ListOffsetsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public ListOffsetsResponseData duplicate() {
        ListOffsetsResponseData _duplicate = new ListOffsetsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<ListOffsetsTopicResponse> newTopics = new ArrayList<ListOffsetsTopicResponse>(this.topics.size());
        for (ListOffsetsTopicResponse _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "ListOffsetsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<ListOffsetsTopicResponse> topics() {
        return this.topics;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ListOffsetsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ListOffsetsResponseData setTopics(List<ListOffsetsTopicResponse> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", (Type)new ArrayOf((Type)ListOffsetsTopicResponse.SCHEMA_1), "Each topic in the response.")});
        SCHEMA_5 = SCHEMA_4 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", (Type)new ArrayOf((Type)ListOffsetsTopicResponse.SCHEMA_4), "Each topic in the response.")});
        SCHEMA_7 = SCHEMA_6 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", (Type)new CompactArrayOf((Type)ListOffsetsTopicResponse.SCHEMA_6), "Each topic in the response."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
    }

    public static class ListOffsetsPartitionResponse
    implements Message {
        int partitionIndex;
        short errorCode;
        List<Long> oldStyleOffsets;
        long timestamp;
        long offset;
        int leaderEpoch;
        Uuid followerRestorePointObjectId;
        int followerRestorePointEpoch;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The partition error code, or 0 if there was no error."), new Field("old_style_offsets", (Type)new ArrayOf((Type)Type.INT64), "The result offsets.")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 7;

        public ListOffsetsPartitionResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ListOffsetsPartitionResponse() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.oldStyleOffsets = new ArrayList<Long>(0);
            this.timestamp = -1L;
            this.offset = -1L;
            this.leaderEpoch = -1;
            this.followerRestorePointObjectId = Uuid.ZERO_UUID;
            this.followerRestorePointEpoch = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 7;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetsPartitionResponse");
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            if (_version <= 0) {
                int arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field oldStyleOffsets was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<Long> newCollection = new ArrayList<Long>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readLong());
                }
                this.oldStyleOffsets = newCollection;
            } else {
                this.oldStyleOffsets = new ArrayList<Long>(0);
            }
            this.timestamp = _version >= 1 ? _readable.readLong() : -1L;
            this.offset = _version >= 1 ? _readable.readLong() : -1L;
            this.leaderEpoch = _version >= 4 ? _readable.readInt() : -1;
            this.followerRestorePointObjectId = Uuid.ZERO_UUID;
            this.followerRestorePointEpoch = 0;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                block5: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        case 0: {
                            this.followerRestorePointObjectId = _readable.readUuid();
                            continue block5;
                        }
                        case 1: {
                            this.followerRestorePointEpoch = _readable.readInt();
                            continue block5;
                        }
                        default: {
                            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        }
                    }
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            if (_version <= 0) {
                _writable.writeInt(this.oldStyleOffsets.size());
                for (Long oldStyleOffsetsElement : this.oldStyleOffsets) {
                    _writable.writeLong(oldStyleOffsetsElement.longValue());
                }
            } else if (!this.oldStyleOffsets.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default oldStyleOffsets at version " + _version);
            }
            if (_version >= 1) {
                _writable.writeLong(this.timestamp);
            } else if (this.timestamp != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default timestamp at version " + _version);
            }
            if (_version >= 1) {
                _writable.writeLong(this.offset);
            } else if (this.offset != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default offset at version " + _version);
            }
            if (_version >= 4) {
                _writable.writeInt(this.leaderEpoch);
            } else if (this.leaderEpoch != -1) {
                throw new UnsupportedVersionException("Attempted to write a non-default leaderEpoch at version " + _version);
            }
            if (_version >= 6 && !this.followerRestorePointObjectId.equals((Object)Uuid.ZERO_UUID)) {
                ++_numTaggedFields;
            }
            if (_version >= 6 && this.followerRestorePointEpoch != 0) {
                ++_numTaggedFields;
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                if (!this.followerRestorePointObjectId.equals((Object)Uuid.ZERO_UUID)) {
                    _writable.writeUnsignedVarint(0);
                    _writable.writeUnsignedVarint(16);
                    _writable.writeUuid(this.followerRestorePointObjectId);
                }
                if (this.followerRestorePointEpoch != 0) {
                    _writable.writeUnsignedVarint(1);
                    _writable.writeUnsignedVarint(4);
                    _writable.writeInt(this.followerRestorePointEpoch);
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ListOffsetsPartitionResponse");
            }
            _size.addBytes(4);
            _size.addBytes(2);
            if (_version <= 0) {
                _size.addBytes(4);
                _size.addBytes(this.oldStyleOffsets.size() * 8);
            }
            if (_version >= 1) {
                _size.addBytes(8);
            }
            if (_version >= 1) {
                _size.addBytes(8);
            }
            if (_version >= 4) {
                _size.addBytes(4);
            }
            if (_version >= 6 && !this.followerRestorePointObjectId.equals((Object)Uuid.ZERO_UUID)) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(16);
            }
            if (_version >= 6 && this.followerRestorePointEpoch != 0) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(4);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 6) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListOffsetsPartitionResponse)) {
                return false;
            }
            ListOffsetsPartitionResponse other = (ListOffsetsPartitionResponse)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.oldStyleOffsets == null ? other.oldStyleOffsets != null : !this.oldStyleOffsets.equals(other.oldStyleOffsets)) {
                return false;
            }
            if (this.timestamp != other.timestamp) {
                return false;
            }
            if (this.offset != other.offset) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (!this.followerRestorePointObjectId.equals((Object)other.followerRestorePointObjectId)) {
                return false;
            }
            if (this.followerRestorePointEpoch != other.followerRestorePointEpoch) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.oldStyleOffsets == null ? 0 : this.oldStyleOffsets.hashCode());
            hashCode = 31 * hashCode + ((int)(this.timestamp >> 32) ^ (int)this.timestamp);
            hashCode = 31 * hashCode + ((int)(this.offset >> 32) ^ (int)this.offset);
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + this.followerRestorePointObjectId.hashCode();
            hashCode = 31 * hashCode + this.followerRestorePointEpoch;
            return hashCode;
        }

        public ListOffsetsPartitionResponse duplicate() {
            ListOffsetsPartitionResponse _duplicate = new ListOffsetsPartitionResponse();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.errorCode = this.errorCode;
            ArrayList<Long> newOldStyleOffsets = new ArrayList<Long>(this.oldStyleOffsets.size());
            for (Long _element : this.oldStyleOffsets) {
                newOldStyleOffsets.add(_element);
            }
            _duplicate.oldStyleOffsets = newOldStyleOffsets;
            _duplicate.timestamp = this.timestamp;
            _duplicate.offset = this.offset;
            _duplicate.leaderEpoch = this.leaderEpoch;
            _duplicate.followerRestorePointObjectId = this.followerRestorePointObjectId;
            _duplicate.followerRestorePointEpoch = this.followerRestorePointEpoch;
            return _duplicate;
        }

        public String toString() {
            return "ListOffsetsPartitionResponse(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", oldStyleOffsets=" + MessageUtil.deepToString(this.oldStyleOffsets.iterator()) + ", timestamp=" + this.timestamp + ", offset=" + this.offset + ", leaderEpoch=" + this.leaderEpoch + ", followerRestorePointObjectId=" + this.followerRestorePointObjectId.toString() + ", followerRestorePointEpoch=" + this.followerRestorePointEpoch + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public List<Long> oldStyleOffsets() {
            return this.oldStyleOffsets;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long offset() {
            return this.offset;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public Uuid followerRestorePointObjectId() {
            return this.followerRestorePointObjectId;
        }

        public int followerRestorePointEpoch() {
            return this.followerRestorePointEpoch;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ListOffsetsPartitionResponse setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public ListOffsetsPartitionResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public ListOffsetsPartitionResponse setOldStyleOffsets(List<Long> v) {
            this.oldStyleOffsets = v;
            return this;
        }

        public ListOffsetsPartitionResponse setTimestamp(long v) {
            this.timestamp = v;
            return this;
        }

        public ListOffsetsPartitionResponse setOffset(long v) {
            this.offset = v;
            return this;
        }

        public ListOffsetsPartitionResponse setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public ListOffsetsPartitionResponse setFollowerRestorePointObjectId(Uuid v) {
            this.followerRestorePointObjectId = v;
            return this;
        }

        public ListOffsetsPartitionResponse setFollowerRestorePointEpoch(int v) {
            this.followerRestorePointEpoch = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The partition error code, or 0 if there was no error."), new Field("timestamp", (Type)Type.INT64, "The timestamp associated with the returned offset."), new Field("offset", (Type)Type.INT64, "The returned offset.")}));
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The partition error code, or 0 if there was no error."), new Field("timestamp", (Type)Type.INT64, "The timestamp associated with the returned offset."), new Field("offset", (Type)Type.INT64, "The returned offset."), new Field("leader_epoch", (Type)Type.INT32, "")});
            SCHEMA_7 = SCHEMA_6 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The partition error code, or 0 if there was no error."), new Field("timestamp", (Type)Type.INT64, "The timestamp associated with the returned offset."), new Field("offset", (Type)Type.INT64, "The returned offset."), new Field("leader_epoch", (Type)Type.INT32, ""), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("follower_restore_point_object_id", (Type)Type.UUID, "The target objectId to restore from."), 1, new Field("follower_restore_point_epoch", (Type)Type.INT32, "The tier restore epoch to restore from.")})});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }

    public static class ListOffsetsTopicResponse
    implements Message {
        String name;
        List<ListOffsetsPartitionResponse> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name"), new Field("partitions", (Type)new ArrayOf((Type)ListOffsetsPartitionResponse.SCHEMA_0), "Each partition in the response.")});
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 7;

        public ListOffsetsTopicResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ListOffsetsTopicResponse() {
            this.name = "";
            this.partitions = new ArrayList<ListOffsetsPartitionResponse>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 7;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ArrayList<ListOffsetsPartitionResponse> newCollection;
            int arrayLength;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetsTopicResponse");
            }
            int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            if (_version >= 6) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new ListOffsetsPartitionResponse(_readable, _version, _context));
                }
                this.partitions = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<ListOffsetsPartitionResponse>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new ListOffsetsPartitionResponse(_readable, _version, _context));
                }
                this.partitions = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.name);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    ListOffsetsPartitionResponse partitionsElement = (ListOffsetsPartitionResponse)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version, _context);
                }
            } else {
                _writable.writeInt(this.partitions.size());
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    ListOffsetsPartitionResponse partitionsElement = (ListOffsetsPartitionResponse)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version, _context);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ListOffsetsTopicResponse");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.name).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            if (_version >= 6) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 6) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.partitions.size() + 1)));
            } else {
                _size.addBytes(4);
            }
            for (ListOffsetsPartitionResponse partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 6) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListOffsetsTopicResponse)) {
                return false;
            }
            ListOffsetsTopicResponse other = (ListOffsetsTopicResponse)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public ListOffsetsTopicResponse duplicate() {
            ListOffsetsTopicResponse _duplicate = new ListOffsetsTopicResponse();
            _duplicate.name = this.name;
            ArrayList<ListOffsetsPartitionResponse> newPartitions = new ArrayList<ListOffsetsPartitionResponse>(this.partitions.size());
            for (ListOffsetsPartitionResponse _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "ListOffsetsTopicResponse(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<ListOffsetsPartitionResponse> partitions() {
            return this.partitions;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ListOffsetsTopicResponse setName(String v) {
            this.name = v;
            return this;
        }

        public ListOffsetsTopicResponse setPartitions(List<ListOffsetsPartitionResponse> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name"), new Field("partitions", (Type)new ArrayOf((Type)ListOffsetsPartitionResponse.SCHEMA_1), "Each partition in the response.")}));
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name"), new Field("partitions", (Type)new ArrayOf((Type)ListOffsetsPartitionResponse.SCHEMA_4), "Each partition in the response.")});
            SCHEMA_7 = SCHEMA_6 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The topic name"), new Field("partitions", (Type)new CompactArrayOf((Type)ListOffsetsPartitionResponse.SCHEMA_6), "Each partition in the response."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }
}

