/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class SaslHandshakeRequestData
implements ApiMessage {
    String mechanism;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public SaslHandshakeRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public SaslHandshakeRequestData() {
        this.mechanism = "";
    }

    public short apiKey() {
        return 17;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        short length = _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field mechanism was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field mechanism had invalid length " + length);
        }
        this.mechanism = _readable.readString((int)length);
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.mechanism);
        _writable.writeShort((short)_stringBytes.length);
        _writable.writeByteArray(_stringBytes);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.mechanism.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'mechanism' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.mechanism, _stringBytes);
        _size.addBytes(_stringBytes.length + 2);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SaslHandshakeRequestData)) {
            return false;
        }
        SaslHandshakeRequestData other = (SaslHandshakeRequestData)obj;
        if (this.mechanism == null ? other.mechanism != null : !this.mechanism.equals(other.mechanism)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.mechanism == null ? 0 : this.mechanism.hashCode());
        return hashCode;
    }

    public SaslHandshakeRequestData duplicate() {
        SaslHandshakeRequestData _duplicate = new SaslHandshakeRequestData();
        _duplicate.mechanism = this.mechanism;
        return _duplicate;
    }

    public String toString() {
        return "SaslHandshakeRequestData(mechanism=" + (this.mechanism == null ? "null" : "'" + this.mechanism.toString() + "'") + ")";
    }

    public String mechanism() {
        return this.mechanism;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public SaslHandshakeRequestData setMechanism(String v) {
        this.mechanism = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("mechanism", (Type)Type.STRING, "The SASL mechanism chosen by the client.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

