/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.util.HashMap;
import java.util.Set;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.PlaintextChannelBuilder;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BrokerInterceptorTest {
    static final String CONNECTION_ID = "1";
    static final KafkaPrincipal TEST_PRINCIPAL = new KafkaPrincipal("user", "test-user");
    Time time;
    Metrics metrics;
    ChannelBuilder channelBuilder;
    Selector selector;
    InetAddress localhost;
    BrokerInterceptor mockBrokerInterceptor;

    @BeforeEach
    public void setUp() throws UnknownHostException {
        HashMap configs = new HashMap();
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.channelBuilder = new PlaintextChannelBuilder(Mode.SERVER, null, new ProxyProtocolEngineFactory(ProxyProtocol.NONE));
        this.channelBuilder.configure(configs);
        this.selector = new Selector(5000L, this.metrics, this.time, "MetricGroup", this.channelBuilder, new LogContext());
        this.mockBrokerInterceptor = (BrokerInterceptor)Mockito.mock(BrokerInterceptor.class);
        this.localhost = InetAddress.getLocalHost();
    }

    @Test
    public void testOnAuthenticatedConnectAndDisconnect() throws Exception {
        KafkaChannel kafkaChannel = (KafkaChannel)Mockito.mock(KafkaChannel.class);
        KafkaChannel.KafkaChannelMetrics kafkaChannelMetrics = (KafkaChannel.KafkaChannelMetrics)Mockito.mock(KafkaChannel.KafkaChannelMetrics.class);
        Mockito.when((Object)kafkaChannel.metrics()).thenReturn((Object)kafkaChannelMetrics);
        Mockito.when((Object)kafkaChannel.id()).thenReturn((Object)CONNECTION_ID);
        Mockito.when((Object)kafkaChannel.finishConnect()).thenReturn((Object)true);
        Mockito.when((Object)kafkaChannel.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)kafkaChannel.ready()).thenReturn((Object)false).thenReturn((Object)true);
        ((KafkaChannel)Mockito.doNothing().when((Object)kafkaChannel)).prepare();
        Mockito.when((Object)kafkaChannelMetrics.successfulAuthentications()).thenReturn((Object)1);
        Mockito.when((Object)kafkaChannel.interceptor()).thenReturn((Object)this.mockBrokerInterceptor);
        Mockito.when((Object)kafkaChannel.socketAddress()).thenReturn((Object)this.localhost);
        Mockito.when((Object)kafkaChannel.principal()).thenReturn((Object)TEST_PRINCIPAL);
        SelectionKey selectionKey = (SelectionKey)Mockito.mock(SelectionKey.class);
        Mockito.when((Object)kafkaChannel.selectionKey()).thenReturn((Object)selectionKey);
        Mockito.when((Object)selectionKey.isValid()).thenReturn((Object)true);
        Mockito.when((Object)selectionKey.attachment()).thenReturn((Object)kafkaChannel);
        selectionKey.attach(kafkaChannel);
        Set selectionKeys = Utils.mkSet((Object[])new SelectionKey[]{selectionKey});
        this.selector.pollSelectionKeys(selectionKeys, false, System.nanoTime());
        ((BrokerInterceptor)Mockito.verify((Object)this.mockBrokerInterceptor, (VerificationMode)Mockito.times((int)1))).onAuthenticatedConnection(CONNECTION_ID, this.localhost, TEST_PRINCIPAL, this.metrics);
        ((BrokerInterceptor)Mockito.verify((Object)this.mockBrokerInterceptor, (VerificationMode)Mockito.times((int)0))).onAuthenticatedDisconnection(CONNECTION_ID, this.localhost, TEST_PRINCIPAL, this.metrics);
        this.selector.close(kafkaChannel, Selector.CloseMode.DISCARD_NO_NOTIFY);
        ((BrokerInterceptor)Mockito.verify((Object)this.mockBrokerInterceptor, (VerificationMode)Mockito.times((int)1))).onAuthenticatedDisconnection(CONNECTION_ID, this.localhost, TEST_PRINCIPAL, this.metrics);
    }
}

