/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocolV1Engine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProxyProtocolV1EngineTest {
    private void putStreamAndFlip(ByteBuffer buf, String header) {
        buf.put(header.getBytes(StandardCharsets.US_ASCII));
        buf.flip();
    }

    @Test
    public void testProxyProtocolV1EngineBasic() throws IOException {
        ProxyProtocolV1Engine engine = new ProxyProtocolV1Engine();
        Assertions.assertFalse((boolean)engine.hasClientInformation());
        Assertions.assertFalse((boolean)engine.ready());
        Assertions.assertNull((Object)engine.clientAddress());
        ByteBuffer buf = ByteBuffer.allocate(108);
        this.putStreamAndFlip(buf, "PROXY TCP4 200.200.200.200 201.201.201.201 8888 9092\r\n");
        engine.processHeaders(buf);
        Assertions.assertTrue((boolean)engine.hasClientInformation());
        Assertions.assertTrue((boolean)engine.ready());
        InetAddress address = InetAddress.getByName("200.200.200.200");
        Assertions.assertEquals((Object)engine.clientAddress(), (Object)address);
        Assertions.assertEquals((int)engine.clientPort(), (int)8888);
    }

    @Test
    public void testProxyProtocolV1EngineIpv6() throws IOException {
        ProxyProtocolV1Engine engine = new ProxyProtocolV1Engine();
        Assertions.assertFalse((boolean)engine.hasClientInformation());
        Assertions.assertFalse((boolean)engine.ready());
        Assertions.assertNull((Object)engine.clientAddress());
        ByteBuffer buf = ByteBuffer.allocate(108);
        this.putStreamAndFlip(buf, "PROXY TCP6 2001:db8:85a3:8d3:1319:8a2e:370:7348 2001:db8:85a3:8d3:1319:8a2e:370:7349 8888 9092\r\n");
        engine.processHeaders(buf);
        Assertions.assertTrue((boolean)engine.hasClientInformation());
        Assertions.assertTrue((boolean)engine.ready());
        InetAddress address = InetAddress.getByName("2001:db8:85a3:8d3:1319:8a2e:370:7348");
        Assertions.assertEquals((Object)engine.clientAddress(), (Object)address);
        Assertions.assertEquals((int)engine.clientPort(), (int)8888);
    }

    @Test
    public void testProxyProtocolV1EngineWithMultipleSegments() throws IOException {
        ProxyProtocolV1Engine engine = new ProxyProtocolV1Engine();
        ByteBuffer buf = ByteBuffer.allocate(108);
        this.putStreamAndFlip(buf, "PRO");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertFalse((boolean)engine.hasClientInformation());
        Assertions.assertFalse((boolean)engine.ready());
        this.putStreamAndFlip(buf, "XY TCP4 200.200.200.200 201.201.201.201 88");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertFalse((boolean)engine.hasClientInformation());
        Assertions.assertFalse((boolean)engine.ready());
        this.putStreamAndFlip(buf, "88 9092\r\n");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertTrue((boolean)engine.hasClientInformation());
        Assertions.assertTrue((boolean)engine.ready());
        InetAddress address = InetAddress.getByName("200.200.200.200");
        Assertions.assertEquals((Object)engine.clientAddress(), (Object)address);
        Assertions.assertEquals((int)engine.clientPort(), (int)8888);
    }

    @Test
    public void testProxyProtocolV1EngineInvalidHeader() throws IOException {
        String[] headers;
        for (String header : headers = new String[]{"PROXY TCP4 \r\n", "PROXY TCP4 201.201.201.201 8888\r\n", "PROXY TCP4 200.200.200.200 201.201.201.201 8888 9092\r\r", "PROXY SMTP 200.200.200.200 201.201.201.201 8888 9092\r\n", "PROXY TCP hello.world 201.201.201.201 8888 9092\r\n", "PROXY TCP4                                                                                         200.200.200.200 201.201.201.201 8888 9092\n", "NOT A PROXY HEADER\n"}) {
            ProxyProtocolV1Engine engine = new ProxyProtocolV1Engine();
            ByteBuffer buf = ByteBuffer.allocate(1000);
            this.putStreamAndFlip(buf, header);
            Exception exception = (Exception)Assertions.assertThrows(IOException.class, () -> ProxyProtocolV1EngineTest.lambda$testProxyProtocolV1EngineInvalidHeader$0((ProxyProtocolEngine)engine, buf));
        }
    }

    @Test
    public void TestProxyProtocolV1EngineVerifyRemaining() throws IOException {
        ProxyProtocolV1Engine engine = new ProxyProtocolV1Engine();
        ByteBuffer buf = ByteBuffer.allocate(108);
        this.putStreamAndFlip(buf, "PROXY TCP4 200.200.200.200 201.201.201.201 8888 9092\r\nhello");
        engine.processHeaders(buf);
        Assertions.assertTrue((boolean)engine.hasClientInformation());
        Assertions.assertTrue((boolean)engine.ready());
        InetAddress address = InetAddress.getByName("200.200.200.200");
        Assertions.assertEquals((Object)engine.clientAddress(), (Object)address);
        Assertions.assertEquals((int)engine.clientPort(), (int)8888);
        Assertions.assertEquals((int)5, (int)buf.remaining());
    }

    @Test
    public void testNonProxyHeaderFallbackEnabled() throws IOException {
        ProxyProtocolV1Engine engine = new ProxyProtocolV1Engine();
        engine.configure(Collections.singletonMap("confluent.proxy.protocol.fallback.enabled", true));
        ByteBuffer buf = ByteBuffer.allocate(108);
        this.putStreamAndFlip(buf, "NOT A PROXY HEADER");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertFalse((boolean)engine.hasClientInformation());
        Assertions.assertTrue((boolean)engine.ready());
        buf.flip();
        Assertions.assertEquals((int)18, (int)buf.remaining());
    }

    @Test
    public void testNonProxyHeaderWithMultipleSegments() throws IOException {
        ProxyProtocolV1Engine engine = new ProxyProtocolV1Engine();
        engine.configure(Collections.singletonMap("confluent.proxy.protocol.fallback.enabled", true));
        ByteBuffer buf = ByteBuffer.allocate(108);
        this.putStreamAndFlip(buf, "NOT");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertFalse((boolean)engine.hasClientInformation());
        Assertions.assertFalse((boolean)engine.ready());
        this.putStreamAndFlip(buf, " ENOUGH BYTES IN FIRST CALL");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertFalse((boolean)engine.hasClientInformation());
        Assertions.assertTrue((boolean)engine.ready());
        buf.flip();
        Assertions.assertEquals((int)30, (int)buf.remaining());
    }

    private static /* synthetic */ void lambda$testProxyProtocolV1EngineInvalidHeader$0(ProxyProtocolEngine engine, ByteBuffer buf) throws Throwable {
        engine.processHeaders(buf);
    }
}

