/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.admin.AlterLeadershipPrioritySpec;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterLeadershipPriorityRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterLeadershipPriorityRequest;
import org.apache.kafka.common.requests.AlterLeadershipPriorityResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AlterLeadershipPriorityRequestTest {
    @Test
    public void testBrokerIdValidation() {
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validateRequestWithBrokerIds(Arrays.asList(-1)));
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validateRequestWithBrokerIds(Collections.emptyList()));
        this.validateRequestWithBrokerIds(Arrays.asList(1, 2));
    }

    @Test
    public void testReasonValidation() {
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validateRequestWithReason("."));
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validateRequestWithReason("$3"));
        this.validateRequestWithReason("valid-reason");
        this.validateRequestWithReason("valid-reason_123");
        this.validateRequestWithReason("7158");
        this.validateRequestWithReason("valid reason");
    }

    @Test
    public void testOperationValidation() {
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validatePriorityOperation((byte)2));
        Assertions.assertThrows(InvalidRequestException.class, () -> this.validatePriorityOperation((byte)100));
        this.validatePriorityOperation(AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE.id());
        this.validatePriorityOperation(AlterLeadershipPrioritySpec.PriorityOperationEnum.PROMOTE.id());
    }

    @Test
    public void testErrorCountsFromErrorResponse() {
        AlterLeadershipPriorityRequestData data = new AlterLeadershipPriorityRequestData().setBrokerIds(Arrays.asList(1, 2)).setReason("test").setPriorityOperationCode(AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE.id());
        AlterLeadershipPriorityResponse response = ((AlterLeadershipPriorityRequest)new AlterLeadershipPriorityRequest.Builder(data).build()).getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 2), (Object)response.errorCounts());
    }

    private void validateRequestWithReason(String reason) {
        AlterLeadershipPriorityRequestData data = new AlterLeadershipPriorityRequestData().setBrokerIds(Arrays.asList(0)).setReason(reason).setPriorityOperationCode(AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE.id());
        ((AlterLeadershipPriorityRequest)new AlterLeadershipPriorityRequest.Builder(data).build()).validate();
    }

    private void validatePriorityOperation(byte code) {
        AlterLeadershipPriorityRequestData data = new AlterLeadershipPriorityRequestData().setBrokerIds(Arrays.asList(0)).setReason("test").setPriorityOperationCode(code);
        ((AlterLeadershipPriorityRequest)new AlterLeadershipPriorityRequest.Builder(data).build()).validate();
    }

    private void validateRequestWithBrokerIds(List<Integer> brokerIds) {
        AlterLeadershipPriorityRequestData data = new AlterLeadershipPriorityRequestData().setBrokerIds(brokerIds).setReason("test").setPriorityOperationCode(AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE.id());
        ((AlterLeadershipPriorityRequest)new AlterLeadershipPriorityRequest.Builder(data).build()).validate();
    }
}

