/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.clients.admin.AlterLeadershipPrioritySpec;
import org.apache.kafka.common.message.AlterLeadershipPriorityResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterLeadershipPriorityResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AlterLeadershipPriorityResponseTest {
    @Test
    public void testErrorCountsFromTopLevelFailure() {
        AlterLeadershipPriorityResponseData data = new AlterLeadershipPriorityResponseData().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code());
        AlterLeadershipPriorityResponse response = new AlterLeadershipPriorityResponse(data);
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsFromTopLevelFailureAndMultipleBrokers() {
        AlterLeadershipPriorityResponseData data = new AlterLeadershipPriorityResponseData().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setBrokerLeadershipPriorityResults(Arrays.asList(new AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult().setBrokerId(0).setLeadershipPriority(AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE.id()), new AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult().setBrokerId(1).setLeadershipPriority(AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE.id())));
        AlterLeadershipPriorityResponse response = new AlterLeadershipPriorityResponse(data);
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 2), (Object)response.errorCounts());
    }
}

