/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.LogDirNotFoundException;
import org.apache.kafka.common.message.AlterReplicaLogDirsRequestData;
import org.apache.kafka.common.message.AlterReplicaLogDirsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AlterReplicaLogDirsRequestTest {
    @Test
    public void testErrorResponse() {
        AlterReplicaLogDirsRequestData data = new AlterReplicaLogDirsRequestData().setDirs(new AlterReplicaLogDirsRequestData.AlterReplicaLogDirCollection(Collections.singletonList(new AlterReplicaLogDirsRequestData.AlterReplicaLogDir().setPath("/data0").setTopics(new AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopicCollection(Collections.singletonList(new AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopic().setName("topic").setPartitions(Arrays.asList(0, 1, 2))).iterator()))).iterator()));
        AlterReplicaLogDirsResponse errorResponse = ((AlterReplicaLogDirsRequest)new AlterReplicaLogDirsRequest.Builder(data).build()).getErrorResponse(123, (Throwable)new LogDirNotFoundException("/data0"));
        Assertions.assertEquals((int)1, (int)errorResponse.data().results().size());
        AlterReplicaLogDirsResponseData.AlterReplicaLogDirTopicResult topicResponse = errorResponse.data().results().get(0);
        Assertions.assertEquals((Object)"topic", (Object)topicResponse.topicName());
        Assertions.assertEquals((int)3, (int)topicResponse.partitions().size());
        for (int i = 0; i < 3; ++i) {
            Assertions.assertEquals((int)i, (int)topicResponse.partitions().get(i).partitionIndex());
            Assertions.assertEquals((short)Errors.LOG_DIR_NOT_FOUND.code(), (short)topicResponse.partitions().get(i).errorCode());
        }
    }

    @Test
    public void testPartitionDir() {
        AlterReplicaLogDirsRequestData data = new AlterReplicaLogDirsRequestData().setDirs(new AlterReplicaLogDirsRequestData.AlterReplicaLogDirCollection(Arrays.asList(new AlterReplicaLogDirsRequestData.AlterReplicaLogDir().setPath("/data0").setTopics(new AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopicCollection(Arrays.asList(new AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopic().setName("topic").setPartitions(Arrays.asList(0, 1)), new AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopic().setName("topic2").setPartitions(Arrays.asList(7))).iterator())), new AlterReplicaLogDirsRequestData.AlterReplicaLogDir().setPath("/data1").setTopics(new AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopicCollection(Arrays.asList(new AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopic().setName("topic3").setPartitions(Arrays.asList(12))).iterator()))).iterator()));
        AlterReplicaLogDirsRequest request = (AlterReplicaLogDirsRequest)new AlterReplicaLogDirsRequest.Builder(data).build();
        HashMap<TopicPartition, String> expect = new HashMap<TopicPartition, String>();
        expect.put(new TopicPartition("topic", 0), "/data0");
        expect.put(new TopicPartition("topic", 1), "/data0");
        expect.put(new TopicPartition("topic2", 7), "/data0");
        expect.put(new TopicPartition("topic3", 12), "/data1");
        Assertions.assertEquals(expect, (Object)request.partitionDirs());
    }
}

