/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.message.ComputeEvenClusterLoadPlanResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ComputeEvenClusterLoadPlanRequest;
import org.apache.kafka.common.requests.ComputeEvenClusterLoadPlanResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ComputeEvenClusterLoadPlanResponseTest {
    @Test
    public void testErrorCounts() {
        ComputeEvenClusterLoadPlanRequest request = (ComputeEvenClusterLoadPlanRequest)new ComputeEvenClusterLoadPlanRequest.Builder().build();
        ComputeEvenClusterLoadPlanResponse response = request.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)response.errorCounts());
    }

    @Test
    public void testResponseFields() {
        ComputeEvenClusterLoadPlanResponse response = this.getTestResponse();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode());
        Assertions.assertEquals((Object)Errors.NONE.message(), (Object)response.data().errorMessage());
        Assertions.assertEquals((int)14, (int)response.data().interBrokerMoves());
        Assertions.assertEquals(Arrays.asList(1, 3), response.data().deadOrRemovedBrokers());
        Assertions.assertTrue((boolean)response.data().violatedGoalsBeforeOptimization().stream().anyMatch(g -> g.equals("DiskUsageDistributionGoal")));
        Assertions.assertTrue((boolean)response.data().violatedGoalsAfterOptimization().stream().anyMatch(g -> g.equals("CpuUsageDistributionGoal")));
        Assertions.assertEquals((int)18, (int)response.data().totalBrokers());
        Assertions.assertEquals((double)97.115, (double)response.data().balancednessScorePostRebalance());
        Assertions.assertEquals((Object)"ReplicaPlacementGoal", (Object)response.data().goalStats().get(0).goalName());
        Assertions.assertEquals((double)28.835, (double)response.data().goalStats().get(0).avgResources().cpuPercent());
        Assertions.assertEquals((int)2, (int)response.data().clusterLoadPreRebalance().size());
        Assertions.assertEquals((int)2, (int)response.data().clusterLoadPostRebalance().size());
        Assertions.assertEquals((Object)"host1", (Object)response.data().clusterLoadPreRebalance().get(0).host());
        Assertions.assertEquals((Object)"host1", (Object)response.data().clusterLoadPostRebalance().get(0).host());
        Assertions.assertEquals((int)15, (int)response.data().clusterLoadPostRebalance().get(1).replicas());
    }

    private ComputeEvenClusterLoadPlanResponse getTestResponse() {
        return new ComputeEvenClusterLoadPlanResponse(new ComputeEvenClusterLoadPlanResponseData().setErrorCode(Errors.NONE.code()).setErrorMessage(Errors.NONE.message()).setInterBrokerMoves(14).setInterBrokerMovesMB(34858.0).setLeadershipMoves(12).setRecentWindows(6).setPartitionCoveragePercent(100.0).setNewBrokers(Arrays.asList(5, 7)).setDeadOrRemovedBrokers(Arrays.asList(1, 3)).setViolatedGoalsBeforeOptimization(Arrays.asList("LeaderBytesInDistributionGoal", "NetworkInboundUsageDistributionGoal", "CpuUsageDistributionGoal", "DiskUsageDistributionGoal", "NetworkOutboundUsageDistributionGoal")).setViolatedGoalsAfterOptimization(Arrays.asList("CpuUsageDistributionGoal")).setMovementGeneratingGoals(Arrays.asList("LeaderBytesInDistributionGoal", "NetworkInboundUsageDistributionGoal", "CpuUsageDistributionGoal", "DiskUsageDistributionGoal", "NetworkOutboundUsageDistributionGoal")).setExcludedTopics(Arrays.asList("lkc-*****__confluent-healthcheck_362")).setBrokersExcludedForLeadership(Arrays.asList(0, 3)).setBrokersExcludedForReplicaMove(Arrays.asList(6, 7, 8, 9, 10, 11)).setTotalBrokers(18).setTotalReplicas(947).setTotalTopics(19).setBalancednessScorePreRebalance(83.842).setBalancednessScorePostRebalance(97.115).setGoalStats(Arrays.asList(new ComputeEvenClusterLoadPlanResponseData.GoalStat().setGoalName("ReplicaPlacementGoal").setAvgResources(new ComputeEvenClusterLoadPlanResponseData.AvgResources().setCpuPercent(28.835).setNetworkInboundKBps(28240.951).setNetworkOutboundKBps(27849.211).setDiskMB(45366.01).setPotentialNwOutKBps(87839.004).setReplicas(158).setLeaderReplicas(52).setTopicReplicas(8)).setMaxResources(new ComputeEvenClusterLoadPlanResponseData.MaxResources().setCpuPercent(34.145).setNetworkInboundKBps(32054.334).setNetworkOutboundKBps(34599.855).setDiskMB(54622.617).setPotentialNwOutKBps(95007.256).setReplicas(173).setLeaderReplicas(58).setTopicReplicas(50)).setMinResources(new ComputeEvenClusterLoadPlanResponseData.MinResources().setCpuPercent(23.694).setNetworkInboundKBps(23647.879).setNetworkOutboundKBps(23185.646).setDiskMB(35209.719).setPotentialNwOutKBps(75145.148).setReplicas(143).setLeaderReplicas(47).setTopicReplicas(0)).setStdResources(new ComputeEvenClusterLoadPlanResponseData.StdResources().setCpuPercent(3.796).setNetworkInboundKBps(2818.515).setNetworkOutboundKBps(3707.753).setDiskMB(8347.475).setPotentialNwOutKBps(6810.038).setReplicas(14).setLeaderReplicas(5).setTopicReplicas(6)).setGoalOverview(new ComputeEvenClusterLoadPlanResponseData.GoalOverview().setProposalsGenerated(0).setProposalsRejected(0).setProposalsRejectedPercent(0.0).setProposalsAccepted(0).setProposalsAcceptedPercent(0.0).setMoves(0).setSwaps(0)))).setClusterLoadPreRebalance(Arrays.asList(new ComputeEvenClusterLoadPlanResponseData.PreBrokerStat().setBrokerId(0).setHost("host1").setDiskMB(10.0).setDiskPercent(50.0).setCpuPercent(50.0).setLeaderNetworkInKBps(20.0).setFollowerNetworkInKBps(20.0).setNetworkOutKBps(20.0).setPotentialNetworkOutKBps(60.0).setLeaders(5).setReplicas(15), new ComputeEvenClusterLoadPlanResponseData.PreBrokerStat().setBrokerId(1).setHost("host2").setDiskMB(10.0).setDiskPercent(50.0).setCpuPercent(50.0).setLeaderNetworkInKBps(20.0).setFollowerNetworkInKBps(20.0).setNetworkOutKBps(20.0).setPotentialNetworkOutKBps(60.0).setLeaders(5).setReplicas(15))).setClusterLoadPostRebalance(Arrays.asList(new ComputeEvenClusterLoadPlanResponseData.PostBrokerStat().setBrokerId(0).setHost("host1").setDiskMB(10.0).setDiskPercent(50.0).setCpuPercent(50.0).setLeaderNetworkInKBps(20.0).setFollowerNetworkInKBps(20.0).setNetworkOutKBps(20.0).setPotentialNetworkOutKBps(60.0).setLeaders(5).setReplicas(15), new ComputeEvenClusterLoadPlanResponseData.PostBrokerStat().setBrokerId(1).setHost("host2").setDiskMB(10.0).setDiskPercent(50.0).setCpuPercent(50.0).setLeaderNetworkInKBps(20.0).setFollowerNetworkInKBps(20.0).setNetworkOutKBps(20.0).setPotentialNetworkOutKBps(60.0).setLeaders(5).setReplicas(15))));
    }
}

