/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Map;
import org.apache.kafka.common.message.DescribeBrokerAdditionsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.DescribeBrokerAdditionsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DescribeBrokerAdditionsResponseTest {
    @Test
    public void testErrorCountsWithTopLevelError() {
        DescribeBrokerAdditionsResponseData data = new DescribeBrokerAdditionsResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage("This broker is not the controller").setBrokerAdditions(Arrays.asList(new DescribeBrokerAdditionsResponseData.BrokerAdditionsResponse().setBrokerId(1).setAdditionErrorCode(Errors.REBALANCE_PLAN_COMPUTATION_FAILED.code()), new DescribeBrokerAdditionsResponseData.BrokerAdditionsResponse().setBrokerId(2)));
        Map errorCounts = new DescribeBrokerAdditionsResponse(data).errorCounts();
        Assertions.assertEquals((int)1, (int)errorCounts.size());
        Assertions.assertEquals((Integer)1, (Integer)((Integer)errorCounts.get(Errors.NOT_CONTROLLER)));
    }

    @Test
    public void testErrorCountsWithNoTopLevelErrorShouldReturnZeroCountOfErrors() {
        DescribeBrokerAdditionsResponseData data = new DescribeBrokerAdditionsResponseData().setErrorCode(Errors.NONE.code()).setBrokerAdditions(Arrays.asList(new DescribeBrokerAdditionsResponseData.BrokerAdditionsResponse().setBrokerId(0).setAdditionErrorCode(Errors.REBALANCE_PLAN_COMPUTATION_FAILED.code()), new DescribeBrokerAdditionsResponseData.BrokerAdditionsResponse().setBrokerId(1).setAdditionErrorCode(Errors.BALANCER_OPERATION_OVERRIDDEN.code()), new DescribeBrokerAdditionsResponseData.BrokerAdditionsResponse().setBrokerId(2).setAdditionErrorCode(Errors.NONE.code()), new DescribeBrokerAdditionsResponseData.BrokerAdditionsResponse().setBrokerId(1).setAdditionErrorCode(Errors.UNKNOWN_SERVER_ERROR.code())));
        Map errorCounts = new DescribeBrokerAdditionsResponse(data).errorCounts();
        Assertions.assertEquals((int)1, (int)errorCounts.size());
        Assertions.assertEquals((Integer)1, (Integer)((Integer)errorCounts.get(Errors.NONE)));
    }
}

